/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.geode.internal.lang.MutableIdentifiable;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;

public class DiskStoreDetails
implements Comparable<DiskStoreDetails>,
MutableIdentifiable<UUID>,
Iterable<DiskDirDetails>,
Serializable {
    public static final String DEFAULT_DISK_STORE_NAME = "DEFAULT";
    protected static final boolean DEFAULT_ALLOW_FORCE_COMPACTION = false;
    protected static final boolean DEFAULT_AUTO_COMPACT = true;
    protected static final int DEFAULT_COMPACTION_THRESHOLD = 50;
    protected static final int DEFAULT_QUEUE_SIZE = 0;
    protected static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    protected static final long DEFAULT_MAX_OPLOG_SIZE = 1024L;
    protected static final long DEFAULT_TIME_INTERVALE = 1000L;
    private Boolean allowForceCompaction;
    private Boolean autoCompact;
    private Boolean offline;
    private Boolean pdxSerializationMetaDataStored;
    private Integer compactionThreshold;
    private Integer queueSize;
    private Integer writeBufferSize;
    private Float diskUsageWarningPercentage;
    private Float diskUsageCriticalPercentage;
    private Set<AsyncEventQueueDetails> asyncEventQueueDetailsSet = new TreeSet<AsyncEventQueueDetails>();
    private Set<CacheServerDetails> cacheServerDetailsSet = new TreeSet<CacheServerDetails>();
    private Set<DiskDirDetails> diskDirDetailsSet = new TreeSet<DiskDirDetails>();
    private Set<GatewayDetails> gatewayDetailsSet = new TreeSet<GatewayDetails>();
    private Set<RegionDetails> regionDetailsSet = new TreeSet<RegionDetails>();
    private Long maxOplogSize;
    private Long timeInterval;
    private final String memberId;
    private String memberName;
    private final String name;
    private UUID id;

    protected static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    protected static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return obj1 == null && obj2 == null ? 0 : (obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2)));
    }

    public DiskStoreDetails(String name, String memberId) {
        this(null, name, memberId, null);
    }

    public DiskStoreDetails(UUID id, String name, String memberId) {
        this(id, name, memberId, null);
    }

    public DiskStoreDetails(UUID id, String name, String memberId, String memberName) {
        DiskStoreDetails.assertNotNull(name, "The name of the disk store cannot be null!", new Object[0]);
        DiskStoreDetails.assertNotNull(memberId, "The id of the member to which the disk store (%1$s) belongs cannot be null!", name);
        this.id = id;
        this.name = name;
        this.memberId = memberId;
        this.memberName = memberName;
    }

    public Boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    public boolean isAllowForceCompaction() {
        return Boolean.TRUE.equals(this.getAllowForceCompaction());
    }

    public void setAllowForceCompaction(Boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
    }

    public Boolean getAutoCompact() {
        return this.autoCompact;
    }

    public boolean isAutoCompact() {
        return Boolean.TRUE.equals(this.getAutoCompact());
    }

    public void setAutoCompact(Boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public Integer getCompactionThreshold() {
        return this.compactionThreshold;
    }

    public void setCompactionThreshold(Integer compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public Long getMaxOplogSize() {
        return this.maxOplogSize;
    }

    public void setMaxOplogSize(Long maxOplogSize) {
        this.maxOplogSize = maxOplogSize;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public String getOfflineAsString(String online, String offline, String nullValue) {
        return this.getOffline() == null ? nullValue : (this.isOffline() ? offline : online);
    }

    public boolean isOffline() {
        return Boolean.TRUE.equals(this.getOffline());
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public Boolean getPdxSerializationMetaDataStored() {
        return this.pdxSerializationMetaDataStored;
    }

    public boolean isPdxSerializationMetaDataStored() {
        return Boolean.TRUE.equals(this.getPdxSerializationMetaDataStored());
    }

    public void setPdxSerializationMetaDataStored(Boolean pdxSerializationMetaDataStored) {
        this.pdxSerializationMetaDataStored = pdxSerializationMetaDataStored;
    }

    public Integer getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public Long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(Long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public Float getDiskUsageWarningPercentage() {
        return this.diskUsageWarningPercentage;
    }

    public void setDiskUsageWarningPercentage(Float warningPct) {
        this.diskUsageWarningPercentage = warningPct;
    }

    public Float getDiskUsageCriticalPercentage() {
        return this.diskUsageCriticalPercentage;
    }

    public void setDiskUsageCriticalPercentage(Float criticalPct) {
        this.diskUsageCriticalPercentage = criticalPct;
    }

    public boolean add(AsyncEventQueueDetails asyncEventQueueDetails) {
        DiskStoreDetails.assertNotNull(asyncEventQueueDetails, "Details concerning Asynchronous Event Queues that use this disk store ($1%s) cannot be null!", this.getName());
        return this.asyncEventQueueDetailsSet.add(asyncEventQueueDetails);
    }

    public boolean add(CacheServerDetails cacheServerDetails) {
        DiskStoreDetails.assertNotNull(cacheServerDetails, "Details concerning Cache Servers that use this disk store (%1$s) cannot be null!", this.getName());
        return this.cacheServerDetailsSet.add(cacheServerDetails);
    }

    public boolean add(DiskDirDetails diskDirDetails) {
        DiskStoreDetails.assertNotNull(diskDirDetails, "Details for the disk store's (%1$s) directory information cannot be null!", this.getName());
        return this.diskDirDetailsSet.add(diskDirDetails);
    }

    public boolean add(GatewayDetails gatewayDetails) {
        DiskStoreDetails.assertNotNull(gatewayDetails, "Details concerning Gateways that use this disk store (%1$s) cannot be null!", this.getName());
        return this.gatewayDetailsSet.add(gatewayDetails);
    }

    public boolean add(RegionDetails regionDetails) {
        DiskStoreDetails.assertNotNull(regionDetails, "Details concerning Regions that use this disk store (%1$%s) cannot be null!", this.getName());
        return this.regionDetailsSet.add(regionDetails);
    }

    @Override
    public int compareTo(DiskStoreDetails diskStoreDetails) {
        int comparisonValue = DiskStoreDetails.compare(this.getMemberName(), diskStoreDetails.getMemberName());
        comparisonValue = comparisonValue != 0 ? comparisonValue : DiskStoreDetails.compare(this.getMemberId(), diskStoreDetails.getMemberId());
        return comparisonValue != 0 ? comparisonValue : this.getName().compareTo(diskStoreDetails.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskStoreDetails)) {
            return false;
        }
        DiskStoreDetails that = (DiskStoreDetails)obj;
        return ObjectUtils.equalsIgnoreNull(this.getId(), that.getId()) && ObjectUtils.equals(this.getName(), that.getName()) && ObjectUtils.equals(this.getMemberId(), that.getMemberId());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getId());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getName());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getMemberId());
        return hashValue;
    }

    @Override
    public Iterator<DiskDirDetails> iterator() {
        return Collections.unmodifiableSet(this.diskDirDetailsSet).iterator();
    }

    public Iterable<AsyncEventQueueDetails> iterateAsyncEventQueues() {
        return Collections.unmodifiableSet(this.asyncEventQueueDetailsSet);
    }

    public Iterable<CacheServerDetails> iterateCacheServers() {
        return Collections.unmodifiableSet(this.cacheServerDetailsSet);
    }

    public Iterable<GatewayDetails> iterateGateways() {
        return Collections.unmodifiableSet(this.gatewayDetailsSet);
    }

    public Iterable<RegionDetails> iterateRegions() {
        return Collections.unmodifiableSet(this.regionDetailsSet);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" {id = ").append(this.getId());
        buffer.append(", allowForceCompaction = ").append(this.getAllowForceCompaction());
        buffer.append(", autoCompact = ").append(this.getAutoCompact());
        buffer.append(", compactionThreshold = ").append(this.getCompactionThreshold());
        buffer.append(", maxOplogSize = ").append(this.getMaxOplogSize());
        buffer.append(", memberId = ").append(this.getMemberId());
        buffer.append(", memberName = ").append(this.getMemberName());
        buffer.append(", name = ").append(this.getName());
        buffer.append(", offline = ").append(this.getOffline());
        buffer.append(", pdxSerializationMetaDataStored = ").append(this.getPdxSerializationMetaDataStored());
        buffer.append(", queueSize = ").append(this.getQueueSize());
        buffer.append(", timeInterval = ").append(this.getTimeInterval());
        buffer.append(", writeBufferSize = ").append(this.getWriteBufferSize());
        buffer.append(", diskUsageWarningPercentage = ").append(this.getDiskUsageWarningPercentage());
        buffer.append(", diskUsageCriticalPercentage = ").append(this.getDiskUsageCriticalPercentage());
        buffer.append(", diskDirs = ").append(this.toString(this.diskDirDetailsSet));
        buffer.append(", asyncEventQueus = ").append(this.toString(this.asyncEventQueueDetailsSet));
        buffer.append(", cacheServers = ").append(this.toString(this.cacheServerDetailsSet));
        buffer.append(", gateways = ").append(this.toString(this.gatewayDetailsSet));
        buffer.append(", regions = ").append(this.toString(this.regionDetailsSet));
        buffer.append("}");
        return buffer.toString();
    }

    protected String toString(Collection<?> collection) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        for (Object element : collection) {
            buffer.append(count++ > 0 ? ", " : "");
            buffer.append(element);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static class RegionDetails
    implements Comparable<RegionDetails>,
    Serializable {
        private boolean overflowToDisk;
        private boolean persistent;
        private final String fullPath;
        private final String name;

        public RegionDetails(String fullPath, String name) {
            DiskStoreDetails.assertNotNull(fullPath, "The full path of the Region in the Cache cannot be null!", new Object[0]);
            DiskStoreDetails.assertNotNull(name, "The name of the Region @ (%1$s) cannot be null!", fullPath);
            this.name = name;
            this.fullPath = fullPath;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOverflowToDisk() {
            return this.overflowToDisk;
        }

        public void setOverflowToDisk(boolean overflowToDisk) {
            this.overflowToDisk = overflowToDisk;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public int compareTo(RegionDetails regionDetails) {
            return this.getFullPath().compareTo(regionDetails.getFullPath());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RegionDetails)) {
                return false;
            }
            RegionDetails that = (RegionDetails)obj;
            return ObjectUtils.equals(this.getFullPath(), that.getFullPath());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getFullPath());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {fullPath = ").append(this.getFullPath());
            buffer.append(", name = ").append(this.getName());
            buffer.append(", overflowToDisk = ").append(this.isOverflowToDisk());
            buffer.append(", persistent = ").append(this.isPersistent());
            buffer.append("}");
            return buffer.toString();
        }
    }

    public static class GatewayDetails
    implements Comparable<GatewayDetails>,
    Serializable {
        private boolean persistent;
        private final String id;

        public GatewayDetails(String id) {
            DiskStoreDetails.assertNotNull(id, "The ID of the Gateway cannot be null!", new Object[0]);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean isOverflowToDisk() {
            return true;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public int compareTo(GatewayDetails gatewayDetails) {
            return this.getId().compareTo(gatewayDetails.getId());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GatewayDetails)) {
                return false;
            }
            GatewayDetails that = (GatewayDetails)obj;
            return ObjectUtils.equals(this.getId(), that.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getId());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {id = ").append(this.getId());
            buffer.append(", overflowToDisk = ").append(this.isOverflowToDisk());
            buffer.append(", persistent = ").append(this.isPersistent());
            buffer.append("}");
            return buffer.toString();
        }
    }

    public static class DiskDirDetails
    implements Comparable<DiskDirDetails>,
    Serializable {
        private final String absolutePath;
        private final int size;

        public DiskDirDetails(String absolutePath) {
            this(absolutePath, 0);
        }

        public DiskDirDetails(String absolutePath, int size) {
            DiskStoreDetails.assertNotNull(absolutePath, "The directory location of the disk store cannot be null!", new Object[0]);
            this.absolutePath = absolutePath;
            this.size = size;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public int compareTo(DiskDirDetails diskDirDetails) {
            return this.getAbsolutePath().compareTo(diskDirDetails.getAbsolutePath());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DiskDirDetails)) {
                return false;
            }
            DiskDirDetails that = (DiskDirDetails)obj;
            return ObjectUtils.equals(this.getAbsolutePath(), that.getAbsolutePath());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getAbsolutePath());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {absolutePath = ").append(this.getAbsolutePath());
            buffer.append(", size = ").append(this.getSize());
            buffer.append("}");
            return buffer.toString();
        }
    }

    public static class CacheServerDetails
    implements Comparable<CacheServerDetails>,
    Serializable {
        private final int port;
        private final String bindAddress;
        private String hostName;

        public CacheServerDetails(String bindAddress, int port) {
            this.bindAddress = StringUtils.defaultIfBlank(bindAddress, "*");
            this.port = port;
        }

        public String getBindAddress() {
            return this.bindAddress;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public int compareTo(CacheServerDetails cacheServerDetails) {
            int valueOfBindAddressComparison = this.getBindAddress().compareTo(cacheServerDetails.getBindAddress());
            return valueOfBindAddressComparison != 0 ? valueOfBindAddressComparison : this.getPort() - cacheServerDetails.getPort();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheServerDetails)) {
                return false;
            }
            CacheServerDetails that = (CacheServerDetails)obj;
            return ObjectUtils.equals(this.getBindAddress(), that.getBindAddress()) && ObjectUtils.equals(this.getPort(), that.getPort());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getBindAddress());
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getPort());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {bindAddress = ").append(this.getBindAddress());
            buffer.append(", hostName = ").append(this.getHostName());
            buffer.append(", port = ").append(this.getPort());
            buffer.append("}");
            return buffer.toString();
        }
    }

    public static class AsyncEventQueueDetails
    implements Comparable<AsyncEventQueueDetails>,
    Serializable {
        private final String id;

        public AsyncEventQueueDetails(String id) {
            DiskStoreDetails.assertNotNull(id, "The id of the Asynchronous Event Queue cannot be null!", new Object[0]);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int compareTo(AsyncEventQueueDetails asyncEventQueueDetails) {
            return this.getId().compareTo(asyncEventQueueDetails.getId());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AsyncEventQueueDetails)) {
                return false;
            }
            AsyncEventQueueDetails that = (AsyncEventQueueDetails)obj;
            return ObjectUtils.equals(this.getId(), that.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getId());
            return hashValue;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {id =").append(this.getId());
            buffer.append("}");
            return buffer.toString();
        }
    }
}

