/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.dto;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.CliJsonSerializable;
import org.apache.geode.management.internal.cli.util.JsonUtil;

public class RegionAttributesInfo
implements CliJsonSerializable {
    private static Map<String, String> nameToDisplayName = new HashMap<String, String>();
    private String cacheLoader;
    private String cacheWriter;
    private String keyConstraint;
    private String valueConstraint;
    private String[] fieldsToSkipOnUI;

    public RegionAttributesInfo() {
    }

    public RegionAttributesInfo(String cacheLoader, String cacheWriter, String keyConstraint, String valueConstraint) {
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
        this.keyConstraint = keyConstraint;
        this.valueConstraint = valueConstraint;
    }

    public String getCacheLoader() {
        return this.cacheLoader;
    }

    public String getCacheWriter() {
        return this.cacheWriter;
    }

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    @Override
    public String[] getFieldsToSkipOnUI() {
        return this.fieldsToSkipOnUI;
    }

    @Override
    public void setFieldsToSkipOnUI(String ... fieldsToSkipOnUI) {
        this.fieldsToSkipOnUI = fieldsToSkipOnUI;
    }

    @Override
    public int getJSId() {
        return 12;
    }

    @Override
    public Map<String, String> getFieldNameToDisplayName() {
        return nameToDisplayName;
    }

    @Override
    public void fromJson(GfJsonObject objectStateAsjson) {
        this.cacheLoader = JsonUtil.getString(objectStateAsjson, "cacheLoader");
        this.cacheWriter = JsonUtil.getString(objectStateAsjson, "cacheWriter");
        this.keyConstraint = JsonUtil.getString(objectStateAsjson, "keyConstraint");
        this.valueConstraint = JsonUtil.getString(objectStateAsjson, "valueConstraint");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheLoader == null ? 0 : this.cacheLoader.hashCode());
        result = 31 * result + (this.cacheWriter == null ? 0 : this.cacheWriter.hashCode());
        result = 31 * result + Arrays.hashCode(this.fieldsToSkipOnUI);
        result = 31 * result + (this.keyConstraint == null ? 0 : this.keyConstraint.hashCode());
        result = 31 * result + (this.valueConstraint == null ? 0 : this.valueConstraint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionAttributesInfo other = (RegionAttributesInfo)obj;
        if (this.cacheLoader == null ? other.cacheLoader != null : !this.cacheLoader.equals(other.cacheLoader)) {
            return false;
        }
        if (this.cacheWriter == null ? other.cacheWriter != null : !this.cacheWriter.equals(other.cacheWriter)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsToSkipOnUI, other.fieldsToSkipOnUI)) {
            return false;
        }
        if (this.keyConstraint == null ? other.keyConstraint != null : !this.keyConstraint.equals(other.keyConstraint)) {
            return false;
        }
        return !(this.valueConstraint == null ? other.valueConstraint != null : !this.valueConstraint.equals(other.valueConstraint));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionAttributesInfo [cacheLoader=");
        builder.append(this.cacheLoader);
        builder.append(", cacheWriter=");
        builder.append(this.cacheWriter);
        builder.append(", keyConstraint=");
        builder.append(this.keyConstraint);
        builder.append(", valueConstraint=");
        builder.append(this.valueConstraint);
        builder.append("]");
        return builder.toString();
    }

    static {
        nameToDisplayName.put("cacheLoader", "Cache Loader");
        nameToDisplayName.put("cacheWriter", "Cache Writer");
        nameToDisplayName.put("keyConstraint", "Key Constraint");
        nameToDisplayName.put("valueConstraint", "Value Constraint");
    }
}

