/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverCreateFunction;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.functions.GatewaySenderCreateFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.SharedConfigurationWriter;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class WanCommands
implements CommandMarker {
    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"create gateway-sender"}, help="Create the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"}, writesToSharedConfiguration=true)
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createGatewaySender(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to create the Gateway Sender.") @CliMetaData(valueSeparator=",") String[] onGroups, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Name/Id of the member on which to create the Gateway Sender.") @CliMetaData(valueSeparator=",") String onMember, @CliOption(key={"id"}, mandatory=true, help="Id of the GatewaySender.") String id, @CliOption(key={"remote-distributed-system-id"}, mandatory=true, help="Id of the remote distributed system to which the sender will send events.") Integer remoteDistributedSystemId, @CliOption(key={"parallel"}, help="Whether this is Parallel GatewaySender.") Boolean parallel, @CliOption(key={"manual-start"}, help="Whether manual start is to be enabled or the sender will start automatically after creation.") Boolean manualStart, @CliOption(key={"socket-buffer-size"}, help="The buffer size of the socket connection between this GatewaySender and its receiving GatewayReceiver.") Integer socketBufferSize, @CliOption(key={"socket-read-timeout"}, help="The amount of time in milliseconds that a socket read between a sending GatewaySender and its receiving GatewayReceiver will block.") Integer socketReadTimeout, @CliOption(key={"enable-batch-conflation"}, help="Whether batch conflation is to be enabled for a GatewaySender.") Boolean enableBatchConflation, @CliOption(key={"batch-size"}, help="The batch size for the GatewaySender.") Integer batchSize, @CliOption(key={"batch-time-interval"}, help="The batch time interval for the GatewaySender.") Integer batchTimeInterval, @CliOption(key={"enable-persistence"}, help="Whether persistence is to be enabled for the GatewaySender.") Boolean enablePersistence, @CliOption(key={"disk-store-name"}, help="The disk store name to be configured for overflow or persistence.") String diskStoreName, @CliOption(key={"disk-synchronous"}, help="Whether writes to the disk in case of persistence are synchronous.") Boolean diskSynchronous, @CliOption(key={"maximum-queue-memory"}, help="The maximum amount of memory (in MB) for a GatewaySender's queue.") Integer maxQueueMemory, @CliOption(key={"alert-threshold"}, help="The alert threshold for entries in a GatewaySender's queue.") Integer alertThreshold, @CliOption(key={"dispatcher-threads"}, help="The number of dispatcher threads working for this GatewaySender. When dispatcher threads is set to > 1, appropriate order policy is required to be set.") Integer dispatcherThreads, @CliOption(key={"order-policy"}, help="The order policy followed while dispatching the events to remote distributed system. Order policy is set only when dispatcher threads are > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") String orderPolicy, @CliOption(key={"gateway-event-filter"}, help="The list of fully qualified class names of GatewayEventFilters (separated by comma) to be associated with the GatewaySender. This serves as a callback for users to filter out events before dispatching to remote distributed system. e.g gateway-event-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") @CliMetaData(valueSeparator=",") String[] gatewayEventFilters, @CliOption(key={"gateway-transport-filter"}, help="The fully qualified class name of GatewayTransportFilter to be added to the GatewaySender. ") @CliMetaData(valueSeparator=",") String[] gatewayTransportFilter) {
        Result result = null;
        XmlEntity xmlEntity = null;
        try {
            GatewaySenderFunctionArgs gatewaySenderFunctionArgs = new GatewaySenderFunctionArgs(id, remoteDistributedSystemId, parallel, manualStart, socketBufferSize, socketReadTimeout, enableBatchConflation, batchSize, batchTimeInterval, enablePersistence, diskStoreName, diskSynchronous, maxQueueMemory, alertThreshold, dispatcherThreads, orderPolicy, gatewayEventFilters, gatewayTransportFilter);
            Set<DistributedMember> membersToCreateGatewaySenderOn = CliUtil.findAllMatchingMembers(onGroups, onMember == null ? null : onMember.split(","));
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)GatewaySenderCreateFunction.INSTANCE, (Object)gatewaySenderFunctionArgs, membersToCreateGatewaySenderOn);
            List gatewaySenderCreateResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult gatewaySenderCreateResult : gatewaySenderCreateResults) {
                boolean success = gatewaySenderCreateResult.isSuccessful();
                tabularResultData.accumulate("Member", gatewaySenderCreateResult.getMemberIdOrName());
                tabularResultData.accumulate("Status", (success ? "" : "ERROR: ") + gatewaySenderCreateResult.getMessage());
                if (!success || xmlEntity != null) continue;
                xmlEntity = gatewaySenderCreateResult.getXmlEntity();
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        if (xmlEntity != null) {
            result.setCommandPersisted(new SharedConfigurationWriter().addXmlEntity(xmlEntity, onGroups));
        }
        return result;
    }

    @CliCommand(value={"start gateway-sender"}, help="Start the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result startGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to start the Gateway Sender.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to start the Gateway Sender.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        final String id = senderId.trim();
        try {
            final Cache cache = CacheFactory.getAnyInstance();
            final SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){
                AtomicInteger threadNum = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    Thread result = new Thread(r, "Start Sender Command Thread " + this.threadNum.incrementAndGet());
                    result.setDaemon(true);
                    return result;
                }
            });
            ArrayList<2> callables = new ArrayList<2>();
            for (final DistributedMember member : dsMembers) {
                callables.add(new Callable<List>(){

                    @Override
                    public List call() throws Exception {
                        GatewaySenderMXBean bean = null;
                        ArrayList<String> statusList = new ArrayList<String>();
                        if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                            bean = service.getLocalGatewaySenderMXBean(id);
                        } else {
                            ObjectName objectName = service.getGatewaySenderMBeanName(member, id);
                            bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                        }
                        if (bean != null) {
                            if (bean.isRunning()) {
                                statusList.add(member.getId());
                                statusList.add("Error");
                                statusList.add(CliStrings.format("GatewaySender {0} is already started on member {1}", id, member.getId()));
                            } else {
                                bean.start();
                                statusList.add(member.getId());
                                statusList.add("OK");
                                statusList.add(CliStrings.format("GatewaySender {0} is started on member {1}", id, member.getId()));
                            }
                        } else {
                            statusList.add(member.getId());
                            statusList.add("Error");
                            statusList.add(CliStrings.format("GatewaySender {0} is not available on member {1}", id, member.getId()));
                        }
                        return statusList;
                    }
                });
            }
            Iterator<DistributedMember> memberIterator = dsMembers.iterator();
            List futures = null;
            try {
                futures = execService.invokeAll(callables);
            }
            catch (InterruptedException ite) {
                this.accumulateStartResult(resultData, null, "Error", CliStrings.format("Could not invoke start gateway sender {0} operation on members due to {1}", id, ite.getMessage()));
            }
            for (Future future : futures) {
                DistributedMember member = memberIterator.next();
                List memberStatus = null;
                try {
                    memberStatus = (List)future.get();
                    this.accumulateStartResult(resultData, (String)memberStatus.get(0), (String)memberStatus.get(1), (String)memberStatus.get(2));
                }
                catch (InterruptedException ite) {
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("Could not start gateway sender {0} on member due to {1}", id, ite.getMessage()));
                }
                catch (ExecutionException ee) {
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("Could not start gateway sender {0} on member due to {1}", id, ee.getMessage()));
                }
            }
            execService.shutdown();
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"pause gateway-sender"}, help="Pause the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result pauseGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to pause the Gateway Sender.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to pause the Gateway Sender.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewaySenderMXBean bean = null;
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = null;
            dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        if (bean.isPaused()) {
                            this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is already paused on member {1}", senderId, member.getId()));
                            continue;
                        }
                        bean.pause();
                        this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is paused on member {1}", senderId, member.getId()));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not running on member {1}.", senderId, member.getId()));
                    continue;
                }
                this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"resume gateway-sender"}, help="Resume the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result resumeGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to resume the Gateway Sender.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to resume the Gateway Sender.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewaySenderMXBean bean = null;
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = null;
            dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        if (bean.isPaused()) {
                            bean.resume();
                            this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is resumed on member {1}", senderId, member.getId()));
                            continue;
                        }
                        this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not paused on member {1}", senderId, member.getId()));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not running on member {1}.", senderId, member.getId()));
                    continue;
                }
                this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"stop gateway-sender"}, help="Stop the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result stopGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to stop the Gateway Sender.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to stop the Gateway Sender.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewaySenderMXBean bean = null;
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        bean.stop();
                        this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is stopped on member {1}", senderId, member.getId()));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not running on member {1}.", senderId, member.getId()));
                    continue;
                }
                this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"create gateway-receiver"}, help="Create the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createGatewayReceiver(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to create the Gateway Receiver.") @CliMetaData(valueSeparator=",") String[] onGroups, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Name/Id of the member on which to create the Gateway Receiver.") @CliMetaData(valueSeparator=",") String onMember, @CliOption(key={"manual-start"}, help="Whether manual start is to be enabled or the receiver will start automatically after creation.") Boolean manualStart, @CliOption(key={"start-port"}, help="Starting value of the port range from which the GatewayReceiver's port will be chosen.") Integer startPort, @CliOption(key={"end-port"}, help="End value of the port range from which the GatewayReceiver's port will be chosen.") Integer endPort, @CliOption(key={"bind-address"}, help="The IP address or host name that the receiver's socket will listen on for client connections.") String bindAddress, @CliOption(key={"maximum-time-between-pings"}, help="The maximum amount of time between client pings.") Integer maximumTimeBetweenPings, @CliOption(key={"socket-buffer-size"}, help="The buffer size in bytes of the socket connection for this GatewayReceiver.") Integer socketBufferSize, @CliOption(key={"gateway-transport-filter"}, help="The fully qualified class names of GatewayTransportFilters (separated by comma) to be added to the GatewayReceiver. e.g. gateway-transport-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") @CliMetaData(valueSeparator=",") String[] gatewayTransportFilters) {
        Result result = null;
        XmlEntity xmlEntity = null;
        try {
            GatewayReceiverFunctionArgs gatewayReceiverFunctionArgs = new GatewayReceiverFunctionArgs(manualStart, startPort, endPort, bindAddress, socketBufferSize, maximumTimeBetweenPings, gatewayTransportFilters);
            Set<DistributedMember> membersToCreateGatewayReceiverOn = CliUtil.findAllMatchingMembers(onGroups, onMember == null ? null : onMember.split(","));
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)GatewayReceiverCreateFunction.INSTANCE, (Object)gatewayReceiverFunctionArgs, membersToCreateGatewayReceiverOn);
            List gatewayReceiverCreateResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult gatewayReceiverCreateResult : gatewayReceiverCreateResults) {
                boolean success = gatewayReceiverCreateResult.isSuccessful();
                tabularResultData.accumulate("Member", gatewayReceiverCreateResult.getMemberIdOrName());
                tabularResultData.accumulate("Status", (success ? "" : "ERROR: ") + gatewayReceiverCreateResult.getMessage());
                if (!success || xmlEntity != null) continue;
                xmlEntity = gatewayReceiverCreateResult.getXmlEntity();
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        if (xmlEntity != null) {
            result.setCommandPersisted(new SharedConfigurationWriter().addXmlEntity(xmlEntity, onGroups));
        }
        return result;
    }

    @CliCommand(value={"load-balance gateway-sender"}, help="Cause the Gateway Sender to close its current connections so that it reconnects to its remote receivers in a more balanced fashion.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result loadBalanceGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId) {
        Result result = null;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.getAllNormalMembers(cache);
            if (dsMembers.isEmpty()) {
                result = ResultBuilder.createInfoResult("Members not found");
            } else {
                boolean gatewaySenderExists = false;
                for (DistributedMember member : dsMembers) {
                    GatewaySenderMXBean bean = null;
                    if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                        bean = service.getLocalGatewaySenderMXBean(senderId);
                    } else {
                        ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                        bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                    }
                    if (bean != null) {
                        gatewaySenderExists = true;
                        bean.rebalance();
                        this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is rebalanced on member {1}", senderId, member.getId()));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
                }
                result = gatewaySenderExists ? ResultBuilder.buildResult(resultData) : ResultBuilder.createInfoResult(CliStrings.format("GatewaySender {0} is not found on any member", new Object[]{senderId}));
            }
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"start gateway-receiver"}, help="Start the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result startGatewayReceiver(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to start the Gateway Receiver.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to start the Gateway Receiver.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewayReceiverMXBean receieverBean = null;
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
                if (gatewayReceiverObjectName != null) {
                    receieverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                    if (receieverBean != null) {
                        if (receieverBean.isRunning()) {
                            this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is already started on member {0}", new Object[]{member.getId()}));
                            continue;
                        }
                        receieverBean.start();
                        this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewayReceiver is started on member {0}", new Object[]{member.getId()}));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
                    continue;
                }
                this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"stop gateway-receiver"}, help="Stop the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result stopGatewayReceiver(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members on which to stop the Gateway Receiver.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which to stop the Gateway Receiver.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewayReceiverMXBean receieverBean = null;
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
                if (gatewayReceiverObjectName != null) {
                    receieverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                    if (receieverBean != null) {
                        if (receieverBean.isRunning()) {
                            receieverBean.stop();
                            this.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewayReceiver is stopped on member {0}", new Object[]{member.getId()}));
                            continue;
                        }
                        this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not running on member {0}", new Object[]{member.getId()}));
                        continue;
                    }
                    this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
                    continue;
                }
                this.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"list gateways"}, help="Display the Gateway Senders and Receivers for a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listGateway(@CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Member(s) for which Gateway Senders and Receivers will be displayed.") @CliMetaData(valueSeparator=",") String onMember, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members for which Gateway Senders and Receivers will be displayed.") @CliMetaData(valueSeparator=",") String onGroup) {
        Result result = null;
        Cache cache = CacheFactory.getAnyInstance();
        try {
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            Set<DistributedMember> dsMembers = null;
            dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            TreeMap<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans = new TreeMap<String, Map<String, GatewaySenderMXBean>>();
            TreeMap<String, GatewayReceiverMXBean> gatewayReceiverBeans = new TreeMap<String, GatewayReceiverMXBean>();
            DistributedSystemMXBean dsMXBean = service.getDistributedSystemMXBean();
            for (DistributedMember member : dsMembers) {
                ObjectName gatewayReceiverObjectName;
                String memberName = member.getName();
                String memberNameOrId = memberName != null && !memberName.isEmpty() ? memberName : member.getId();
                ObjectName[] gatewaySenderObjectNames = dsMXBean.listGatewaySenderObjectNames(memberNameOrId);
                if (gatewaySenderObjectNames != null) {
                    for (ObjectName name : gatewaySenderObjectNames) {
                        Map<String, GatewaySenderMXBean> memberToBeanMap;
                        GatewaySenderMXBean senderBean = service.getMBeanProxy(name, GatewaySenderMXBean.class);
                        if (senderBean == null) continue;
                        if (gatewaySenderBeans.containsKey(senderBean.getSenderId())) {
                            memberToBeanMap = (Map)gatewaySenderBeans.get(senderBean.getSenderId());
                            memberToBeanMap.put(member.getId(), senderBean);
                            continue;
                        }
                        memberToBeanMap = new TreeMap<String, GatewaySenderMXBean>();
                        memberToBeanMap.put(member.getId(), senderBean);
                        gatewaySenderBeans.put(senderBean.getSenderId(), memberToBeanMap);
                    }
                }
                if ((gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member)) == null) continue;
                GatewayReceiverMXBean receieverBean = null;
                receieverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                if (receieverBean == null) continue;
                gatewayReceiverBeans.put(member.getId(), receieverBean);
            }
            if (gatewaySenderBeans.isEmpty() && gatewayReceiverBeans.isEmpty()) {
                return ResultBuilder.createUserErrorResult("GatewaySenders or GatewayRecievers are not available in cluster");
            }
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            crd.setHeader("Gateways");
            this.accumulateListGatewayResult(crd, gatewaySenderBeans, gatewayReceiverBeans);
            result = ResultBuilder.buildResult(crd);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"status gateway-sender"}, help="Display the status of a Gateway Sender.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result statusGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="converter.hint.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of Gateway Senders for which to display status.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the Gateway Sender for which to display status.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            GatewaySenderMXBean bean = null;
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            TabularResultData availableSenderData = crd.addSection("Available GatewaySender Section").addTable("GatewaySender Table");
            TabularResultData notAvailableSenderData = crd.addSection("Not Available GatewaySender Section").addTable("GatewaySender Table");
            Set<DistributedMember> dsMembers = null;
            dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    this.buildSenderStatus(member.getId(), bean, availableSenderData);
                    continue;
                }
                this.buildSenderStatus(member.getId(), bean, notAvailableSenderData);
            }
            result = ResultBuilder.buildResult(crd);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"status gateway-receiver"}, help="Display the status of a Gateway Receiver.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result statusGatewayReceiver(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of Gateway Receivers for which to display status.") @CliMetaData(valueSeparator=",") String onGroup, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the Gateway Receiver for which to display status.") @CliMetaData(valueSeparator=",") String onMember) {
        Result result = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            TabularResultData availableReceiverData = crd.addSection("Available GatewayReceiver Section").addTable("GatewayReceiver Table");
            TabularResultData notAvailableReceiverData = crd.addSection("Not Available GatewayReceiver Section").addTable("GatewayReceiver Table");
            Set<DistributedMember> dsMembers = CliUtil.findAllMatchingMembers(onGroup, onMember);
            for (DistributedMember member : dsMembers) {
                GatewayReceiverMXBean receieverBean;
                ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
                if (gatewayReceiverObjectName != null && (receieverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) != null) {
                    this.buildReceiverStatus(member.getId(), receieverBean, availableReceiverData);
                    continue;
                }
                this.buildReceiverStatus(member.getId(), null, notAvailableReceiverData);
            }
            result = ResultBuilder.buildResult(crd);
        }
        catch (CommandResultException crex) {
            result = this.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    private TabularResultData buildReceiverStatus(String memberId, GatewayReceiverMXBean bean, TabularResultData resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Port", bean.getPort());
            resultData.accumulate("Status", bean.isRunning() ? "Running" : "Not Running");
        } else {
            resultData.accumulate("Error", "GatewayReceiver is not available or already stopped");
        }
        return resultData;
    }

    private TabularResultData buildSenderStatus(String memberId, GatewaySenderMXBean bean, TabularResultData resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Type", bean.isParallel() ? "Parallel" : "Serial");
            if (!bean.isParallel()) {
                resultData.accumulate("Runtime Policy", bean.isPrimary() ? "Primary" : "Secondary");
            }
            if (bean.isRunning()) {
                if (bean.isPaused()) {
                    resultData.accumulate("Status", "Paused");
                } else {
                    resultData.accumulate("Status", "Running");
                }
            } else {
                resultData.accumulate("Status", "Not Running");
            }
        } else {
            resultData.accumulate("Error", "GatewaySender is not available");
        }
        return resultData;
    }

    private void accumulateListGatewayResult(CompositeResultData crd, Map<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans, Map<String, GatewayReceiverMXBean> gatewayReceiverBeans) {
        if (!gatewaySenderBeans.isEmpty()) {
            TabularResultData gatewaySenderData = crd.addSection("GatewaySender Section").addTable("GatewaySender Table").setHeader("GatewaySender");
            for (Map.Entry<String, Object> entry : gatewaySenderBeans.entrySet()) {
                for (Map.Entry memberToBean : ((Map)entry.getValue()).entrySet()) {
                    gatewaySenderData.accumulate("GatewaySender Id", entry.getKey());
                    gatewaySenderData.accumulate("Member", memberToBean.getKey());
                    gatewaySenderData.accumulate("Remote Cluster Id", ((GatewaySenderMXBean)memberToBean.getValue()).getRemoteDSId());
                    gatewaySenderData.accumulate("Type", ((GatewaySenderMXBean)memberToBean.getValue()).isParallel() ? "Parallel" : "Serial");
                    gatewaySenderData.accumulate("Status", ((GatewaySenderMXBean)memberToBean.getValue()).isRunning() ? "Running" : "Not Running");
                    gatewaySenderData.accumulate("Queued Events", ((GatewaySenderMXBean)memberToBean.getValue()).getEventQueueSize());
                    gatewaySenderData.accumulate("Receiver Location", ((GatewaySenderMXBean)memberToBean.getValue()).getGatewayReceiver());
                }
            }
        }
        if (!gatewayReceiverBeans.isEmpty()) {
            TabularResultData gatewayReceiverData = crd.addSection("GatewayReceiver Section").addTable("GatewayReceiver Table").setHeader("GatewayReceiver");
            for (Map.Entry<String, Object> entry : gatewayReceiverBeans.entrySet()) {
                gatewayReceiverData.accumulate("Member", entry.getKey());
                gatewayReceiverData.accumulate("Port", ((GatewayReceiverMXBean)entry.getValue()).getPort());
                gatewayReceiverData.accumulate("Sender Count", ((GatewayReceiverMXBean)entry.getValue()).getClientConnectionCount());
                gatewayReceiverData.accumulate("Sender's Connected", ((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders());
            }
        }
    }

    private void accumulateStartResult(TabularResultData resultData, String member, String Status2, String message) {
        if (member != null) {
            resultData.accumulate("Member", member);
        }
        resultData.accumulate("Result", Status2);
        resultData.accumulate("Message", message);
    }

    @CliAvailabilityIndicator(value={"create gateway-sender", "start gateway-sender", "pause gateway-sender", "resume gateway-sender", "stop gateway-sender", "create gateway-receiver", "start gateway-receiver", "stop gateway-receiver", "list gateways", "status gateway-sender", "status gateway-receiver", "load-balance gateway-sender"})
    public boolean isWanCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    private Result handleCommandResultException(CommandResultException crex) {
        Result result = null;
        if (crex.getResult() != null) {
            result = crex.getResult();
        } else {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(crex));
            result = ResultBuilder.createGemFireErrorResult("Error" + crex.getMessage());
        }
        return result;
    }
}

