/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.process.signal.SignalEvent;
import org.apache.geode.internal.process.signal.SignalListener;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.internal.util.StopWatch;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.commands.ShellCommands;
import org.apache.geode.management.internal.cli.converters.ConnectionEndpointConverter;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.util.CauseFinder;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.cli.util.JConsoleNotFoundException;
import org.apache.geode.management.internal.cli.util.VisualVmNotFoundException;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusRequest;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LauncherLifecycleCommands
extends AbstractCommandsSupport {
    private static final String LOCATOR_TERM_NAME = "Locator";
    private static final String SERVER_TERM_NAME = "Server";
    private static final long PROCESS_STREAM_READER_JOIN_TIMEOUT_MILLIS = 30000L;
    private static final long PROCESS_STREAM_READER_ASYNC_STOP_TIMEOUT_MILLIS = 5000L;
    private static final long WAITING_FOR_STOP_TO_MAKE_PID_GO_AWAY_TIMEOUT_MILLIS = 30000L;
    private static final long WAITING_FOR_PID_FILE_TO_CONTAIN_PID_TIMEOUT_MILLIS = 2000L;
    protected static final int CMS_INITIAL_OCCUPANCY_FRACTION = 60;
    protected static final int DEFAULT_PROCESS_OUTPUT_WAIT_TIME_MILLISECONDS = 5000;
    protected static final int INVALID_PID = -1;
    protected static final int MINIMUM_HEAP_FREE_RATIO = 10;
    protected static final int NUM_ATTEMPTS_FOR_SHARED_CONFIGURATION_STATUS = 3;
    protected static final String GEMFIRE_HOME = System.getenv("GEMFIRE");
    protected static final String JAVA_HOME = System.getProperty("java.home");
    protected static final String LOCALHOST = "localhost";
    protected static final String GEMFIRE_JAR_PATHNAME = IOUtils.appendToPath(GEMFIRE_HOME, "lib", GemFireVersion.getGemFireJarFileName());
    protected static final String CORE_DEPENDENCIES_JAR_PATHNAME = IOUtils.appendToPath(GEMFIRE_HOME, "lib", "geode-dependencies.jar");

    /*
     * Exception decompiling
     */
    @CliCommand(value={"start locator"}, help="Start a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result startLocator(@CliOption(key={"name"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="The member name to give this Locator in the Geode cluster.") String memberName, @CliOption(key={"bind-address"}, unspecifiedDefaultValue="__NULL__", help="IP address on which the Locator will be bound.  By default, the Locator is bound to all local addresses.") String bindAddress, @CliOption(key={"classpath"}, unspecifiedDefaultValue="__NULL__", help="Location of user application classes required by the Locator. The user classpath is prepended to the Locator's classpath.") String classpath, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Locator run to be overwritten.") Boolean force, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", unspecifiedDefaultValue="__NULL__", help="Group(s) the Locator will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, unspecifiedDefaultValue="__NULL__", help="Hostname or IP address that will be sent to clients so they can connect to this Locator. The default is the bind-address of the Locator.") String hostnameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Locator's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"locators"}, optionContext="converter.hint.locators.discovery.config", unspecifiedDefaultValue="__NULL__", help="Sets the list of Locators used by this Locator to join the appropriate Geode cluster.") String locators, @CliOption(key={"log-level"}, optionContext="converter.hint.log.levels", unspecifiedDefaultValue="__NULL__", help="Sets the level of output logged to the Locator log file.  Possible values for log-level include: finest, finer, fine, config, info, warning, severe, none.") String logLevel, @CliOption(key={"mcast-address"}, unspecifiedDefaultValue="__NULL__", help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Locator can communicate with other members in the Geode cluster using a common multicast address and port.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, unspecifiedDefaultValue="__NULL__", help="Sets the port used for multi-cast networking so the Locator can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"port"}, unspecifiedDefaultValue="__NULL__", help="Port the Locator will listen on.") Integer port, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Directory in which the Locator will be started and ran. The default is ./<locator-member-name>") String workingDirectory, @CliOption(key={"properties-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="The gemfire.properties file for configuring the Locator's distributed system. The file's path can be absolute or relative to the gfsh working directory (--dir=).") String gemfirePropertiesPathname, @CliOption(key={"security-properties-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="The gfsecurity.properties file for configuring the Locator's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory (--dir=).") String gemfireSecurityPropertiesPathname, @CliOption(key={"initial-heap"}, unspecifiedDefaultValue="__NULL__", help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"max-heap"}, unspecifiedDefaultValue="__NULL__", help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"J"}, optionContext="converter.hint.list.string", unspecifiedDefaultValue="__NULL__", help="Argument passed to the JVM on which the Locator will run. For example, --J=-Dfoo.bar=true will set the property \"foo.bar\" to \"true\".") @CliMetaData(valueSeparator=",") String[] jvmArgsOpts, @CliOption(key={"connect"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When connect is set to false , Gfsh does not automatically connect to the locator which is started using this command.") boolean connect, @CliOption(key={"enable-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When enable-cluster-configuration is set to true, locator hosts and serves cluster configuration.") boolean enableSharedConfiguration, @CliOption(key={"load-cluster-configuration-from-dir"}, unspecifiedDefaultValue="false", help="When \" load-cluster-configuration-from-dir \" is set to true, the locator loads the cluster configuration from the \"cluster_config\" directory.") boolean loadSharedConfigurationFromDirectory, @CliOption(key={"cluster-config-dir"}, unspecifiedDefaultValue="", help="Directory used by the cluster configuration service to store the cluster configuration on the filesystem") String clusterConfigDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] createStartLocatorCommandLine(LocatorLauncher launcher, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getLocatorClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        this.addCurrentLocators(commandLine, gemfireProperties);
        this.addGemFirePropertyFile(commandLine, gemfirePropertiesPathname);
        this.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesPathname);
        this.addGemFireSystemProperties(commandLine, gemfireProperties);
        this.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        this.addInitialHeap(commandLine, initialHeap);
        this.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(LocatorLauncher.class.getName());
        commandLine.add(LocatorLauncher.Command.START.getName());
        if (!StringUtils.isBlank(launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.getBindAddress() != null) {
            commandLine.add("--bind-address=" + launcher.getBindAddress().getCanonicalHostName());
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (!StringUtils.isBlank(launcher.getHostnameForClients())) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostnameForClients());
        }
        if (launcher.getPort() != null) {
            commandLine.add("--port=" + launcher.getPort());
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private boolean shouldAutoConnect(boolean connect) {
        return connect && this.getGfsh() != null && !this.isConnectedAndReady();
    }

    private boolean doAutoConnect(String locatorHostname, int locatorPort, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, InfoResultData infoResultData) {
        boolean connectSuccess = false;
        boolean jmxManagerAuthEnabled = false;
        boolean jmxManagerSslEnabled = false;
        Map<String, String> configurationProperties = this.loadConfigurationProperties(gemfireSecurityPropertiesPathname, this.loadConfigurationProperties(gemfirePropertiesPathname));
        HashMap<String, String> locatorConfigurationProperties = new HashMap<String, String>(configurationProperties);
        String responseFailureMessage = null;
        for (int attempts = 0; attempts < 10 && !connectSuccess; ++attempts) {
            try {
                ConnectToLocatorResult connectToLocatorResult = ShellCommands.connectToLocator(locatorHostname, locatorPort, ShellCommands.getConnectLocatorTimeoutInMS() / 4, locatorConfigurationProperties);
                ConnectionEndpoint memberEndpoint = connectToLocatorResult.getMemberEndpoint();
                jmxManagerSslEnabled = connectToLocatorResult.isJmxManagerSslEnabled();
                if (!jmxManagerSslEnabled) {
                    configurationProperties.clear();
                }
                this.getGfsh().setOperationInvoker(new JmxOperationInvoker(memberEndpoint.getHost(), memberEndpoint.getPort(), null, null, configurationProperties, null));
                String shellAndLogMessage = CliStrings.format("Successfully connected to: {0}", (Object)("JMX Manager " + memberEndpoint.toString(false)));
                infoResultData.addLine("\n");
                infoResultData.addLine(shellAndLogMessage);
                this.getGfsh().logToFile(shellAndLogMessage, null);
                connectSuccess = true;
                responseFailureMessage = null;
                continue;
            }
            catch (IllegalStateException unexpected) {
                if (CauseFinder.indexOfCause(unexpected, ClassCastException.class, false) == -1) continue;
                responseFailureMessage = "The Locator might require SSL Configuration.";
                continue;
            }
            catch (SecurityException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (AuthenticationFailedException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (SSLException ignore) {
                if (ignore instanceof SSLHandshakeException) {
                    locatorConfigurationProperties.clear();
                    continue;
                }
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Check your SSL configuration and try again.";
                break;
            }
            catch (Exception ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Failed to connect; unknown cause: " + ignore.getMessage();
            }
        }
        if (!connectSuccess) {
            this.doOnConnectionFailure(locatorHostname, locatorPort, jmxManagerAuthEnabled, jmxManagerSslEnabled, infoResultData);
        }
        if (!StringUtils.isBlank(responseFailureMessage)) {
            infoResultData.addLine("\n");
            infoResultData.addLine(responseFailureMessage);
        }
        return connectSuccess;
    }

    private void doOnConnectionFailure(String locatorHostName, int locatorPort, boolean jmxManagerAuthEnabled, boolean jmxManagerSslEnabled, InfoResultData infoResultData) {
        infoResultData.addLine("\n");
        infoResultData.addLine(CliStrings.format("Please use \"{0}\" to connect Gfsh to the locator.", (Object)new CommandStringBuilder("connect").addOption("locator", locatorHostName + "[" + locatorPort + "]").toString()));
        StringBuilder message = new StringBuilder();
        if (jmxManagerAuthEnabled) {
            message.append("Authentication");
        }
        if (jmxManagerSslEnabled) {
            message.append(jmxManagerAuthEnabled ? " and " : "").append("SSL configuration");
        }
        if (jmxManagerAuthEnabled || jmxManagerSslEnabled) {
            message.append(" required to connect to the Manager.");
            infoResultData.addLine("\n");
            infoResultData.addLine(message.toString());
        }
    }

    private Map<String, String> loadConfigurationProperties(String configurationPropertiesPathname) {
        return this.loadConfigurationProperties(configurationPropertiesPathname, null);
    }

    private Map<String, String> loadConfigurationProperties(String configurationPropertiesPathname, Map<String, String> configurationProperties) {
        HashMap<String, String> hashMap = configurationProperties = configurationProperties != null ? configurationProperties : new HashMap<String, String>();
        if (IOUtils.isExistingPathname(configurationPropertiesPathname)) {
            try {
                configurationProperties.putAll(ShellCommands.loadPropertiesFromURL(new File(configurationPropertiesPathname).toURI().toURL()));
            }
            catch (MalformedURLException ignore) {
                LogWrapper.getInstance().warning(String.format("Failed to load GemFire configuration properties from pathname (%1$s)!", configurationPropertiesPathname), ignore);
            }
        }
        return configurationProperties;
    }

    private String getSharedConfigurationStatusFromLocatorState(LocatorLauncher.LocatorState locatorState) throws ClassNotFoundException, IOException {
        return this.getSharedConfigurationStatusFromLocator(locatorState.getHost(), Integer.parseInt(locatorState.getPort()));
    }

    private String getSharedConfigurationStatusFromLocator(String locatorHostName, int locatorPort) throws ClassNotFoundException, IOException {
        StringBuilder buffer = new StringBuilder();
        try {
            InetAddress networkAddress = InetAddress.getByName(locatorHostName);
            TcpClient client = new TcpClient();
            SharedConfigurationStatusResponse statusResponse = (SharedConfigurationStatusResponse)client.requestToServer(networkAddress, locatorPort, new SharedConfigurationStatusRequest(), 10000, true);
            for (int i = 0; i < 3 && (statusResponse.getStatus().equals((Object)SharedConfigurationStatus.STARTED) || statusResponse.getStatus().equals((Object)SharedConfigurationStatus.NOT_STARTED)); ++i) {
                statusResponse = (SharedConfigurationStatusResponse)client.requestToServer(networkAddress, locatorPort, new SharedConfigurationStatusRequest(), 10000, true);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            switch (statusResponse.getStatus()) {
                case RUNNING: {
                    buffer.append("\nCluster configuration service is up and running.");
                    break;
                }
                case STOPPED: {
                    buffer.append("\nCluster configuration service failed to start , please check the log file for errors.");
                    break;
                }
                case WAITING: {
                    buffer.append("\nCluster configuration service is waiting for other locators with newer shared configuration data.");
                    Set<PersistentMemberPattern> pmpSet = statusResponse.getOtherLocatorInformation();
                    if (!pmpSet.isEmpty()) {
                        buffer.append("\nThis locator might have stale cluster configuration data.");
                        buffer.append("\nFollowing locators contain potentially newer cluster configuration data");
                        for (PersistentMemberPattern pmp : pmpSet) {
                            buffer.append("\nHost : ").append(pmp.getHost());
                            buffer.append("\nDirectory : ").append(pmp.getDirectory());
                        }
                        break;
                    }
                    buffer.append("\nPlease check the log file for errors");
                    break;
                }
                case UNDETERMINED: {
                    buffer.append("\nUnable to determine the status of shared configuration service, please check the log file");
                    break;
                }
                case NOT_STARTED: {
                    buffer.append("\nCluster configuration service has not been started yet");
                    break;
                }
                case STARTED: {
                    buffer.append("\nCluster configuration service has been started, but its not running yet");
                }
            }
        }
        catch (Exception e) {
            this.getGfsh().logToFile(String.format("Failed to get the status of the Shared Configuration Service running on Locator (%1$s[%2$d])!", locatorHostName, locatorPort), e);
        }
        return buffer.toString();
    }

    @CliCommand(value={"status locator"}, help="Display the status of a Locator. Possible statuses are: started, online, offline or not responding.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result statusLocator(@CliOption(key={"name"}, optionContext="converter.hint.locatormember.idOrName", unspecifiedDefaultValue="__NULL__", help="Member name or ID of the Locator in the Geode cluster.") String member, @CliOption(key={"host"}, unspecifiedDefaultValue="__NULL__", help="Hostname or IP address on which the Locator is running.") String locatorHost, @CliOption(key={"port"}, unspecifiedDefaultValue="__NULL__", help="Port on which the Locator is listening. The default is 10334.") Integer locatorPort, @CliOption(key={"pid"}, unspecifiedDefaultValue="__NULL__", help="Process ID (PID) of the running Locator. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Working directory in which the Locator is running. The default is the current directory.") String workingDirectory) {
        try {
            if (!StringUtils.isBlank(member)) {
                if (this.isConnectedAndReady()) {
                    MemberMXBean locatorProxy = this.getMemberMXBean(member);
                    if (locatorProxy != null) {
                        LocatorLauncher.LocatorState state = LocatorLauncher.LocatorState.fromJson(locatorProxy.status());
                        return this.createStatusLocatorResult(state);
                    }
                    return ResultBuilder.createUserErrorResult(CliStrings.format("No Locator with member name or ID {0} could be found.", (Object)member));
                }
                return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)LOCATOR_TERM_NAME));
            }
            LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STATUS).setBindAddress(locatorHost).setDebug(this.isDebugging()).setPid(pid).setPort(locatorPort).setWorkingDirectory(workingDirectory).build();
            LocatorLauncher.LocatorState state = locatorLauncher.status();
            return this.createStatusLocatorResult(state);
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to determine the state of Locator on %1$s running in %2$s: %3$s", this.getLocatorId(locatorHost, locatorPort), StringUtils.defaultIfBlank(workingDirectory, SystemUtils.CURRENT_DIRECTORY), LauncherLifecycleCommands.toString(t, this.getGfsh().getDebug())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CliCommand(value={"stop locator"}, help="Stop a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result stopLocator(@CliOption(key={"name"}, optionContext="converter.hint.locatormember.idOrName", unspecifiedDefaultValue="__NULL__", help="Member name or ID of the Locator in the Geode cluster.") String member, @CliOption(key={"pid"}, unspecifiedDefaultValue="__NULL__", help="The process id (PID) of the running Locator. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Working directory in which the Locator is running. The default is the current directory.") String workingDirectory) {
        Object stopWatch;
        LocatorLauncher.LocatorState locatorState;
        try {
            if (!StringUtils.isBlank(member)) {
                if (!this.isConnectedAndReady()) {
                    Result locatorProxy = ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to stop a {0} by member name or ID.", (Object)LOCATOR_TERM_NAME));
                    return locatorProxy;
                }
                MemberMXBean locatorProxy = this.getMemberMXBean(member);
                if (locatorProxy == null) {
                    Result result = ResultBuilder.createUserErrorResult(CliStrings.format("No Locator with member name or ID {0} could be found.", (Object)member));
                    return result;
                }
                if (!locatorProxy.isLocator()) {
                    throw new IllegalStateException(CliStrings.format("The Geode member identified by {0} is not a Locator and cannot be shutdown using 'stop locator'.", (Object)member));
                }
                if (locatorProxy.isServer()) {
                    throw new IllegalStateException(CliStrings.format("The Locator identified by {0} is also a cache server and cannot be shutdown using 'stop locator'.  Please use 'stop server' instead.", (Object)member));
                }
                locatorState = LocatorLauncher.LocatorState.fromJson(locatorProxy.status());
                locatorProxy.shutDownMember();
            } else {
                LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STOP).setDebug(this.isDebugging()).setPid(pid).setWorkingDirectory(workingDirectory).build();
                locatorState = locatorLauncher.status();
                locatorLauncher.stop();
            }
            if (!AbstractLauncher.Status.ONLINE.equals((Object)locatorState.getStatus())) {
                stopWatch = ResultBuilder.createUserErrorResult(locatorState.toString());
                return stopWatch;
            }
            this.getGfsh().logInfo(String.format("Stopping Locator running in %1$s on %2$s as %3$s...%nProcess ID: %4$d%nLog File: %5$s", locatorState.getWorkingDirectory(), locatorState.getServiceLocation(), locatorState.getMemberName(), locatorState.getPid(), locatorState.getLogFile()), null);
            stopWatch = new StopWatch(true);
        }
        catch (IllegalArgumentException e) {
            Result result = ResultBuilder.createUserErrorResult(e.getMessage());
            return result;
        }
        catch (IllegalStateException e) {
            Result result = ResultBuilder.createUserErrorResult(e.getMessage());
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            Result result = ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to stop a Locator: %1$s", LauncherLifecycleCommands.toString(t, this.getGfsh().getDebug())));
            return result;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
        while (this.isVmWithProcessIdRunning(locatorState.getPid())) {
            Gfsh.print(".");
            if (((StopWatch)stopWatch).elapsedTimeMillis() > 30000L) break;
            LauncherLifecycleCommands launcherLifecycleCommands = this;
            synchronized (launcherLifecycleCommands) {
                TimeUnit.MILLISECONDS.timedWait(this, 500L);
            }
        }
        return ResultBuilder.createInfoResult("");
    }

    protected void addCurrentLocators(List<String> commandLine, Properties gemfireProperties) throws MalformedObjectNameException {
        String currentLocators;
        if (StringUtils.isBlank(gemfireProperties.getProperty("locators")) && !StringUtils.isBlank(currentLocators = this.getCurrentLocators())) {
            commandLine.add("-D".concat("gemfire.default.").concat("locators").concat("=").concat(currentLocators));
        }
    }

    protected Result createStatusLocatorResult(LocatorLauncher.LocatorState state) throws NumberFormatException, IOException, ClassNotFoundException {
        InfoResultData infoResultData = ResultBuilder.createInfoResultData();
        infoResultData.addLine(state.toString());
        infoResultData.addLine(this.getSharedConfigurationStatusFromLocatorState(state));
        return ResultBuilder.buildResult(infoResultData);
    }

    protected void addGemFirePropertyFile(List<String> commandLine, String gemfirePropertiesPathname) {
        if (!StringUtils.isBlank(gemfirePropertiesPathname)) {
            commandLine.add("-DgemfirePropertyFile=" + gemfirePropertiesPathname);
        }
    }

    protected void addGemFireSecurityPropertyFile(List<String> commandLine, String gemfireSecurityPropertiesPathname) {
        if (!StringUtils.isBlank(gemfireSecurityPropertiesPathname)) {
            commandLine.add("-DgemfireSecurityPropertyFile=" + gemfireSecurityPropertiesPathname);
        }
    }

    protected void addGemFireSystemProperties(List<String> commandLine, Properties gemfireProperties) {
        for (Object property : gemfireProperties.keySet()) {
            String propertyName = property.toString();
            String propertyValue = gemfireProperties.getProperty(propertyName);
            if (StringUtils.isBlank(propertyValue)) continue;
            commandLine.add("-Dgemfire." + propertyName + "=" + propertyValue);
        }
    }

    protected void addInitialHeap(List<String> commandLine, String initialHeap) {
        if (!StringUtils.isBlank(initialHeap)) {
            commandLine.add("-Xms" + initialHeap);
        }
    }

    protected void addJvmArgumentsAndOptions(List<String> commandLine, String[] jvmArgsOpts) {
        if (jvmArgsOpts != null) {
            commandLine.addAll(Arrays.asList(jvmArgsOpts));
        }
    }

    protected void addJvmOptionsForOutOfMemoryErrors(List<String> commandLine) {
        if (SystemUtils.isHotSpotVM()) {
            if (SystemUtils.isWindows()) {
                commandLine.add("-XX:OnOutOfMemoryError=taskkill /F /PID %p");
            } else {
                commandLine.add("-XX:OnOutOfMemoryError=kill -KILL %p");
            }
        } else if (SystemUtils.isJ9VM()) {
            commandLine.add("-Xcheck:memory");
        } else if (SystemUtils.isJRockitVM()) {
            commandLine.add("-XXexitOnOutOfMemory");
        }
    }

    protected void addMaxHeap(List<String> commandLine, String maxHeap) {
        if (!StringUtils.isBlank(maxHeap)) {
            commandLine.add("-Xmx" + maxHeap);
            commandLine.add("-XX:+UseConcMarkSweepGC");
            commandLine.add("-XX:CMSInitiatingOccupancyFraction=60");
        }
    }

    protected LocatorLauncher.LocatorState locatorStatus(File locatorPidFile, int oldPid, String memberName) {
        LocatorLauncher.LocatorState locatorState;
        int newPid = this.readPid(locatorPidFile);
        if (newPid != -1 && newPid != oldPid && ObjectUtils.equals((locatorState = new LocatorLauncher.Builder().setPid(newPid).build().status()).getMemberName(), memberName)) {
            return locatorState;
        }
        return new LocatorLauncher.LocatorState(new LocatorLauncher.Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
    }

    protected LocatorLauncher.LocatorState locatorStatus(String workingDirectory, String memberName) {
        LocatorLauncher.LocatorState locatorState = new LocatorLauncher.Builder().setWorkingDirectory(workingDirectory).build().status();
        if (ObjectUtils.equals(locatorState.getMemberName(), memberName)) {
            return locatorState;
        }
        return new LocatorLauncher.LocatorState(new LocatorLauncher.Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
    }

    protected String readErrorStream(Process process) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder message = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            message.append(line);
            message.append(StringUtils.LINE_SEPARATOR);
            line = reader.readLine();
        }
        IOUtils.close(reader);
        return message.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readPid(File pidFile) {
        assert (pidFile != null) : "The file from which to read the process ID (pid) cannot be null!";
        if (pidFile.isFile()) {
            int n;
            BufferedReader fileReader = null;
            try {
                fileReader = new BufferedReader(new FileReader(pidFile));
                n = Integer.parseInt(fileReader.readLine());
            }
            catch (IOException iOException) {
                IOUtils.close(fileReader);
            }
            catch (NumberFormatException numberFormatException) {
                IOUtils.close(fileReader);
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
            IOUtils.close(fileReader);
            return n;
        }
        return -1;
    }

    protected ServerLauncher.ServerState serverStatus(File serverPidFile, int oldPid, String memberName) {
        ServerLauncher.ServerState serverState;
        int newPid = this.readPid(serverPidFile);
        if (newPid != -1 && newPid != oldPid && ObjectUtils.equals((serverState = new ServerLauncher.Builder().setPid(newPid).setDisableDefaultServer(true).build().status()).getMemberName(), memberName)) {
            return serverState;
        }
        return new ServerLauncher.ServerState(new ServerLauncher.Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
    }

    protected ServerLauncher.ServerState serverStatus(String workingDirectory, String memberName) {
        ServerLauncher.ServerState serverState = new ServerLauncher.Builder().setWorkingDirectory(workingDirectory).setDisableDefaultServer(true).build().status();
        if (ObjectUtils.equals(serverState.getMemberName(), memberName)) {
            return serverState;
        }
        return new ServerLauncher.ServerState(new ServerLauncher.Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
    }

    @Deprecated
    protected String getClasspath(String userClasspath) {
        String classpath = this.getSystemClasspath();
        if (!StringUtils.isBlank(userClasspath)) {
            classpath = classpath + File.pathSeparator + userClasspath;
        }
        return classpath;
    }

    protected String getLocatorClasspath(boolean includeSystemClasspath, String userClasspath) {
        return this.toClasspath(includeSystemClasspath, new String[]{CORE_DEPENDENCIES_JAR_PATHNAME}, userClasspath);
    }

    protected String getServerClasspath(boolean includeSystemClasspath, String userClasspath) {
        ArrayList<String> jarFilePathnames = new ArrayList<String>();
        jarFilePathnames.add(CORE_DEPENDENCIES_JAR_PATHNAME);
        return this.toClasspath(includeSystemClasspath, jarFilePathnames.toArray(new String[jarFilePathnames.size()]), userClasspath);
    }

    protected String getSystemClasspath() {
        return System.getProperty("java.class.path");
    }

    String toClasspath(boolean includeSystemClasspath, String[] jarFilePathnames, String ... userClasspaths) {
        String classpath = this.getGemFireJarPath();
        for (String userClasspath : userClasspaths = userClasspaths != null ? userClasspaths : StringUtils.EMPTY_STRING_ARRAY) {
            if (StringUtils.isBlank(userClasspath)) continue;
            classpath = classpath + (classpath.isEmpty() ? "" : File.pathSeparator);
            classpath = classpath + userClasspath;
        }
        if (includeSystemClasspath) {
            classpath = classpath + File.pathSeparator;
            classpath = classpath + this.getSystemClasspath();
        }
        jarFilePathnames = jarFilePathnames != null ? jarFilePathnames : StringUtils.EMPTY_STRING_ARRAY;
        for (String jarFilePathname : jarFilePathnames) {
            if (StringUtils.isBlank(jarFilePathname)) continue;
            classpath = classpath + (classpath.isEmpty() ? "" : File.pathSeparator);
            classpath = classpath + jarFilePathname;
        }
        return classpath;
    }

    protected String getGemFireJarPath() {
        String classpath = this.getSystemClasspath();
        String gemfireJarPath = GEMFIRE_JAR_PATHNAME;
        for (String classpathElement : classpath.split(File.pathSeparator)) {
            if (!classpathElement.endsWith("gemfire-core-8.2.0.0-SNAPSHOT.jar")) continue;
            gemfireJarPath = classpathElement;
            break;
        }
        return gemfireJarPath;
    }

    protected String getJavaPath() {
        return new File(new File(JAVA_HOME, "bin"), "java").getPath();
    }

    protected String getLocalHost() {
        try {
            return SocketCreator.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            return LOCALHOST;
        }
    }

    protected String getLocatorId(String host, Integer port) {
        String locatorHost = host != null ? host : this.getLocalHost();
        String locatorPort = StringUtils.valueOf(port, String.valueOf(10334));
        return locatorHost.concat("[").concat(locatorPort).concat("]");
    }

    protected DistributedSystemMXBean getDistributedSystemMXBean() throws IOException, MalformedObjectNameException {
        LauncherLifecycleCommands.assertState(this.isConnectedAndReady(), "Gfsh must be connected in order to get proxy to a GemFire DistributedSystemMXBean.", new Object[0]);
        return this.getGfsh().getOperationInvoker().getDistributedSystemMXBean();
    }

    protected MemberMXBean getMemberMXBean(String member) throws IOException {
        return this.getMemberMXBean(null, member);
    }

    protected MemberMXBean getMemberMXBean(String serviceName, String member) throws IOException {
        LauncherLifecycleCommands.assertState(this.isConnectedAndReady(), "Gfsh must be connected in order to get proxy to a GemFire Member MBean.", new Object[0]);
        MemberMXBean memberBean = null;
        try {
            String objectNamePattern = "GemFire:";
            objectNamePattern = objectNamePattern + (StringUtils.isBlank(serviceName) ? "" : "service=" + serviceName + ",");
            objectNamePattern = objectNamePattern + "type=Member,*";
            ObjectName objectName = ObjectName.getInstance(objectNamePattern);
            QueryExp query = Query.or(Query.eq(Query.attr("Name"), Query.value(member)), Query.eq(Query.attr("Id"), Query.value(member)));
            Set<ObjectName> memberObjectNames = this.getGfsh().getOperationInvoker().queryNames(objectName, query);
            if (!memberObjectNames.isEmpty()) {
                memberBean = this.getGfsh().getOperationInvoker().getMBeanProxy(memberObjectNames.iterator().next(), MemberMXBean.class);
            }
        }
        catch (MalformedObjectNameException e) {
            this.getGfsh().logSevere(e.getMessage(), e);
        }
        return memberBean;
    }

    protected String getServerId(String host, Integer port) {
        String serverHost = host != null ? host : this.getLocalHost();
        String serverPort = StringUtils.valueOf(port, String.valueOf(40404));
        return serverHost.concat("[").concat(serverPort).concat("]");
    }

    protected boolean isStartingNotRespondingOrNull(AbstractLauncher.ServiceState serviceState) {
        return serviceState == null || this.isStartingOrNotResponding(serviceState.getStatus());
    }

    protected boolean isStartingOrNotResponding(AbstractLauncher.Status processStatus) {
        return AbstractLauncher.Status.NOT_RESPONDING.equals((Object)processStatus) || AbstractLauncher.Status.STARTING.equals((Object)processStatus);
    }

    protected boolean isVmWithProcessIdRunning(Integer pid) {
        return ProcessUtils.isProcessAlive(pid);
    }

    /*
     * Exception decompiling
     */
    @CliCommand(value={"start server"}, help="Start a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result startServer(@CliOption(key={"assign-buckets"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to assign buckets to the partitioned regions of the cache on server start.") Boolean assignBuckets, @CliOption(key={"bind-address"}, unspecifiedDefaultValue="__NULL__", help="The IP address on which the Server will be bound.  By default, the Server is bound to all local addresses.") String bindAddress, @CliOption(key={"cache-xml-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="Specifies the name of the XML file or resource to initialize the cache with when it is created.") String cacheXmlPathname, @CliOption(key={"classpath"}, unspecifiedDefaultValue="__NULL__", help="Location of user application classes required by the Server. The user classpath is prepended to the Server's classpath.") String classpath, @CliOption(key={"critical-heap-percentage"}, unspecifiedDefaultValue="__NULL__", help="Set the percentage of heap at or above which the cache is considered in danger of becoming inoperable due to garbage collection pauses or out of memory exceptions") Float criticalHeapPercentage, @CliOption(key={"critical-off-heap-percentage"}, unspecifiedDefaultValue="__NULL__", help="Set the percentage of off-heap memory at or above which the cache is considered in danger of becoming inoperable due to out of memory exceptions") Float criticalOffHeapPercentage, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Directory in which the Cache Server will be started and ran. The default is ./<server-member-name>") String workingDirectory, @CliOption(key={"disable-default-server"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether the Cache Server will be started by default.") Boolean disableDefaultServer, @CliOption(key={"disable-exit-when-out-of-memory"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Prevents the JVM from exiting when an OutOfMemoryError occurs.") Boolean disableExitWhenOutOfMemory, @CliOption(key={"enable-time-statistics"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="true", help="Causes additional time-based statistics to be gathered for Geode operations.") Boolean enableTimeStatistics, @CliOption(key={"eviction-heap-percentage"}, unspecifiedDefaultValue="__NULL__", help="Set the percentage of heap at or above which the eviction should begin on Regions configured for HeapLRU eviction. Changing this value may cause eviction to begin immediately.Only one change to this attribute or critical heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed. This feature requires additional VM flags to perform properly. ") Float evictionHeapPercentage, @CliOption(key={"eviction-off-heap-percentage"}, unspecifiedDefaultValue="__NULL__", help="Set the percentage of off-heap memory at or above which the eviction should begin on Regions configured for off-heap and HeapLRU eviction. Changing this value may cause eviction to begin immediately. Only one change to this attribute or critical off-heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed.") Float evictionOffHeapPercentage, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Cache Server run to be overwritten.") Boolean force, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", unspecifiedDefaultValue="__NULL__", help="Group(s) the Cache Server will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, unspecifiedDefaultValue="__NULL__", help="Sets the ip address or host name that this cache server is to listen on for client connections.Setting a specific hostname-for-clients will cause server locators to use this value when telling clients how to connect to this cache server. This is useful in the case where the cache server may refer to itself with one hostname, but the clients need to use a different hostname to find the cache server.The value \"\" causes the bind-address to be given to clients.A null value will be treated the same as the default \"\".") String hostNameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Server's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"initial-heap"}, unspecifiedDefaultValue="__NULL__", help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"J"}, optionContext="converter.hint.list.string", unspecifiedDefaultValue="__NULL__", help="Argument passed to the JVM on which the server will run. For example, --J=-Dfoo.bar=true will set the system property \"foo.bar\" to \"true\".") @CliMetaData(valueSeparator=",") String[] jvmArgsOpts, @CliOption(key={"locators"}, optionContext="converter.hint.locators.discovery.config", unspecifiedDefaultValue="__NULL__", help="Sets the list of Locators used by the Cache Server to join the appropriate Geode cluster.") String locators, @CliOption(key={"locator-wait-time"}, unspecifiedDefaultValue="__NULL__", help="Sets the number of seconds the server will wait for a locator to become available during startup before giving up.") Integer locatorWaitTime, @CliOption(key={"lock-memory"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="true", help="Causes Geode to lock heap and off-heap memory pages into RAM. This prevents the operating system from swapping the pages out to disk, which can cause severe performance degradation. When you use this option, also configure the operating system limits for locked memory.") Boolean lockMemory, @CliOption(key={"log-level"}, optionContext="converter.hint.log.levels", unspecifiedDefaultValue="__NULL__", help="Sets the level of output logged to the Cache Server log file.  Possible values for log-level include: finest, finer, fine, config, info, warning, severe, none.") String logLevel, @CliOption(key={"max-connections"}, unspecifiedDefaultValue="__NULL__", help="Sets the maxium number of client connections allowed. When the maximum is reached the cache server will stop accepting connections") Integer maxConnections, @CliOption(key={"max-heap"}, unspecifiedDefaultValue="__NULL__", help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"max-message-count"}, unspecifiedDefaultValue="__NULL__", help="Sets maximum number of messages that can be enqueued in a client-queue.") Integer maxMessageCount, @CliOption(key={"max-threads"}, unspecifiedDefaultValue="__NULL__", help="Sets the maxium number of threads allowed in this cache server to service client requests. The default of 0 causes the cache server to dedicate a thread for every client connection") Integer maxThreads, @CliOption(key={"mcast-address"}, unspecifiedDefaultValue="__NULL__", help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Cache Server can communicate with other members in the Geode cluster.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, unspecifiedDefaultValue="__NULL__", help="Sets the port used for multi-cast networking so the Cache Server can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"memcached-port"}, unspecifiedDefaultValue="__NULL__", help="Sets the port that the Geode memcached service listens on for memcached clients.") Integer memcachedPort, @CliOption(key={"memcached-protocol"}, unspecifiedDefaultValue="__NULL__", help="Sets the protocol that the Geode memcached service uses (ASCII or BINARY).") String memcachedProtocol, @CliOption(key={"memcached-bind-address"}, unspecifiedDefaultValue="__NULL__", help="Sets the IP address the Geode memcached service listens on for memcached clients. The default is to bind to the first non-loopback address for this machine.") String memcachedBindAddress, @CliOption(key={"redis-port"}, unspecifiedDefaultValue="__NULL__", help="Sets the port that the Geode Redis service listens on for Redis clients.") Integer redisPort, @CliOption(key={"redis-bind-address"}, unspecifiedDefaultValue="__NULL__", help="Sets the IP address the Geode Redis service listens on for Redis clients. The default is to bind to the first non-loopback address for this machine.") String redisBindAddress, @CliOption(key={"redis-password"}, unspecifiedDefaultValue="__NULL__", help="Sets the authentication password for GeodeRedisServer") String redisPassword, @CliOption(key={"message-time-to-live"}, unspecifiedDefaultValue="__NULL__", help="Sets the time (in seconds ) after which a message in the client queue will expire") Integer messageTimeToLive, @CliOption(key={"name"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="The member name to give this Cache Server in the Geode cluster.") String memberName, @CliOption(key={"off-heap-memory-size"}, unspecifiedDefaultValue="__NULL__", help="The total size of off-heap memory specified as off-heap-memory-size=<n>[g|m]. <n> is the size. [g|m] indicates whether the size should be interpreted as gigabytes or megabytes. A non-zero size causes that much memory to be allocated from the operating system and reserved for off-heap use.") String offHeapMemorySize, @CliOption(key={"properties-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="The gemfire.properties file for configuring the Cache Server's distributed system. The file's path can be absolute or relative to the gfsh working directory.") String gemfirePropertiesPathname, @CliOption(key={"rebalance"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to initiate rebalancing across the Geode cluster.") Boolean rebalance, @CliOption(key={"security-properties-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="The gfsecurity.properties file for configuring the Server's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory.") String gemfireSecurityPropertiesPathname, @CliOption(key={"server-bind-address"}, unspecifiedDefaultValue="", help="The IP address that this distributed system's server sockets in a client-server topology will be bound. If set to an empty string then all of the local machine's addresses will be listened on.") String serverBindAddress, @CliOption(key={"server-port"}, unspecifiedDefaultValue="40404", help="The port that the distributed system's server sockets in a client-server topology will listen on.  The default server-port is 40404.") Integer serverPort, @CliOption(key={"socket-buffer-size"}, unspecifiedDefaultValue="__NULL__", help="Sets the buffer size in bytes of the socket connection for this CacheServer. The default is 32768 bytes.") Integer socketBufferSize, @CliOption(key={"spring-xml-location"}, unspecifiedDefaultValue="__NULL__", help="Specifies the location of a Spring XML configuration file(s) for bootstrapping and configuring a Geode Server.") String springXmlLocation, @CliOption(key={"statistic-archive-file"}, unspecifiedDefaultValue="__NULL__", help="The file that statistic samples are written to.  An empty string (default) disables statistic archival.") String statisticsArchivePathname, @CliOption(key={"use-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When set to true, the server requests the configuration from locator's cluster configuration service.") Boolean requestSharedConfiguration, @CliOption(key={"start-rest-api"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="When set to true, will start the REST API service.") Boolean startRestApi, @CliOption(key={"http-service-port"}, unspecifiedDefaultValue="", help="Port on which HTTP Service will listen on") String httpServicePort, @CliOption(key={"http-service-bind-address"}, unspecifiedDefaultValue="", help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress, @CliOption(key={"user"}, unspecifiedDefaultValue="", help="User name to securely connect to the cluster. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, unspecifiedDefaultValue="", help="Password to securely connect to the cluster.") String passwordToUse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] createStartServerCommandLine(ServerLauncher launcher, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, Boolean disableExitWhenOutOfMemory, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getServerClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        this.addCurrentLocators(commandLine, gemfireProperties);
        this.addGemFirePropertyFile(commandLine, gemfirePropertiesPathname);
        this.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesPathname);
        this.addGemFireSystemProperties(commandLine, gemfireProperties);
        this.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        if (!Boolean.TRUE.equals(disableExitWhenOutOfMemory)) {
            this.addJvmOptionsForOutOfMemoryErrors(commandLine);
        }
        this.addInitialHeap(commandLine, initialHeap);
        this.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(ServerLauncher.class.getName());
        commandLine.add(ServerLauncher.Command.START.getName());
        if (!StringUtils.isBlank(launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.isAssignBuckets()) {
            commandLine.add("--assign-buckets");
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isDisableDefaultServer()) {
            commandLine.add("--disable-default-server");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (launcher.isRebalancing()) {
            commandLine.add("--rebalance");
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        if (launcher.getServerBindAddress() != null) {
            commandLine.add("--server-bind-address=" + launcher.getServerBindAddress().getCanonicalHostName());
        }
        if (launcher.getServerPort() != null) {
            commandLine.add("--server-port=" + launcher.getServerPort());
        }
        if (launcher.isSpringXmlLocationSpecified()) {
            commandLine.add("--spring-xml-location=".concat(launcher.getSpringXmlLocation()));
        }
        if (launcher.getCriticalHeapPercentage() != null) {
            commandLine.add("--critical-heap-percentage=" + launcher.getCriticalHeapPercentage());
        }
        if (launcher.getEvictionHeapPercentage() != null) {
            commandLine.add("--eviction-heap-percentage=" + launcher.getEvictionHeapPercentage());
        }
        if (launcher.getCriticalOffHeapPercentage() != null) {
            commandLine.add("--critical-off-heap-percentage=" + launcher.getCriticalOffHeapPercentage());
        }
        if (launcher.getEvictionOffHeapPercentage() != null) {
            commandLine.add("--eviction-off-heap-percentage=" + launcher.getEvictionOffHeapPercentage());
        }
        if (launcher.getMaxConnections() != null) {
            commandLine.add("--max-connections=" + launcher.getMaxConnections());
        }
        if (launcher.getMaxMessageCount() != null) {
            commandLine.add("--max-message-count=" + launcher.getMaxMessageCount());
        }
        if (launcher.getMaxThreads() != null) {
            commandLine.add("--max-threads=" + launcher.getMaxThreads());
        }
        if (launcher.getMessageTimeToLive() != null) {
            commandLine.add("--message-time-to-live=" + launcher.getMessageTimeToLive());
        }
        if (launcher.getSocketBufferSize() != null) {
            commandLine.add("--socket-buffer-size=" + launcher.getSocketBufferSize());
        }
        if (launcher.getHostNameForClients() != null) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostNameForClients());
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private String getCurrentLocators() throws MalformedObjectNameException {
        String delimitedLocators = "";
        try {
            String[] locators;
            DistributedSystemMXBean dsMBeanProxy;
            if (this.isConnectedAndReady() && (dsMBeanProxy = this.getDistributedSystemMXBean()) != null && (locators = dsMBeanProxy.listLocators()) != null && locators.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < locators.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(locators[i]);
                }
                delimitedLocators = sb.toString();
            }
        }
        catch (IOException e) {
            this.getGfsh().logWarning("DistributedSystemMXBean is unavailable\n", e);
        }
        return delimitedLocators;
    }

    @CliCommand(value={"status server"}, help="Display the status of a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result statusServer(@CliOption(key={"name"}, optionContext="converter.hint.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Member name or ID of the Cache Server in the Geode cluster.") String member, @CliOption(key={"pid"}, unspecifiedDefaultValue="__NULL__", help="Process ID (PID) of the running Geode Cache Server. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Working directory in which the Cache Server is running. The default is the current directory.") String workingDirectory) {
        try {
            if (!StringUtils.isBlank(member)) {
                if (this.isConnectedAndReady()) {
                    MemberMXBean serverProxy = this.getMemberMXBean(member);
                    if (serverProxy != null) {
                        return ResultBuilder.createInfoResult(ServerLauncher.ServerState.fromJson(serverProxy.status()).toString());
                    }
                    return ResultBuilder.createUserErrorResult(CliStrings.format("No Geode Cache Server with member name or ID {0} could be found.", (Object)member));
                }
                return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Cache Server"));
            }
            ServerLauncher serverLauncher = new ServerLauncher.Builder().setCommand(ServerLauncher.Command.STATUS).setDebug(this.isDebugging()).setDisableDefaultServer(true).setMemberName(member).setPid(pid).setWorkingDirectory(workingDirectory).build();
            ServerLauncher.ServerState status = serverLauncher.status();
            return ResultBuilder.createInfoResult(status.toString());
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to determine the status of Geode Cache server: %1$s", LauncherLifecycleCommands.toString(t, this.getGfsh().getDebug())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CliCommand(value={"stop server"}, help="Stop a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result stopServer(@CliOption(key={"name"}, optionContext="converter.hint.member.idOrName", unspecifiedDefaultValue="__NULL__", help="Member name or ID of the Cache Server in the Geode cluster.") String member, @CliOption(key={"pid"}, unspecifiedDefaultValue="__NULL__", help="Process ID (PID) of the running Geode Cache Server. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, optionContext="converter.hint.dir.path.string", unspecifiedDefaultValue="__NULL__", help="Working directory in which the Cache Server is running. The default is the current directory.") String workingDirectory) {
        Object stopWatch;
        ServerLauncher.ServerState serverState;
        try {
            if (!StringUtils.isBlank(member)) {
                if (!this.isConnectedAndReady()) {
                    Result serverProxy = ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to stop a {0} by member name or ID.", (Object)"Cache Server"));
                    return serverProxy;
                }
                MemberMXBean serverProxy = this.getMemberMXBean(member);
                if (serverProxy == null) {
                    Result result = ResultBuilder.createUserErrorResult(CliStrings.format("No Cache Server with member name or ID {0} could be found.", (Object)member));
                    return result;
                }
                if (!serverProxy.isServer()) {
                    throw new IllegalStateException(CliStrings.format("Attempting to stop a Geode member that is not a Cache Server using 'stop server'; the operation is not permitted.", (Object)member));
                }
                serverState = ServerLauncher.ServerState.fromJson(serverProxy.status());
                serverProxy.shutDownMember();
            } else {
                ServerLauncher serverLauncher = new ServerLauncher.Builder().setCommand(ServerLauncher.Command.STOP).setDebug(this.isDebugging()).setMemberName(member).setPid(pid).setWorkingDirectory(workingDirectory).build();
                serverState = serverLauncher.status();
                serverLauncher.stop();
            }
            if (!AbstractLauncher.Status.ONLINE.equals((Object)serverState.getStatus())) {
                stopWatch = ResultBuilder.createUserErrorResult(serverState.toString());
                return stopWatch;
            }
            this.getGfsh().logInfo(String.format("Stopping Cache Server running in %1$s on %2$s as %3$s...%nProcess ID: %4$d%nLog File: %5$s", serverState.getWorkingDirectory(), serverState.getServiceLocation(), serverState.getMemberName(), serverState.getPid(), serverState.getLogFile()), null);
            stopWatch = new StopWatch(true);
        }
        catch (IllegalArgumentException e) {
            Result result = ResultBuilder.createUserErrorResult(e.getMessage());
            return result;
        }
        catch (IllegalStateException e) {
            Result result = ResultBuilder.createUserErrorResult(e.getMessage());
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            Result result = ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to stop a Cache Server: %1$s", LauncherLifecycleCommands.toString(t, this.getGfsh().getDebug())));
            return result;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
        while (this.isVmWithProcessIdRunning(serverState.getPid())) {
            Gfsh.print(".");
            if (((StopWatch)stopWatch).elapsedTimeMillis() > 30000L) break;
            LauncherLifecycleCommands launcherLifecycleCommands = this;
            synchronized (launcherLifecycleCommands) {
                TimeUnit.MILLISECONDS.timedWait(this, 500L);
            }
        }
        return ResultBuilder.createInfoResult("");
    }

    public Result startManager(@CliOption(key={"name"}, unspecifiedDefaultValue="__NULL__", help="Member name for this Manager service.") String memberName, @CliOption(key={"dir"}, unspecifiedDefaultValue="__NULL__", help="Directory in which the Manager will be run. The default is the current directory.") String dir, @CliOption(key={"port"}, unspecifiedDefaultValue="1099", help="Port the Manager will listen on for JMX-RMI client connections.") int cacheServerPort, @CliOption(key={"bind-address"}, unspecifiedDefaultValue="localhost", help="IP address the Manager listen on for JMX-RMI client connections. The default is to bind to all local addresses.") String cacheServerHost, @CliOption(key={"classpath"}, unspecifiedDefaultValue="__NULL__", help="Location of user classes required by the Manager. This path is appended to the current classpath.") String classpath, @CliOption(key={"max-heap"}, unspecifiedDefaultValue="__NULL__", help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"initial-heap"}, unspecifiedDefaultValue="__NULL__", help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"J"}, unspecifiedDefaultValue="__NULL__", help="Argument passed to the JVM on which the Locator will run. For example, --J=-Dfoo.bar=true will set the property \"foo.bar\" to \"true\".") Map<String, String> systepProps, @CliOption(key={"G"}, unspecifiedDefaultValue="__NULL__", help="Geode property passed as a <name>=<value> pair.") Map<String, String> gemfireProps) {
        return ResultBuilder.createInfoResult("Not-implemented");
    }

    @CliCommand(value={"start jconsole"}, help="Start the JDK's JConsole tool in a separate process. JConsole will be launched, but connecting to Geode must be done manually.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startJConsole(@CliOption(key={"interval"}, unspecifiedDefaultValue="4", help="Update internal (in seconds). This parameter is passed as -interval to JConsole.") int interval, @CliOption(key={"notile"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to initially tile windows for two or more connections. This parameter is passed as -notile to JConsole.") boolean notile, @CliOption(key={"pluginpath"}, unspecifiedDefaultValue="__NULL__", help="Directories or JAR files which are searched for JConsole plugins. The path should contain a provider-configuration file named:\n    META-INF/services/com.sun.tools.jconsole.JConsolePlugin\ncontaining one line for each plugin specifying the fully qualified class name of the class implementing the com.sun.tools.jconsole.JConsolePlugin class.") String pluginpath, @CliOption(key={"version"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display the JConsole version information. This parameter is passed as -version to JConsole.") boolean version, @CliOption(key={"J"}, optionContext="converter.hint.list.string", unspecifiedDefaultValue="__NULL__", help="Arguments passed to the JVM on which JConsole will run.") @CliMetaData(valueSeparator=",") List<String> jvmArgs) {
        try {
            Object[] jconsoleCommandLine = this.createJConsoleCommandLine(null, interval, notile, pluginpath, version, jvmArgs);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("JConsole command-line ($1%s)", Arrays.toString(jconsoleCommandLine)));
            }
            Process jconsoleProcess = Runtime.getRuntime().exec((String[])jconsoleCommandLine);
            StringBuilder message = new StringBuilder();
            if (version) {
                jconsoleProcess.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(jconsoleProcess.getErrorStream()));
                String line = reader.readLine();
                while (line != null) {
                    message.append(line);
                    message.append(StringUtils.LINE_SEPARATOR);
                    line = reader.readLine();
                }
                IOUtils.close(reader);
            } else {
                this.getGfsh().printAsInfo("Launched JConsole");
                String jconsoleProcessOutput = this.waitAndCaptureProcessStandardErrorStream(jconsoleProcess);
                if (!StringUtils.isBlank(jconsoleProcessOutput)) {
                    message.append(StringUtils.LINE_SEPARATOR);
                    message.append(jconsoleProcessOutput);
                }
            }
            return ResultBuilder.createInfoResult(message.toString());
        }
        catch (GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IOException e) {
            return ResultBuilder.createShellClientErrorResult("An IO error occurred while launching JConsole.\nPlease ensure that JAVA_HOME is set to the JDK installation or the JDK bin directory is in the system PATH.");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching JConsole = %1$s", LauncherLifecycleCommands.toString(t, false)));
        }
    }

    protected String[] createJConsoleCommandLine(String member, int interval, boolean notile, String pluginpath, boolean version, List<String> jvmArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJConsolePathname());
        if (version) {
            commandLine.add("-version");
        } else {
            String jmxServiceUrl;
            commandLine.add("-interval=" + interval);
            if (notile) {
                commandLine.add("-notile");
            }
            if (!StringUtils.isBlank(pluginpath)) {
                commandLine.add("-pluginpath " + pluginpath);
            }
            if (jvmArgs != null) {
                for (String arg : jvmArgs) {
                    commandLine.add("-J" + arg);
                }
            }
            if (!StringUtils.isBlank(jmxServiceUrl = this.getJmxServiceUrlAsString(member))) {
                commandLine.add(jmxServiceUrl);
            }
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    protected String getJConsolePathname() {
        return this.getJdkToolPathname("jconsole" + LauncherLifecycleCommands.getExecutableSuffix(), (GemFireException)new JConsoleNotFoundException("JConsole could not be found.\nPlease ensure that JAVA_HOME is set to the JDK installation or the JDK bin directory is in the system PATH."));
    }

    protected String getJdkToolPathname(String jdkToolExecutableName, GemFireException throwable) {
        LauncherLifecycleCommands.assertNotNull(jdkToolExecutableName, "The JDK tool executable name cannot be null!", new Object[0]);
        LauncherLifecycleCommands.assertNotNull(throwable, "The GemFireException cannot be null!", new Object[0]);
        Stack<String> pathnames = new Stack<String>();
        pathnames.push(jdkToolExecutableName);
        pathnames.push(IOUtils.appendToPath(System.getenv("JAVA_HOME"), "..", "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(System.getenv("JAVA_HOME"), "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(JAVA_HOME, "..", "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(JAVA_HOME, "bin", jdkToolExecutableName));
        return this.getJdkToolPathname(pathnames, throwable);
    }

    protected String getJdkToolPathname(Stack<String> pathnames, GemFireException throwable) {
        LauncherLifecycleCommands.assertNotNull(pathnames, "The JDK tool executable pathnames cannot be null!", new Object[0]);
        LauncherLifecycleCommands.assertNotNull(throwable, "The GemFireException cannot be null!", new Object[0]);
        try {
            return IOUtils.verifyPathnameExists(pathnames.pop());
        }
        catch (EmptyStackException ignore) {
            throw throwable;
        }
        catch (FileNotFoundException ignore) {
            return this.getJdkToolPathname(pathnames, throwable);
        }
    }

    protected static String getExecutableSuffix() {
        return SystemUtils.isWindows() ? ".exe" : "";
    }

    protected String getJmxServiceUrlAsString(String member) {
        if (!StringUtils.isBlank(member)) {
            ConnectionEndpointConverter converter = new ConnectionEndpointConverter();
            try {
                Object connectionEndpoint = converter.convertFromText(member, (Class)ConnectionEndpoint.class, (String)null);
                return StringUtils.concat("service:jmx:rmi://", ((ConnectionEndpoint)connectionEndpoint).getHost(), ":", ((ConnectionEndpoint)connectionEndpoint).getPort(), "/jndi/rmi://", ((ConnectionEndpoint)connectionEndpoint).getHost(), ":", ((ConnectionEndpoint)connectionEndpoint).getPort(), "/jmxrmi");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Connecting by the Geode member's name or ID is not currently supported.\nPlease specify the member as '<hostname|IP>[PORT].");
            }
        }
        if (this.isConnectedAndReady() && this.getGfsh().getOperationInvoker() instanceof JmxOperationInvoker) {
            JmxOperationInvoker jmxOperationInvoker = (JmxOperationInvoker)this.getGfsh().getOperationInvoker();
            return ObjectUtils.toString(jmxOperationInvoker.getJmxServiceUrl());
        }
        return null;
    }

    @CliCommand(value={"start jvisualvm"}, help="Start the JDK's Java VisualVM (jvisualvm) tool in a separate process. Java VisualVM will be launched, but connecting to Geode must be done manually.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startJVisualVM(@CliOption(key={"J"}, optionContext="converter.hint.list.string", unspecifiedDefaultValue="__NULL__", help="Arguments passed to the JVM on which JConsole will run.") @CliMetaData(valueSeparator=",") List<String> jvmArgs) {
        try {
            Object[] jvisualvmCommandLine = this.createJVisualVMCommandLine(jvmArgs);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("JVisualVM command-line (%1$s)", Arrays.toString(jvisualvmCommandLine)));
            }
            Process jvisualvmProcess = Runtime.getRuntime().exec((String[])jvisualvmCommandLine);
            this.getGfsh().printAsInfo("Launched JVisualVM");
            String jvisualvmProcessOutput = this.waitAndCaptureProcessStandardErrorStream(jvisualvmProcess);
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            if (!StringUtils.isBlank(jvisualvmProcessOutput)) {
                infoResultData.addLine(StringUtils.LINE_SEPARATOR);
                infoResultData.addLine(jvisualvmProcessOutput);
            }
            return ResultBuilder.buildResult(infoResultData);
        }
        catch (GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching Java VisualVM - %1$s", LauncherLifecycleCommands.toString(t, false)));
        }
    }

    protected String[] createJVisualVMCommandLine(List<String> jvmArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJVisualVMPathname());
        if (jvmArgs != null) {
            for (String arg : jvmArgs) {
                commandLine.add("-J" + arg);
            }
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    protected String getJVisualVMPathname() {
        if (SystemUtils.isMacOSX()) {
            try {
                return IOUtils.verifyPathnameExists("/System/Library/Java/Support/VisualVM.bundle/Contents/Home/bin/jvisualvm");
            }
            catch (FileNotFoundException e) {
                throw new VisualVmNotFoundException("Java VisualVM could not be found on this system.\nPlease ensure that \"jvisualvm\" is installed in the JDK bin directory and the JDK bin directory is in the system PATH.", e);
            }
        }
        try {
            return this.getJdkToolPathname("jvisualvm" + LauncherLifecycleCommands.getExecutableSuffix(), (GemFireException)new VisualVmNotFoundException("Java VisualVM could not be found on this system.\nPlease ensure that \"jvisualvm\" is installed in the JDK bin directory and the JDK bin directory is in the system PATH."));
        }
        catch (VisualVmNotFoundException e) {
            if (!SystemUtils.isJavaVersionAtLeast("1.6")) {
                throw new VisualVmNotFoundException("Java VisualVM was not bundled with the JDK until version 1.6.\nDownload and install Java VisualVM to the JDK bin directory separately.");
            }
            throw e;
        }
    }

    @CliCommand(value={"start pulse"}, help="Open a new window in the default Web browser with the URL for the Pulse application.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startPulse(@CliOption(key={"url"}, unspecifiedDefaultValue="http://localhost:7070/pulse", help="URL of the Pulse Web application.") String url) {
        try {
            if (!StringUtils.isBlank(url)) {
                this.browse(URI.create(url));
                return ResultBuilder.createInfoResult("Launched Geode Pulse");
            }
            if (this.isConnectedAndReady()) {
                ObjectName managerObjectName;
                OperationInvoker operationInvoker = this.getGfsh().getOperationInvoker();
                String pulseURL = (String)operationInvoker.getAttribute((managerObjectName = (ObjectName)operationInvoker.getAttribute("GemFire:service=System,type=Distributed", "ManagerObjectName")).toString(), "PulseURL");
                if (!StringUtils.isBlank(pulseURL)) {
                    this.browse(URI.create(pulseURL));
                    return ResultBuilder.createInfoResult("Launched Geode Pulse with URL: " + pulseURL);
                }
                String pulseMessage = (String)operationInvoker.getAttribute(managerObjectName.toString(), "StatusMessage");
                return !StringUtils.isBlank(pulseMessage) ? ResultBuilder.createGemFireErrorResult(pulseMessage) : ResultBuilder.createGemFireErrorResult("Could not find the URL for Geode Pulse.");
            }
            return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected for launching {0}", (Object)"GemFire Pulse"));
        }
        catch (GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (Exception e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching Geode Pulse - %1$s", LauncherLifecycleCommands.toString(t, false)));
        }
    }

    private void browse(URI uri) throws IOException {
        LauncherLifecycleCommands.assertState(Desktop.isDesktopSupported(), String.format("Running desktop applications is not supported on %1$s.", System.getProperty("os.name")), new Object[0]);
        Desktop.getDesktop().browse(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected File readIntoTempFile(String classpathResourceLocation) throws IOException {
        String resourceName = classpathResourceLocation.substring(classpathResourceLocation.lastIndexOf(File.separator) + 1);
        File resourceFile = new File(System.getProperty("java.io.tmpdir"), resourceName);
        if (!resourceFile.exists() && resourceFile.createNewFile()) {
            BufferedReader resourceReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream(classpathResourceLocation)));
            BufferedWriter resourceFileWriter = new BufferedWriter(new FileWriter(resourceFile, false));
            try {
                String line = resourceReader.readLine();
                while (line != null) {
                    resourceFileWriter.write(line);
                    resourceFileWriter.write(StringUtils.LINE_SEPARATOR);
                    line = resourceReader.readLine();
                }
                resourceFileWriter.flush();
            }
            finally {
                IOUtils.close(resourceReader);
                IOUtils.close(resourceFileWriter);
            }
        }
        resourceFile.deleteOnExit();
        return resourceFile;
    }

    @CliCommand(value={"start vsd"}, help="Start VSD in a separate process.")
    @CliMetaData(shellOnly=true, relatedTopic={"Management-Monitoring", "Statistics"})
    public Result startVsd(@CliOption(key={"file"}, help="File or directory from which to read the statistics archive(s).") String[] statisticsArchiveFilePathnames) {
        try {
            String gemfireHome = System.getenv("GEMFIRE");
            LauncherLifecycleCommands.assertState(!StringUtils.isBlank(gemfireHome), "The GEODE environment variable was not defined.  Please set the GEODE environment variable to the directory where GEODE is installed.", new Object[0]);
            LauncherLifecycleCommands.assertState(IOUtils.isExistingPathname(this.getPathToVsd()), String.format("The location of VSD could not be found.  Please ensure VSD was properly installed under Geode home (%1$s).", gemfireHome), new Object[0]);
            Object[] vsdCommandLine = this.createdVsdCommandLine(statisticsArchiveFilePathnames);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("GemFire VSD command-line (%1$s)", Arrays.toString(vsdCommandLine)));
            }
            Process vsdProcess = Runtime.getRuntime().exec((String[])vsdCommandLine);
            this.getGfsh().printAsInfo("Launched Geode Visual Statistics Display (VSD) (see Geode log files for issues on start)");
            String vsdProcessOutput = this.waitAndCaptureProcessStandardErrorStream(vsdProcess);
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            if (!StringUtils.isBlank(vsdProcessOutput)) {
                infoResultData.addLine(StringUtils.LINE_SEPARATOR);
                infoResultData.addLine(vsdProcessOutput);
            }
            return ResultBuilder.buildResult(infoResultData);
        }
        catch (GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (FileNotFoundException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching VSD - %1$s", LauncherLifecycleCommands.toString(t, false)));
        }
    }

    protected String[] createdVsdCommandLine(String[] statisticsArchiveFilePathnames) throws FileNotFoundException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getPathToVsd());
        commandLine.addAll(this.processStatisticsArchiveFiles(statisticsArchiveFilePathnames));
        return commandLine.toArray(new String[commandLine.size()]);
    }

    protected String getPathToVsd() {
        String vsdPathname = IOUtils.appendToPath(System.getenv("GEMFIRE"), "tools", "vsd", "bin", "vsd");
        if (SystemUtils.isWindows()) {
            vsdPathname = vsdPathname + ".bat";
        }
        return vsdPathname;
    }

    protected Set<String> processStatisticsArchiveFiles(String[] statisticsArchiveFilePathnames) throws FileNotFoundException {
        TreeSet<String> statisticsArchiveFiles = new TreeSet<String>();
        if (statisticsArchiveFilePathnames != null) {
            for (String pathname : statisticsArchiveFilePathnames) {
                File path = new File(pathname);
                if (path.exists()) {
                    if (path.isFile()) {
                        if (StatisticsArchiveFileFilter.INSTANCE.accept(path)) {
                            statisticsArchiveFiles.add(pathname);
                            continue;
                        }
                        throw new IllegalArgumentException("A Statistics Archive File must end with a .gfs file extension.");
                    }
                    this.processStatisticsArchiveFiles(path, statisticsArchiveFiles);
                    continue;
                }
                throw new FileNotFoundException(String.format("The pathname (%1$s) does not exist.  Please check the path and try again.", path.getAbsolutePath()));
            }
        }
        return statisticsArchiveFiles;
    }

    protected void processStatisticsArchiveFiles(File path, Set<String> statisticsArchiveFiles) {
        if (path != null && path.isDirectory()) {
            for (File file : path.listFiles(StatisticsArchiveFileAndDirectoryFilter.INSTANCE)) {
                if (file.isDirectory()) {
                    this.processStatisticsArchiveFiles(file, statisticsArchiveFiles);
                    continue;
                }
                if (!StatisticsArchiveFileFilter.INSTANCE.accept(file)) continue;
                statisticsArchiveFiles.add(file.getAbsolutePath());
            }
        }
    }

    @CliMetaData(shellOnly=true, relatedTopic={"Management-Monitoring"})
    public Result startDataBrowser() {
        try {
            String gemfireHome = System.getenv("GEMFIRE");
            LauncherLifecycleCommands.assertState(!StringUtils.isBlank(gemfireHome), "The GEODE environment variable was not defined.  Please set the GEODE environment variable to the directory where GEODE is installed.", new Object[0]);
            if (this.isConnectedAndReady() && this.getGfsh().getOperationInvoker() instanceof JmxOperationInvoker) {
                String dataBrowserPath = this.getPathToDataBrowser();
                LauncherLifecycleCommands.assertState(IOUtils.isExistingPathname(dataBrowserPath), String.format("The location of DataBrowser could not be found.  Please ensure DataBrowser was properly installed under Geode home (%1$s).", gemfireHome), new Object[0]);
                JmxOperationInvoker operationInvoker = (JmxOperationInvoker)this.getGfsh().getOperationInvoker();
                String dataBrowserCommandLine = String.format("%1$s %2$s %3$d", this.getPathToDataBrowser(), operationInvoker.getManagerHost(), operationInvoker.getManagerPort());
                if (this.isDebugging()) {
                    this.getGfsh().printAsInfo(String.format("GemFire DataBrowser command-line (%1$s)", dataBrowserCommandLine));
                }
                Process dataBrowserProcess = Runtime.getRuntime().exec(dataBrowserCommandLine);
                this.getGfsh().printAsInfo("Launched Geode DataBrowser (see Geode log files for issues on start)");
                String dataBrowserProcessOutput = this.waitAndCaptureProcessStandardOutputStream(dataBrowserProcess);
                InfoResultData infoResultData = ResultBuilder.createInfoResultData();
                if (!StringUtils.isBlank(dataBrowserProcessOutput)) {
                    infoResultData.addLine(StringUtils.LINE_SEPARATOR);
                    infoResultData.addLine(dataBrowserProcessOutput);
                }
                return ResultBuilder.buildResult(infoResultData);
            }
            return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected via JMX for launching {0}", (Object)"GemFire DataBrowser"));
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(t.getMessage());
        }
    }

    protected String getPathToDataBrowser() {
        String dataBrowserPathName = IOUtils.appendToPath(GEMFIRE_HOME, "tools", "DataBrowser", "bin", "databrowser");
        if (SystemUtils.isWindows()) {
            dataBrowserPathName = dataBrowserPathName + ".bat";
        }
        return dataBrowserPathName;
    }

    protected String waitAndCaptureProcessStandardOutputStream(Process process) {
        return this.waitAndCaptureProcessStandardOutputStream(process, 5000L);
    }

    protected String waitAndCaptureProcessStandardOutputStream(Process process, long waitTimeMilliseconds) {
        return this.waitAndCaptureProcessStream(process, process.getInputStream(), waitTimeMilliseconds);
    }

    protected String waitAndCaptureProcessStandardErrorStream(Process process) {
        return this.waitAndCaptureProcessStandardErrorStream(process, 5000L);
    }

    protected String waitAndCaptureProcessStandardErrorStream(Process process, long waitTimeMilliseconds) {
        return this.waitAndCaptureProcessStream(process, process.getErrorStream(), waitTimeMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitAndCaptureProcessStream(Process process, InputStream processInputStream, long waitTimeMilliseconds) {
        final StringBuffer buffer = new StringBuffer();
        ProcessStreamReader.InputListener inputListener = new ProcessStreamReader.InputListener(){

            @Override
            public void notifyInputLine(String line) {
                buffer.append(line);
                buffer.append(StringUtils.LINE_SEPARATOR);
            }
        };
        ProcessStreamReader reader = new ProcessStreamReader.Builder(process).inputStream(processInputStream).inputListener(inputListener).build();
        try {
            reader.start();
            long endTime = System.currentTimeMillis() + waitTimeMilliseconds;
            while (System.currentTimeMillis() < endTime) {
                try {
                    reader.join(waitTimeMilliseconds);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            reader.stop();
        }
        return buffer.toString();
    }

    @CliAvailabilityIndicator(value={"start locator", "stop locator", "status locator", "start server", "stop server", "status server", "start manager", "start pulse", "start vsd", "start data-browser"})
    public boolean launcherCommandsAvailable() {
        return true;
    }

    protected static class StatisticsArchiveFileAndDirectoryFilter
    extends StatisticsArchiveFileFilter {
        protected static final StatisticsArchiveFileAndDirectoryFilter INSTANCE = new StatisticsArchiveFileAndDirectoryFilter();

        protected StatisticsArchiveFileAndDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || super.accept(pathname);
        }
    }

    protected static class StatisticsArchiveFileFilter
    implements FileFilter {
        protected static final StatisticsArchiveFileFilter INSTANCE = new StatisticsArchiveFileFilter();

        protected StatisticsArchiveFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getAbsolutePath().endsWith(".gfs");
        }
    }

    protected static final class LauncherSignalListener
    implements SignalListener {
        private volatile boolean signaled = false;

        protected LauncherSignalListener() {
        }

        public boolean isSignaled() {
            return this.signaled;
        }

        @Override
        public void handle(SignalEvent event) {
            this.signaled = true;
        }
    }
}

