/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.annotation.CliArgument;
import org.apache.geode.management.internal.cli.help.CliTopic;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;

public class GfshHelpCommands
implements CommandMarker {
    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"help"}, help="Display syntax and usage information for all commands or list all available commands if <command> isn't specified.")
    @CliMetaData(shellOnly=true, relatedTopic={"Help"})
    public Result obtainHelp(@CliArgument(name="command", argumentContext="help:disable-string-converter", help="Name of the command for which help will be displayed.") String commandString) {
        return ResultBuilder.createInfoResult(this.getGfsh().obtainHelp(commandString, null));
    }

    @CliCommand(value={"hint"}, help="Provide hints for a topic or list all available topics if \"topic\" isn't specified.")
    @CliMetaData(shellOnly=true, relatedTopic={"Help"})
    public Result hint(@CliArgument(name="topic", argumentContext="converter.hint.gfsh.hint.topic", help="topic") String topicName) {
        Result result = null;
        CommandManager commandManager = CommandManager.getExisting();
        if (commandManager == null) {
            result = ResultBuilder.createShellClientErrorResult("Shell is not initialized properly. Please restart the shell. Check gfsh-<timestamp>.log for errors.");
        } else {
            StringBuilder builder = new StringBuilder();
            if (topicName == null) {
                builder.append("Hints are available for the following topics. Use \"hint <topic-name>\" for a specific hint.").append(GfshParser.LINE_SEPARATOR);
                Set<String> topicNameSet = commandManager.getTopicNames();
                for (String topic : topicNameSet) {
                    builder.append(topic).append(GfshParser.LINE_SEPARATOR);
                }
                result = ResultBuilder.createInfoResult(builder.toString());
            } else {
                CliTopic topic = commandManager.getTopic(topicName);
                if (topic == null) {
                    result = ResultBuilder.createInfoResult(CliStrings.format("Unknown topic: {0}. Use hint; to view the list of available topics.", (Object)topicName));
                } else {
                    CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
                    CompositeResultData.SectionResultData commandHelpSection = compositeResultData.addSection("Commands And Help");
                    compositeResultData.setHeader(topic.getOneLinerDescription());
                    Map<String, String> commandsNameHelp = topic.getCommandsNameHelp();
                    Set<Map.Entry<String, String>> entries = commandsNameHelp.entrySet();
                    for (Map.Entry<String, String> entry : entries) {
                        commandHelpSection.addData(entry.getKey(), entry.getValue());
                    }
                    result = ResultBuilder.buildResult(compositeResultData);
                }
            }
        }
        return result;
    }
}

