/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.ExportLogsFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.ExportLogsCacheWriter;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportLogCommand
implements CommandMarker {
    public static final String FORMAT = "yyyy/MM/dd/HH/mm/ss/SSS/z";
    public static final String ONLY_DATE_FORMAT = "yyyy/MM/dd";
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"export logs"}, help="Export the log files for a member or members.")
    @CliMetaData(shellOnly=false, isFileDownloadOverHttp=true, interceptor="org.apache.geode.management.internal.cli.commands.ExportLogCommand$ExportLogsInterceptor", relatedTopic={"Server", "Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportLogs(@CliOption(key={"dir"}, help="Local directory to which logs will be written. This is used only when you are exporting logs using an http connection. If not specified, logs are written to the location specified by the user.dir system property.", mandatory=false) String dirName, @CliOption(key={"group"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.groups", help="Group of members whose log files will be exported.") String[] groups, @CliOption(key={"member"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.all.member.idOrName", help="Name/Id of the member whose log files will be exported.") String[] memberIds, @CliOption(key={"log-level"}, unspecifiedDefaultValue="INFO", optionContext="converter.hint.log.levels", help="Minimum level of log entries to export. Valid values are: fatal, error, warn, info, debug, trace and all.  The default is \"INFO\".") String logLevel, @CliOption(key={"only-log-level"}, unspecifiedDefaultValue="false", help="Whether to only include those entries that exactly match the --log-level specified.") boolean onlyLogLevel, @CliOption(key={"merge-log"}, unspecifiedDefaultValue="false", help="Whether to merge logs after exporting to the target directory. Deprecated: Since Geode1.2, no longer used.") boolean mergeLog, @CliOption(key={"start-time"}, unspecifiedDefaultValue="__NULL__", help="Log entries that occurred after this time will be exported. The default is no limit. Format: yyyy/MM/dd/HH/mm/ss/SSS/z OR yyyy/MM/dd") String start, @CliOption(key={"end-time"}, unspecifiedDefaultValue="__NULL__", help="Log entries that occurred before this time will be exported. The default is no limit. Format: yyyy/MM/dd/HH/mm/ss/SSS/z OR yyyy/MM/dd") String end, @CliOption(key={"logs-only"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to only export logs") boolean logsOnly, @CliOption(key={"stats-only"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to only export statistics") boolean statsOnly) {
        Result result = null;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        try {
            Set<DistributedMember> targetMembers = CliUtil.findMembersIncludingLocators(groups, memberIds);
            if (targetMembers.isEmpty()) {
                Result result2 = ResultBuilder.createUserErrorResult("No Members Found");
                return result2;
            }
            HashMap<String, Path> zipFilesFromMembers = new HashMap<String, Path>();
            for (DistributedMember server : targetMembers) {
                Region region = ExportLogsFunction.createOrGetExistingExportLogsRegion(true, cache);
                ExportLogsCacheWriter cacheWriter = (ExportLogsCacheWriter)region.getAttributes().getCacheWriter();
                cacheWriter.startFile(server.getName());
                CliUtil.executeFunction((Function)new ExportLogsFunction(), (Object)new ExportLogsFunction.Args(start, end, logLevel, onlyLogLevel, logsOnly, statsOnly), server).getResult();
                Path zipFile = cacheWriter.endFile();
                ExportLogsFunction.destroyExportLogsRegion(cache);
                if (zipFile == null) continue;
                logger.info("Received zip file from member {}: {}", (Object)server.getId(), (Object)zipFile);
                zipFilesFromMembers.put(server.getId(), zipFile);
            }
            if (zipFilesFromMembers.isEmpty()) {
                Result result3 = ResultBuilder.createUserErrorResult("No files to be exported.");
                return result3;
            }
            Path tempDir = Files.createTempDirectory("exportedLogs", new FileAttribute[0]);
            Path exportedLogsDir = tempDir.resolve("exportedLogs");
            FileUtils.forceMkdir((File)exportedLogsDir.toFile());
            for (Path zipFile : zipFilesFromMembers.values()) {
                Path unzippedMemberDir = exportedLogsDir.resolve(zipFile.getFileName().toString().replace(".zip", ""));
                ZipUtils.unzip(zipFile.toAbsolutePath().toString(), unzippedMemberDir.toString());
                FileUtils.deleteQuietly((File)zipFile.toFile());
            }
            Path workingDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path exportedLogsZipFile = workingDir.resolve("exportedLogs_" + System.currentTimeMillis() + ".zip").toAbsolutePath();
            logger.info("Zipping into: " + exportedLogsZipFile.toString());
            ZipUtils.zipDirectory(exportedLogsDir, exportedLogsZipFile);
            FileUtils.deleteDirectory((File)tempDir.toFile());
            result = ResultBuilder.createInfoResult(exportedLogsZipFile.toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
            result = ResultBuilder.createGemFireErrorResult(ex.getMessage());
        }
        finally {
            ExportLogsFunction.destroyExportLogsRegion(cache);
        }
        logger.debug("Exporting logs returning = {}", (Object)result);
        return result;
    }

    public static class ExportLogsInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            LocalDateTime endTime;
            LocalDateTime startTime;
            Map<String, String> arguments = parseResult.getParamValueStrings();
            if (arguments.get("group") != null && arguments.get("member") != null) {
                return ResultBuilder.createUserErrorResult("Can't specify both group and member.");
            }
            String logLevel = arguments.get("log-level");
            if (StringUtils.isBlank((String)logLevel) || Level.getLevel((String)logLevel.toUpperCase()) == null) {
                return ResultBuilder.createUserErrorResult("Invalid log level: " + logLevel);
            }
            String start = arguments.get("start-time");
            String end = arguments.get("end-time");
            if (start != null && end != null && (startTime = ExportLogsFunction.parseTime(start)).isAfter(endTime = ExportLogsFunction.parseTime(end))) {
                return ResultBuilder.createUserErrorResult("start-time has to be earlier than end-time.");
            }
            boolean onlyLogs = Boolean.parseBoolean(arguments.get("logs-only"));
            boolean onlyStats = Boolean.parseBoolean(arguments.get("stats-only"));
            if (onlyLogs && onlyStats) {
                return ResultBuilder.createUserErrorResult("logs-only and stats-only can't both be true");
            }
            return ResultBuilder.createInfoResult("");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (tempFile != null) {
                String dirName = parseResult.getParamValueStrings().get("dir");
                Path dirPath = StringUtils.isBlank((String)dirName) ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(dirName, new String[0]);
                String fileName = "exportedLogs_" + System.currentTimeMillis() + ".zip";
                File exportedLogFile = dirPath.resolve(fileName).toFile();
                try {
                    FileUtils.copyFile((File)tempFile.toFile(), (File)exportedLogFile);
                    FileUtils.deleteQuietly((File)tempFile.toFile());
                    commandResult = ResultBuilder.createInfoResult("Logs exported to: " + exportedLogFile.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    commandResult = ResultBuilder.createGemFireErrorResult(e.getMessage());
                }
            } else if (commandResult.getStatus() == Result.Status.OK) {
                commandResult = ResultBuilder.createInfoResult("Logs exported to the connected member's file system: " + commandResult.nextLine());
            }
            return commandResult;
        }
    }
}

