/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ExportSharedConfigurationFunction;
import org.apache.geode.management.internal.cli.functions.ImportSharedConfigurationArtifactsFunction;
import org.apache.geode.management.internal.cli.functions.LoadSharedConfigurationFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportImportSharedConfigurationCommands
extends AbstractCommandsSupport {
    private final ExportSharedConfigurationFunction exportSharedConfigurationFunction = new ExportSharedConfigurationFunction();
    private final ImportSharedConfigurationArtifactsFunction importSharedConfigurationFunction = new ImportSharedConfigurationArtifactsFunction();
    private final LoadSharedConfigurationFunction loadSharedConfiguration = new LoadSharedConfigurationFunction();

    @CliCommand(value={"export cluster-configuration"}, help="Exports the cluster configuration artifacts as a zip file.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportSharedConfigurationCommands$ExportInterceptor", readsSharedConfiguration=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="Name of the zip file containing the exported cluster configuration artifacts") String zipFileName, @CliOption(key={"dir"}, help="The directory in which the exported cluster configuration artifacts will be saved") String dir) {
        Result result;
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        TabularResultData errorTable = ResultBuilder.createTabularResultData();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        HashSet<InternalDistributedMember> locators = new HashSet<InternalDistributedMember>(cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        boolean success = false;
        if (!locators.isEmpty()) {
            for (DistributedMember distributedMember : locators) {
                ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.exportSharedConfigurationFunction, null, distributedMember);
                List results = (List)rc.getResult();
                CliFunctionResult functionResult = (CliFunctionResult)results.get(0);
                if (functionResult.isSuccessful()) {
                    byte[] byteData = functionResult.getByteData();
                    infoData.addAsFile(zipFileName, byteData, 0, "Downloading cluster configuration : {0}", false);
                    success = true;
                    break;
                }
                errorTable.accumulate("Locator", functionResult.getMemberIdOrName());
                errorTable.accumulate("Error", functionResult.getMessage());
            }
            if (success) {
                result = ResultBuilder.buildResult(infoData);
            } else {
                errorTable.setStatus(Result.Status.ERROR);
                result = ResultBuilder.buildResult(errorTable);
            }
        } else {
            result = ResultBuilder.createGemFireErrorResult("No locators with cluster configuration enabled.");
        }
        return result;
    }

    @CliCommand(value={"import cluster-configuration"}, help="Imports configuration into cluster configuration hosted at the locators")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportSharedConfigurationCommands$ImportInterceptor", writesToSharedConfiguration=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result importSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="The zip file containing the cluster configuration artifacts, which are to be imported") String zip) {
        Result result;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (!CliUtil.getAllNormalMembers(cache).isEmpty()) {
            return ResultBuilder.createGemFireErrorResult("Cluster configuration cannot be imported when there are running data members present in the distributed system.\nShutdown all the non locator members to import the cluster configuration, and restart them after the cluster configuration is successfully imported.");
        }
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (locators.isEmpty()) {
            return ResultBuilder.createGemFireErrorResult("No locators found with \"enable-cluster-configuration=true\".");
        }
        byte[][] shellBytesData = CommandExecutionContext.getBytesFromShell();
        String[] names = CliUtil.bytesToNames(shellBytesData);
        byte[][] bytes = CliUtil.bytesToData(shellBytesData);
        String zipFileName = names[0];
        byte[] zipBytes = bytes[0];
        Object[] args = new Object[]{zipFileName, zipBytes};
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        TabularResultData errorTable = ResultBuilder.createTabularResultData();
        boolean success = false;
        boolean copySuccess = false;
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.importSharedConfigurationFunction, (Object)args, locators);
        List functionResults = CliFunctionResult.cleanResults((List)rc.getResult());
        for (CliFunctionResult functionResult : functionResults) {
            if (!functionResult.isSuccessful()) {
                errorTable.accumulate("Locator", functionResult.getMemberIdOrName());
                errorTable.accumulate("Error", functionResult.getMessage());
                continue;
            }
            copySuccess = true;
        }
        if (!copySuccess) {
            errorTable.setStatus(Result.Status.ERROR);
            return ResultBuilder.buildResult(errorTable);
        }
        errorTable = ResultBuilder.createTabularResultData();
        for (DistributedMember locator : locators) {
            rc = CliUtil.executeFunction((Function)this.loadSharedConfiguration, (Object)args, locator);
            functionResults = (List)rc.getResult();
            CliFunctionResult functionResult = (CliFunctionResult)functionResults.get(0);
            if (functionResult.isSuccessful()) {
                success = true;
                infoData.addLine(functionResult.getMessage());
                break;
            }
            errorTable.accumulate("Locator", functionResult.getMemberIdOrName());
            errorTable.accumulate("Error", functionResult.getMessage());
        }
        if (success) {
            result = ResultBuilder.buildResult(infoData);
        } else {
            errorTable.setStatus(Result.Status.ERROR);
            result = ResultBuilder.buildResult(errorTable);
        }
        return result;
    }

    @CliAvailabilityIndicator(value={"export cluster-configuration", "import cluster-configuration"})
    public boolean sharedConfigCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static class ImportInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            FileResult fileResult;
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String zip = paramValueMap.get("zip-file-name");
            if ((zip = StringUtils.trim(zip)) == null) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Parameter \"{0}\"  is required. Use \"help <command name>\" for assistance.", (Object)"zip-file-name"));
            }
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            try {
                fileResult = new FileResult(new String[]{zip});
            }
            catch (FileNotFoundException fnfex) {
                return ResultBuilder.createUserErrorResult("'" + zip + "' not found.");
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult(ioex.getClass().getName() + ": " + ioex.getMessage());
            }
            return fileResult;
        }
    }

    public static class ExportInterceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String zip = paramValueMap.get("zip-file-name");
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            return ResultBuilder.createInfoResult("OK");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (commandResult.hasIncomingFiles()) {
                try {
                    Map<String, String> paramValueMap = parseResult.getParamValueStrings();
                    String dir = paramValueMap.get("dir");
                    dir = dir == null ? null : dir.trim();
                    File saveDirFile = new File(".");
                    if (dir != null && !dir.isEmpty()) {
                        saveDirFile = new File(dir);
                        if (saveDirFile.exists()) {
                            if (!saveDirFile.isDirectory()) {
                                return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not a directory.", (Object)dir));
                            }
                        } else if (!saveDirFile.mkdirs()) {
                            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Directory {0} could not be created.", (Object)dir));
                        }
                    }
                    try {
                        if (!saveDirFile.canWrite()) {
                            return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not writeable", (Object)saveDirFile.getCanonicalPath()));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.saveDirString = saveDirFile.getAbsolutePath();
                    commandResult.saveIncomingFiles(this.saveDirString);
                    return commandResult;
                }
                catch (IOException ioex) {
                    return ResultBuilder.createShellClientErrorResult("Unable to export config");
                }
            }
            return null;
        }
    }
}

