/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.GemFireIOException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.BackupStatus;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.partitioned.ColocatedRegionDetails;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.lang.ClassUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.DescribeDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.ListDiskStoresFunction;
import org.apache.geode.management.internal.cli.functions.ShowMissingDiskStoresFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.DiskStoreCompacter;
import org.apache.geode.management.internal.cli.util.DiskStoreNotFoundException;
import org.apache.geode.management.internal.cli.util.DiskStoreUpgrader;
import org.apache.geode.management.internal.cli.util.DiskStoreValidater;
import org.apache.geode.management.internal.cli.util.MemberNotFoundException;
import org.apache.geode.management.internal.configuration.SharedConfigurationWriter;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.messages.CompactRequest;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DiskStoreCommands
extends AbstractCommandsSupport {
    @Override
    protected Set<DistributedMember> getMembers(Cache cache) {
        return CliUtil.getAllMembers(cache);
    }

    protected Set<DistributedMember> getNormalMembers(Cache cache) {
        return CliUtil.getAllNormalMembers(cache);
    }

    @CliCommand(value={"backup disk-store"}, help="Perform a backup on all members with persistent data. The target directory must exist on all members, but can be either local or shared. This command can safely be executed on active members and is strongly recommended over copying files via operating system commands.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.READ)
    public Result backupDiskStore(@CliOption(key={"dir"}, unspecifiedDefaultValue="__NULL__", help="Directory to which backup files will be written.", mandatory=true) String targetDir, @CliOption(key={"baseline-dir"}, help="Directory which contains the baseline backup used for comparison during an incremental backup.") String baselineDir) {
        Result result = null;
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            DM dm = cache.getDistributionManager();
            BackupStatus backupStatus = null;
            backupStatus = baselineDir != null && !baselineDir.isEmpty() ? AdminDistributedSystemImpl.backupAllMembers(dm, new File(targetDir), new File(baselineDir)) : AdminDistributedSystemImpl.backupAllMembers(dm, new File(targetDir), null);
            Map<DistributedMember, Set<PersistentID>> backedupMemberDiskstoreMap = backupStatus.getBackedUpDiskStores();
            Set<DistributedMember> backedupMembers = backedupMemberDiskstoreMap.keySet();
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            if (!backedupMembers.isEmpty()) {
                CompositeResultData.SectionResultData backedupDiskStoresSection = crd.addSection();
                backedupDiskStoresSection.setHeader("The following disk stores were backed up successfully");
                TabularResultData backedupDiskStoresTable = backedupDiskStoresSection.addTable();
                for (DistributedMember member : backedupMembers) {
                    Set<PersistentID> backedupDiskStores = backedupMemberDiskstoreMap.get(member);
                    boolean printMember = true;
                    String memberName = member.getName();
                    if (memberName == null || memberName.isEmpty()) {
                        memberName = member.getId();
                    }
                    for (PersistentID persistentId : backedupDiskStores) {
                        if (persistentId == null) continue;
                        String UUID2 = persistentId.getUUID().toString();
                        String hostName = persistentId.getHost().getHostName();
                        String directory = persistentId.getDirectory();
                        if (printMember) {
                            this.writeToBackupDisktoreTable(backedupDiskStoresTable, memberName, UUID2, hostName, directory);
                            printMember = false;
                            continue;
                        }
                        this.writeToBackupDisktoreTable(backedupDiskStoresTable, "", UUID2, hostName, directory);
                    }
                }
            } else {
                CompositeResultData.SectionResultData noMembersBackedUp = crd.addSection();
                noMembersBackedUp.setHeader("No disk store(s) were backed up.");
            }
            Set<PersistentID> offlineDiskStores = backupStatus.getOfflineDiskStores();
            if (!offlineDiskStores.isEmpty()) {
                CompositeResultData.SectionResultData offlineDiskStoresSection = crd.addSection();
                TabularResultData offlineDiskStoresTable = offlineDiskStoresSection.addTable();
                offlineDiskStoresSection.setHeader("The backup may be incomplete. The following disk stores are not online");
                for (PersistentID offlineDiskStore : offlineDiskStores) {
                    offlineDiskStoresTable.accumulate("UUID", offlineDiskStore.getUUID().toString());
                    offlineDiskStoresTable.accumulate("Host", offlineDiskStore.getHost().getHostName());
                    offlineDiskStoresTable.accumulate("Directory", offlineDiskStore.getDirectory());
                }
            }
            result = ResultBuilder.buildResult(crd);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    private void writeToBackupDisktoreTable(TabularResultData backedupDiskStoreTable, String memberId, String UUID2, String host, String directory) {
        backedupDiskStoreTable.accumulate("Member", memberId);
        backedupDiskStoreTable.accumulate("UUID", UUID2);
        backedupDiskStoreTable.accumulate("Directory", directory);
        backedupDiskStoreTable.accumulate("Host", host);
    }

    @CliCommand(value={"list disk-stores"}, help="Display disk stores for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listDiskStore() {
        try {
            Set<DistributedMember> dataMembers = this.getNormalMembers(this.getCache());
            if (dataMembers.isEmpty()) {
                return ResultBuilder.createInfoResult("No caching members found.");
            }
            return this.toTabularResult(this.getDiskStoreListing(dataMembers));
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"list disk-stores"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while collecting Disk Store information for all members across the Geode cluster: %1$s", DiskStoreCommands.toString(t, this.isDebugging())));
        }
    }

    protected List<DiskStoreDetails> getDiskStoreListing(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector<?, ?> resultCollector = membersFunctionExecutor.execute(new ListDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList<DiskStoreDetails> distributedSystemMemberDiskStores = new ArrayList<DiskStoreDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedSystemMemberDiskStores.addAll((Set)result);
        }
        Collections.sort(distributedSystemMemberDiskStores);
        return distributedSystemMemberDiskStores;
    }

    protected Result toTabularResult(List<DiskStoreDetails> diskStoreList) throws ResultDataException {
        if (!diskStoreList.isEmpty()) {
            TabularResultData diskStoreData = ResultBuilder.createTabularResultData();
            for (DiskStoreDetails diskStoreDetails : diskStoreList) {
                diskStoreData.accumulate("Member Name", diskStoreDetails.getMemberName());
                diskStoreData.accumulate("Member Id", diskStoreDetails.getMemberId());
                diskStoreData.accumulate("Disk Store Name", diskStoreDetails.getName());
                diskStoreData.accumulate("Disk Store ID", diskStoreDetails.getId());
            }
            return ResultBuilder.buildResult(diskStoreData);
        }
        return ResultBuilder.createInfoResult("No Disk Stores Found");
    }

    @CliCommand(value={"create disk-store"}, help="Create a disk store.")
    @CliMetaData(shellOnly=false, relatedTopic={"Disk Store"}, writesToSharedConfiguration=true)
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="converter.hint.cluster.diskstore", help="Name of the disk store to be created.") String name, @CliOption(key={"allow-force-compaction"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to allow manual compaction through the API or command-line tools.") boolean allowForceCompaction, @CliOption(key={"auto-compact"}, specifiedDefaultValue="true", unspecifiedDefaultValue="true", help="Whether to automatically compact a file when it reaches the compaction-threshold.") boolean autoCompact, @CliOption(key={"compaction-threshold"}, unspecifiedDefaultValue="50", help="Percentage of garbage allowed in the file before it is eligible for compaction.") int compactionThreshold, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="1024", help="The largest size, in megabytes, to allow an operation log to become before automatically rolling to a new file.") int maxOplogSize, @CliOption(key={"queue-size"}, unspecifiedDefaultValue="0", help="For asynchronous queueing. The maximum number of operations to allow into the write queue before automatically flushing the queue. The default of 0 indicates no limit.") int queueSize, @CliOption(key={"time-interval"}, unspecifiedDefaultValue="1000", help="For asynchronous queueing. The number of milliseconds that can elapse before data is flushed to disk. Reaching this limit or the queue-size limit causes the queue to flush.") long timeInterval, @CliOption(key={"write-buffer-size"}, unspecifiedDefaultValue="32768", help="Size of the buffer used to write to disk.") int writeBufferSize, @CliOption(key={"dir"}, mandatory=true, help="Directories where the disk store files will be written, the directories will be created if they don't exist.  Optionally, directory names may be followed by # and the maximum number of megabytes that the disk store can use in the directory.  Example: --dir=/data/ds1 --dir=/data/ds2#5000", optionContext="converter.hint.disable-string-converter") @CliMetaData(valueSeparator=",") String[] directoriesAndSizes, @CliOption(key={"group"}, help="Group(s) of members on which the disk store will be created. If no group is specified the disk store will be created on all members.", optionContext="converter.hint.member.groups") @CliMetaData(valueSeparator=",") String[] groups, @CliOption(key={"disk-usage-warning-percentage"}, unspecifiedDefaultValue="90", help="Warning percentage for disk volume usage.") float diskUsageWarningPercentage, @CliOption(key={"disk-usage-critical-percentage"}, unspecifiedDefaultValue="99", help="Critical percentage for disk volume usage.") float diskUsageCriticalPercentage) {
        try {
            Set<DistributedMember> targetMembers;
            DiskStoreAttributes diskStoreAttributes = new DiskStoreAttributes();
            diskStoreAttributes.allowForceCompaction = allowForceCompaction;
            diskStoreAttributes.autoCompact = autoCompact;
            diskStoreAttributes.compactionThreshold = compactionThreshold;
            diskStoreAttributes.maxOplogSizeInBytes = maxOplogSize * 0x100000;
            diskStoreAttributes.queueSize = queueSize;
            diskStoreAttributes.timeInterval = timeInterval;
            diskStoreAttributes.writeBufferSize = writeBufferSize;
            File[] directories = new File[directoriesAndSizes.length];
            int[] sizes = new int[directoriesAndSizes.length];
            for (int i = 0; i < directoriesAndSizes.length; ++i) {
                int hashPosition = directoriesAndSizes[i].indexOf(35);
                if (hashPosition == -1) {
                    directories[i] = new File(directoriesAndSizes[i]);
                    sizes[i] = Integer.MAX_VALUE;
                    continue;
                }
                directories[i] = new File(directoriesAndSizes[i].substring(0, hashPosition));
                sizes[i] = Integer.parseInt(directoriesAndSizes[i].substring(hashPosition + 1));
            }
            diskStoreAttributes.diskDirs = directories;
            diskStoreAttributes.diskDirSizes = sizes;
            diskStoreAttributes.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
            diskStoreAttributes.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(groups, null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CreateDiskStoreFunction(), (Object)new Object[]{name, diskStoreAttributes}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            XmlEntity xmlEntity = null;
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity != null) continue;
                xmlEntity = result.getXmlEntity();
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("Unable to create disk store(s).");
            }
            Result result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity != null) {
                result.setCommandPersisted(new SharedConfigurationWriter().addXmlEntity(xmlEntity, groups));
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while creating the disk store: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }

    @CliCommand(value={"compact disk-store"}, help="Compact a disk store on all members with that disk store. This command uses the compaction threshold that each member has configured for its disk stores. The disk store must have \"allow-force-compaction\" set to true.")
    @CliMetaData(shellOnly=false, relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result compactDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="converter.hint.cluster.diskstore", help="Name of the disk store to be compacted.") String diskStoreName, @CliOption(key={"group"}, unspecifiedDefaultValue="__NULL__", help="Group(s) of members that will perform disk compaction. If no group is specified the disk store will be compacted by all members.", optionContext="converter.hint.disable-string-converter") @CliMetaData(valueSeparator=",") String[] groups) {
        Result result = null;
        try {
            if (!this.diskStoreExists(diskStoreName)) {
                result = ResultBuilder.createUserErrorResult(CliStrings.format("Disk store \"{0}\" does not exist.", new Object[]{diskStoreName}));
            } else {
                InternalDistributedSystem ds = (InternalDistributedSystem)this.getCache().getDistributedSystem();
                HashMap<DistributedMember, PersistentID> overallCompactInfo = new HashMap<DistributedMember, PersistentID>();
                Set otherMembers = ds.getDistributionManager().getOtherNormalDistributionManagerIds();
                HashSet<InternalDistributedMember> allMembers = new HashSet<InternalDistributedMember>();
                for (Object member : otherMembers) {
                    allMembers.add((InternalDistributedMember)member);
                }
                allMembers.add(ds.getDistributedMember());
                otherMembers = null;
                String groupInfo = "";
                if (groups != null && groups.length > 0) {
                    groupInfo = CliStrings.format(" for group(s) \"{0}\"", new Object[]{Arrays.toString(groups) + "."});
                    HashSet<InternalDistributedMember> selectedMembers = new HashSet<InternalDistributedMember>();
                    List<String> targetedGroups = Arrays.asList(groups);
                    for (InternalDistributedMember member : allMembers) {
                        List<String> memberGroups = member.getGroups();
                        if (Collections.disjoint(targetedGroups, memberGroups)) continue;
                        selectedMembers.add(member);
                    }
                    allMembers = selectedMembers;
                }
                if (allMembers.isEmpty()) {
                    result = ResultBuilder.createUserErrorResult(CliStrings.format("No members found in the specified group(s) \"{0}\".", new Object[]{Arrays.toString(groups)}));
                } else {
                    PersistentID compactedDiskStoreId;
                    if (allMembers.remove(ds.getDistributedMember()) && (compactedDiskStoreId = CompactRequest.compactDiskStore(diskStoreName)) != null) {
                        overallCompactInfo.put(ds.getDistributedMember(), compactedDiskStoreId);
                    }
                    if (!allMembers.isEmpty()) {
                        Map<DistributedMember, PersistentID> memberCompactInfo = CompactRequest.send(ds.getDistributionManager(), diskStoreName, allMembers);
                        if (memberCompactInfo != null && !memberCompactInfo.isEmpty()) {
                            overallCompactInfo.putAll(memberCompactInfo);
                            memberCompactInfo.clear();
                        }
                        String notExecutedMembers = CompactRequest.getNotExecutedMembers();
                        LogWrapper.getInstance().info("compact disk-store \"" + diskStoreName + "\" message was scheduled to be sent to but was not send to " + notExecutedMembers);
                    }
                    if (overallCompactInfo != null && !overallCompactInfo.isEmpty()) {
                        CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
                        CompositeResultData.SectionResultData section = null;
                        Set entries = overallCompactInfo.entrySet();
                        for (Map.Entry entry : entries) {
                            String memberId = ((DistributedMember)entry.getKey()).getId();
                            section = compositeResultData.addSection(memberId);
                            section.addData("On Member", memberId);
                            PersistentID persistentID = (PersistentID)entry.getValue();
                            if (persistentID == null) continue;
                            CompositeResultData.SectionResultData subSection = section.addSection("DiskStore" + memberId);
                            subSection.addData("UUID", persistentID.getUUID());
                            subSection.addData("Host", persistentID.getHost().getHostName());
                            subSection.addData("Directory", persistentID.getDirectory());
                        }
                        compositeResultData.setHeader("Compacted " + diskStoreName + groupInfo);
                        result = ResultBuilder.buildResult(compositeResultData);
                    } else {
                        result = ResultBuilder.createInfoResult("Attempted to compact disk store, but there was nothing to do.");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while doing compaction: \"{0}\"", new Object[]{e.getMessage()}));
        }
        return result;
    }

    private boolean diskStoreExists(String diskStoreName) {
        Cache cache = this.getCache();
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Map<String, String[]> diskstore = dsMXBean.listMemberDiskstore();
        Set<Map.Entry<String, String[]>> entrySet = diskstore.entrySet();
        for (Map.Entry<String, String[]> entry : entrySet) {
            Object[] value = entry.getValue();
            if (!CliUtil.contains(value, diskStoreName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"compact offline-disk-store"}, help="Compact an offline disk store. If the disk store is large, additional memory may need to be allocated to the process using the --J=-Xmx??? parameter.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result compactOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the offline disk store to be compacted.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="Directories where data for the disk store was previously written.", optionContext="converter.hint.dirs:converter.hint.disable-string-converter") @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="-1", help="Maximum size (in megabytes) of the oplogs created by compaction.") long maxOplogSize, @CliOption(key={"J"}, unspecifiedDefaultValue="__NULL__", help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") @CliMetaData(valueSeparator=",") String[] jvmProps) {
        Result result = null;
        LogWrapper logWrapper = LogWrapper.getInstance();
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        String errorMessage = "";
        Process compacterProcess = null;
        try {
            String validatedDirectories = this.validatedDirectories(diskDirs);
            if (validatedDirectories != null) {
                throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            this.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                for (int i = 0; i < jvmProps.length; ++i) {
                    commandList.add(jvmProps[i]);
                }
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreCompacter.class.getName());
            commandList.add("name=" + diskStoreName);
            if (diskDirs != null && diskDirs.length != 0) {
                StringBuilder builder = new StringBuilder();
                int arrayLength = diskDirs.length;
                for (int i = 0; i < arrayLength; ++i) {
                    if (File.separatorChar == '\\') {
                        builder.append(diskDirs[i].replace("\\", "/"));
                    } else {
                        builder.append(diskDirs[i]);
                    }
                    if (i + 1 == arrayLength) continue;
                    builder.append(',');
                }
                commandList.add("disk-dirs=" + builder.toString());
            }
            commandList.add("max-oplog-size=" + maxOplogSize);
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            compacterProcess = procBuilder.start();
            InputStream inputStream = compacterProcess.getInputStream();
            InputStream errorStream = compacterProcess.getErrorStream();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
            String line = null;
            while ((line = inputReader.readLine()) != null) {
                output.append(line).append(GfshParser.LINE_SEPARATOR);
            }
            line = null;
            boolean switchToStackTrace = false;
            while ((line = errorReader.readLine()) != null) {
                if (!switchToStackTrace && DiskStoreCompacter.STACKTRACE_START.equals(line)) {
                    switchToStackTrace = true;
                    continue;
                }
                if (switchToStackTrace) {
                    error.append(line).append(GfshParser.LINE_SEPARATOR);
                    continue;
                }
                errorMessage = errorMessage + line;
            }
            if (!errorMessage.isEmpty()) {
                throw new GemFireIOException(errorMessage);
            }
            compacterProcess.destroy();
            result = ResultBuilder.createInfoResult(output.toString());
        }
        catch (IOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            String fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = fieldsMessage + CliUtil.arrayToString(diskDirs);
            String errorString = CliStrings.format("While compacting disk store={0} {1}. Reason: {2}", diskStoreName, fieldsMessage);
            result = ResultBuilder.createUserErrorResult(errorString);
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(e.getMessage(), e);
            }
        }
        catch (GemFireIOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(errorMessage);
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(error.toString());
            }
        }
        catch (IllegalArgumentException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        finally {
            if (compacterProcess != null) {
                try {
                    compacterProcess.exitValue();
                }
                catch (IllegalThreadStateException ise) {
                    compacterProcess.destroy();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"upgrade offline-disk-store"}, help="Upgrade an offline disk store. If the disk store is large, additional memory may need to be allocated to the process using the --J=-Xmx??? parameter.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result upgradeOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the offline disk store to be upgraded.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="Directories where data for the disk store was previously written.", optionContext="converter.hint.dirs:converter.hint.disable-string-converter") @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="-1", help="Maximum size (in megabytes) of the oplogs created by the upgrade.") long maxOplogSize, @CliOption(key={"J"}, unspecifiedDefaultValue="__NULL__", help="Arguments passed to the Java Virtual Machine performing the upgrade operation on the disk store.") @CliMetaData(valueSeparator=",") String[] jvmProps) throws InterruptedException {
        Result result = null;
        LogWrapper logWrapper = LogWrapper.getInstance();
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        String errorMessage = "";
        Process upgraderProcess = null;
        try {
            String validatedDirectories = this.validatedDirectories(diskDirs);
            if (validatedDirectories != null) {
                throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            this.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                for (int i = 0; i < jvmProps.length; ++i) {
                    commandList.add(jvmProps[i]);
                }
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreUpgrader.class.getName());
            commandList.add("name=" + diskStoreName);
            if (diskDirs != null && diskDirs.length != 0) {
                StringBuilder builder = new StringBuilder();
                int arrayLength = diskDirs.length;
                for (int i = 0; i < arrayLength; ++i) {
                    if (File.separatorChar == '\\') {
                        builder.append(diskDirs[i].replace("\\", "/"));
                    } else {
                        builder.append(diskDirs[i]);
                    }
                    if (i + 1 == arrayLength) continue;
                    builder.append(',');
                }
                commandList.add("disk-dirs=" + builder.toString());
            }
            commandList.add("max-oplog-size=" + maxOplogSize);
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            upgraderProcess = procBuilder.start();
            InputStream inputStream = upgraderProcess.getInputStream();
            InputStream errorStream = upgraderProcess.getErrorStream();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
            String line = null;
            while ((line = inputReader.readLine()) != null) {
                output.append(line).append(GfshParser.LINE_SEPARATOR);
            }
            line = null;
            boolean switchToStackTrace = false;
            while ((line = errorReader.readLine()) != null) {
                if (!switchToStackTrace && DiskStoreUpgrader.STACKTRACE_START.equals(line)) {
                    switchToStackTrace = true;
                    continue;
                }
                if (switchToStackTrace) {
                    error.append(line).append(GfshParser.LINE_SEPARATOR);
                    continue;
                }
                errorMessage = errorMessage + line;
            }
            if (!errorMessage.isEmpty()) {
                throw new GemFireIOException(errorMessage);
            }
            upgraderProcess.destroy();
            result = ResultBuilder.createInfoResult(output.toString());
        }
        catch (IOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            String fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = fieldsMessage + CliUtil.arrayToString(diskDirs);
            String errorString = CliStrings.format("Error occured while upgrading disk store={0} {1}. Reason: {2}", diskStoreName, fieldsMessage);
            result = ResultBuilder.createUserErrorResult(errorString);
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(e.getMessage(), e);
            }
        }
        catch (GemFireIOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(errorMessage);
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(error.toString());
            }
        }
        catch (IllegalArgumentException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        finally {
            if (upgraderProcess != null) {
                try {
                    upgraderProcess.exitValue();
                }
                catch (IllegalThreadStateException itse) {
                    upgraderProcess.destroy();
                }
            }
        }
        return result;
    }

    private String validatedDirectories(String[] diskDirs) {
        String invalidDirectories = null;
        StringBuilder builder = null;
        File diskDir = null;
        for (String diskDirPath : diskDirs) {
            diskDir = new File(diskDirPath);
            if (diskDir.exists()) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(diskDirPath);
        }
        if (builder != null) {
            invalidDirectories = builder.toString();
        }
        return invalidDirectories;
    }

    @CliCommand(value={"describe disk-store"}, help="Display information about a member's disk store.")
    @CliMetaData(shellOnly=false, relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeDiskStore(@CliOption(key={"member"}, mandatory=true, optionContext="converter.hint.member.idOrName", help="Name/Id of the member with the disk store to be described.") String memberName, @CliOption(key={"name"}, mandatory=true, optionContext="converter.hint.cluster.diskstore", help="Name of the disk store to be described.") String diskStoreName) {
        try {
            return this.toCompositeResult(this.getDiskStoreDescription(memberName, diskStoreName));
        }
        catch (DiskStoreNotFoundException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (MemberNotFoundException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"describe disk-store"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while collecting Disk Store information for member (%1$s) with disk store (%2$s) in the Geode cluster: %3$s", memberName, diskStoreName, DiskStoreCommands.toString(t, this.isDebugging())));
        }
    }

    protected DiskStoreDetails getDiskStoreDescription(String memberName, String diskStoreName) {
        Throwable cause;
        DistributedMember member = this.getMember(this.getCache(), memberName);
        ResultCollector<?, ?> resultCollector = this.getMembersFunctionExecutor(Collections.singleton(member)).withArgs(diskStoreName).execute(new DescribeDiskStoreFunction());
        Object result = ((List)resultCollector.getResult()).get(0);
        if (result instanceof DiskStoreDetails) {
            return (DiskStoreDetails)result;
        }
        if (result instanceof DiskStoreNotFoundException) {
            throw (DiskStoreNotFoundException)result;
        }
        Throwable throwable = cause = result instanceof Throwable ? (Throwable)result : null;
        if (this.isLogging()) {
            if (cause != null) {
                this.getGfsh().logSevere(String.format("Exception (%1$s) occurred while executing '%2$s' on member (%3$s) with disk store (%4$s).", ClassUtils.getClassName(cause), "describe disk-store", memberName, diskStoreName), cause);
            } else {
                this.getGfsh().logSevere(String.format("Received an unexpected result of type (%1$s) while executing '%2$s' on member (%3$s) with disk store (%4$s).", ClassUtils.getClassName(result), "describe disk-store", memberName, diskStoreName), null);
            }
        }
        throw new RuntimeException(CliStrings.format("Received an unexpected return type ({0}) while executing command {1}.", ClassUtils.getClassName(result), "describe disk-store"), cause);
    }

    protected Result toCompositeResult(DiskStoreDetails diskStoreDetails) {
        CompositeResultData diskStoreData = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData diskStoreSection = diskStoreData.addSection();
        diskStoreSection.addData("Disk Store ID", diskStoreDetails.getId());
        diskStoreSection.addData("Disk Store Name", diskStoreDetails.getName());
        diskStoreSection.addData("Member ID", diskStoreDetails.getMemberId());
        diskStoreSection.addData("Member Name", diskStoreDetails.getMemberName());
        diskStoreSection.addData("Allow Force Compaction", DiskStoreCommands.toString(diskStoreDetails.isAllowForceCompaction(), "Yes", "No"));
        diskStoreSection.addData("Auto Compaction", DiskStoreCommands.toString(diskStoreDetails.isAutoCompact(), "Yes", "No"));
        diskStoreSection.addData("Compaction Threshold", diskStoreDetails.getCompactionThreshold());
        diskStoreSection.addData("Max Oplog Size", diskStoreDetails.getMaxOplogSize());
        diskStoreSection.addData("Queue Size", diskStoreDetails.getQueueSize());
        diskStoreSection.addData("Time Interval", diskStoreDetails.getTimeInterval());
        diskStoreSection.addData("Write Buffer Size", diskStoreDetails.getWriteBufferSize());
        diskStoreSection.addData("Disk Usage Warning Percentage", diskStoreDetails.getDiskUsageWarningPercentage());
        diskStoreSection.addData("Disk Usage Critical Percentage", diskStoreDetails.getDiskUsageCriticalPercentage());
        diskStoreSection.addData("PDX Serialization Meta-Data Stored", DiskStoreCommands.toString(diskStoreDetails.isPdxSerializationMetaDataStored(), "Yes", "No"));
        TabularResultData diskDirTable = diskStoreData.addSection().addTable();
        for (Object diskDirDetails : diskStoreDetails) {
            diskDirTable.accumulate("Disk Directory", ((DiskStoreDetails.DiskDirDetails)diskDirDetails).getAbsolutePath());
            diskDirTable.accumulate("Size", ((DiskStoreDetails.DiskDirDetails)diskDirDetails).getSize());
        }
        TabularResultData regionTable = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.RegionDetails regionDetails : diskStoreDetails.iterateRegions()) {
            regionTable.accumulate("Region Path", regionDetails.getFullPath());
            regionTable.accumulate("Region Name", regionDetails.getName());
            regionTable.accumulate("Persistent", DiskStoreCommands.toString(regionDetails.isPersistent(), "Yes", "No"));
            regionTable.accumulate("Overflow To Disk", DiskStoreCommands.toString(regionDetails.isOverflowToDisk(), "Yes", "No"));
        }
        TabularResultData cacheServerTable = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.CacheServerDetails cacheServerDetails : diskStoreDetails.iterateCacheServers()) {
            cacheServerTable.accumulate("Bind Address", cacheServerDetails.getBindAddress());
            cacheServerTable.accumulate("Hostname for Clients", cacheServerDetails.getHostName());
            cacheServerTable.accumulate("Port", cacheServerDetails.getPort());
        }
        TabularResultData tabularResultData = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.GatewayDetails gatewayDetails : diskStoreDetails.iterateGateways()) {
            tabularResultData.accumulate("Gateway ID", gatewayDetails.getId());
            tabularResultData.accumulate("Persistent", DiskStoreCommands.toString(gatewayDetails.isPersistent(), "Yes", "No"));
        }
        TabularResultData tabularResultData2 = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.AsyncEventQueueDetails asyncEventQueueDetails : diskStoreDetails.iterateAsyncEventQueues()) {
            tabularResultData2.accumulate("Async Event Queue ID", asyncEventQueueDetails.getId());
        }
        return ResultBuilder.buildResult(diskStoreData);
    }

    @CliCommand(value={"revoke missing-disk-store"}, help="Instructs the member(s) of a distributed system to stop waiting for a disk store to be available. Only revoke a disk store if its files are lost as it will no longer be recoverable once revoking is initiated. Use the \"show missing-disk-store\" command to get descriptions of missing disk stores.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result revokeMissingDiskStore(@CliOption(key={"id"}, mandatory=true, help="ID of the missing disk store to be revoked.") String id) {
        try {
            DistributedSystemMXBean dsMXBean = ManagementService.getManagementService(CacheFactory.getAnyInstance()).getDistributedSystemMXBean();
            if (dsMXBean.revokeMissingDiskStores(id)) {
                return ResultBuilder.createInfoResult("Missing disk store successfully revoked");
            }
            return ResultBuilder.createUserErrorResult("Unable to find missing disk store to revoke");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (th.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult("An error occurred while revoking missing disk stores: " + th);
            }
            return ResultBuilder.createGemFireErrorResult("An error occurred while revoking missing disk stores: " + th.getMessage());
        }
    }

    @CliCommand(value={"show missing-disk-stores"}, help="Display a summary of the disk stores that are currently missing from a distributed system.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showMissingDiskStore() {
        try {
            Set<DistributedMember> dataMembers = this.getNormalMembers(this.getCache());
            if (dataMembers.isEmpty()) {
                return ResultBuilder.createInfoResult("No caching members found.");
            }
            List<Object> results = this.getMissingDiskStoresList(dataMembers);
            return this.toMissingDiskStoresTabularResult(results);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"show missing-disk-stores"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (t.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while showing missing disk stores and missing colocated regions: %1$s", t));
            }
            return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while showing missing disk stores and missing colocated regions: %1$s", t.getMessage()));
        }
    }

    protected List<Object> getMissingDiskStoresList(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector<?, ?> resultCollector = membersFunctionExecutor.execute(new ShowMissingDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList<Object> distributedPersistentRecoveryDetails = new ArrayList<Object>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedPersistentRecoveryDetails.addAll((Set)result);
        }
        return distributedPersistentRecoveryDetails;
    }

    protected Result toMissingDiskStoresTabularResult(List<Object> resultDetails) throws ResultDataException {
        boolean hasMissingColocatedRegions;
        CompositeResultData crd = ResultBuilder.createCompositeResultData();
        ArrayList<PersistentMemberPattern> missingDiskStores = new ArrayList<PersistentMemberPattern>();
        ArrayList<ColocatedRegionDetails> missingColocatedRegions = new ArrayList<ColocatedRegionDetails>();
        for (Object detail : resultDetails) {
            if (detail instanceof PersistentMemberPattern) {
                missingDiskStores.add((PersistentMemberPattern)detail);
                continue;
            }
            if (detail instanceof ColocatedRegionDetails) {
                missingColocatedRegions.add((ColocatedRegionDetails)detail);
                continue;
            }
            throw new ResultDataException("Unknown type of PersistentRecoveryFailures result");
        }
        boolean hasMissingDiskStores = !missingDiskStores.isEmpty();
        boolean bl = hasMissingColocatedRegions = !missingColocatedRegions.isEmpty();
        if (hasMissingDiskStores) {
            CompositeResultData.SectionResultData missingDiskStoresSection = crd.addSection();
            missingDiskStoresSection.setHeader("Missing Disk Stores");
            TabularResultData missingDiskStoreData = missingDiskStoresSection.addTable();
            for (PersistentMemberPattern peristentMemberDetails : missingDiskStores) {
                missingDiskStoreData.accumulate("Disk Store ID", peristentMemberDetails.getUUID());
                missingDiskStoreData.accumulate("Host", peristentMemberDetails.getHost());
                missingDiskStoreData.accumulate("Directory", peristentMemberDetails.getDirectory());
            }
        } else {
            CompositeResultData.SectionResultData noMissingDiskStores = crd.addSection();
            noMissingDiskStores.setHeader("No missing disk store found");
        }
        if (hasMissingDiskStores || hasMissingColocatedRegions) {
            crd.addSection().setHeader("\n");
        }
        if (hasMissingColocatedRegions) {
            CompositeResultData.SectionResultData missingRegionsSection = crd.addSection();
            missingRegionsSection.setHeader("Missing Colocated Regions");
            TabularResultData missingRegionData = missingRegionsSection.addTable();
            for (ColocatedRegionDetails colocatedRegionDetails : missingColocatedRegions) {
                missingRegionData.accumulate("Host", colocatedRegionDetails.getHost());
                missingRegionData.accumulate("Distributed Member", colocatedRegionDetails.getMember());
                missingRegionData.accumulate("Parent Region", colocatedRegionDetails.getParent());
                missingRegionData.accumulate("Missing Colocated Region", colocatedRegionDetails.getChild());
            }
        } else {
            CompositeResultData.SectionResultData noMissingColocatedRegions = crd.addSection();
            noMissingColocatedRegions.setHeader("No missing colocated region found");
        }
        return ResultBuilder.buildResult(crd);
    }

    @CliCommand(value={"describe offline-disk-store"}, help="Display information about an offline disk store.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result describeOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be described.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files.") @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"pdx"}, unspecifiedDefaultValue="__NULL__", help="Display all the pdx types stored in the disk store") Boolean listPdxTypes, @CliOption(key={"region"}, help="Name/Path of the region in the disk store to be described.", unspecifiedDefaultValue="__NULL__") String regionName) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            if ("/".equals(regionName)) {
                return ResultBuilder.createUserErrorResult("Invalid region name");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            DiskStoreImpl.dumpInfo(printStream, diskStoreName, dirs, regionName, listPdxTypes);
            return ResultBuilder.createInfoResult(outputStream.toString());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (th.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult("An error occurred while describing offline disk stores: " + th);
            }
            return ResultBuilder.createGemFireErrorResult("An error occurred while describing offline disk stores: " + th.getMessage());
        }
    }

    @CliCommand(value={"export offline-disk-store"}, help="Export region data from an offline disk store into Geode snapshot files.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result exportOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be exported.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files.") @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"dir"}, mandatory=true, help="Directory to export snapshot files to.") String dir) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            File output = new File(dir);
            DiskStoreImpl.exportOfflineSnapshot(diskStoreName, dirs, output);
            String resultString = CliStrings.format("Exported all regions from disk store {0} to the directory {1}", diskStoreName, dir);
            return ResultBuilder.createInfoResult(resultString.toString());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            LogWrapper.getInstance().warning(th.getMessage(), th);
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Error exporting disk store {0} is : {1}", diskStoreName, th.toString()));
        }
    }

    private void configureLogging(List<String> commandList) {
        URL configUrl = LogService.class.getResource("/log4j2-cli.xml");
        String configFilePropertyValue = configUrl.toString();
        commandList.add("-Dlog4j.configurationFile=" + configFilePropertyValue);
    }

    @CliCommand(value={"validate offline-disk-store"}, help="Scan the contents of a disk store to verify that it has no errors.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result validateDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be validated.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="Directories where data for the disk store was previously written.") @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"J"}, unspecifiedDefaultValue="__NULL__", help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") @CliMetaData(valueSeparator=",") String[] jvmProps) {
        try {
            String opts;
            String resultString = new String();
            StringBuilder dirList = new StringBuilder();
            for (int i = 0; i < diskDirs.length; ++i) {
                dirList.append(diskDirs[i]);
                dirList.append(";");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            this.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                for (int i = 0; i < jvmProps.length; ++i) {
                    commandList.add(jvmProps[i]);
                }
            }
            if ((opts = System.getenv("JAVA_OPTS")) != null) {
                commandList.add(opts);
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreValidater.class.getName());
            commandList.add(diskStoreName);
            commandList.add(dirList.toString());
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            StringBuilder output = new StringBuilder();
            String errorString = new String();
            Process validateDiskStoreProcess = procBuilder.redirectErrorStream(true).start();
            InputStream inputStream = validateDiskStoreProcess.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = br.readLine()) != null) {
                output.append(line).append(GfshParser.LINE_SEPARATOR);
            }
            validateDiskStoreProcess.destroy();
            if (errorString != null) {
                output.append(errorString).append(GfshParser.LINE_SEPARATOR);
            }
            resultString = "Validating " + diskStoreName + GfshParser.LINE_SEPARATOR + output.toString();
            return ResultBuilder.createInfoResult(resultString.toString());
        }
        catch (IOException ex) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Input/Output error in validating disk store {0} is : {1}", diskStoreName, ex.getMessage()));
        }
        catch (Exception ex) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Error in validating disk store {0} is : {1}", diskStoreName, ex.getMessage()));
        }
    }

    @CliCommand(value={"alter disk-store"}, help="Alter some options for a region or remove a region in an offline disk store.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result alterOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store whose contents will be altered.") String diskStoreName, @CliOption(key={"region"}, mandatory=true, help="Name/Path of the region in the disk store to alter.") String regionName, @CliOption(key={"disk-dirs"}, unspecifiedDefaultValue="__NULL__", help="Directories where data for the disk store was previously written.", mandatory=true) @CliMetaData(valueSeparator=",") String[] diskDirs, @CliOption(key={"compressor"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="none", help="The fully-qualifed class name of the Compressor to use when compressing region entry values. A value of 'none' will remove the Compressor.") String compressorClassName, @CliOption(key={"concurrency-level"}, unspecifiedDefaultValue="__NULL__", help="An estimate of the maximum number of application threads that will concurrently modify a region at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @CliOption(key={"enable-statistics"}, unspecifiedDefaultValue="__NULL__", help="Whether to enable statistics. Valid values are: true and false.") Boolean statisticsEnabled, @CliOption(key={"initial-capacity"}, unspecifiedDefaultValue="__NULL__", help="Together with --load-factor, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries.") Integer initialCapacity, @CliOption(key={"load-factor"}, unspecifiedDefaultValue="__NULL__", help="Together with --initial-capacity, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries. This must be a floating point number between 0 and 1, inclusive.") Float loadFactor, @CliOption(key={"lru-action"}, help="Action to take when evicting entries from the region. Valid values are: none, overflow-to-disk and local-destroy.") String lruEvictionAction, @CliOption(key={"lru-algorithm"}, help="Least recently used eviction algorithm.  Valid values are: none, lru-entry-count, lru-heap-percentage and lru-memory-size.") String lruEvictionAlgo, @CliOption(key={"lru-limit"}, unspecifiedDefaultValue="__NULL__", help="Number of entries allowed in the region before eviction will occur.") Integer lruEvictionLimit, @CliOption(key={"off-heap"}, unspecifiedDefaultValue="__NULL__", help="Whether to use off-heap memory for the region. Valid values are: true and false.") Boolean offHeap, @CliOption(key={"remove"}, help="Whether to remove the region from the disk store.", mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean remove) {
        Result result = null;
        try {
            File[] dirs = null;
            if (diskDirs != null) {
                dirs = new File[diskDirs.length];
                for (int i = 0; i < diskDirs.length; ++i) {
                    dirs[i] = new File(diskDirs[i]);
                }
            }
            if (regionName.equals("/")) {
                return ResultBuilder.createUserErrorResult("Invalid region name");
            }
            if (lruEvictionAlgo != null || lruEvictionAction != null || lruEvictionLimit != null || concurrencyLevel != null || initialCapacity != null || loadFactor != null || compressorClassName != null || offHeap != null || statisticsEnabled != null) {
                if (!remove) {
                    String offHeapString;
                    String lruEvictionLimitString = lruEvictionLimit == null ? null : lruEvictionLimit.toString();
                    String concurrencyLevelString = concurrencyLevel == null ? null : concurrencyLevel.toString();
                    String initialCapacityString = initialCapacity == null ? null : initialCapacity.toString();
                    String loadFactorString = loadFactor == null ? null : loadFactor.toString();
                    String statisticsEnabledString = statisticsEnabled == null ? null : statisticsEnabled.toString();
                    String string = offHeapString = offHeap == null ? null : offHeap.toString();
                    if ("none".equals(compressorClassName)) {
                        compressorClassName = "";
                    }
                    String resultMessage = DiskStoreImpl.modifyRegion(diskStoreName, dirs, "/" + regionName, lruEvictionAlgo, lruEvictionAction, lruEvictionLimitString, concurrencyLevelString, initialCapacityString, loadFactorString, compressorClassName, statisticsEnabledString, offHeapString, false);
                    result = ResultBuilder.createInfoResult(resultMessage);
                } else {
                    result = ResultBuilder.createParsingErrorResult("Cannot use the --remove=true parameter with any other parameters");
                }
            } else if (remove) {
                DiskStoreImpl.destroyRegion(diskStoreName, dirs, "/" + regionName);
                result = ResultBuilder.createInfoResult("The region " + regionName + " was successfully removed from the disk store " + diskStoreName);
            } else {
                result = ResultBuilder.createParsingErrorResult("Please provide a relevant parameter");
            }
        }
        catch (IllegalArgumentException e) {
            String message = "Please check the parameters";
            message = message + "\n" + e.getMessage();
            result = ResultBuilder.createGemFireErrorResult(message);
        }
        catch (IllegalStateException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (CacheExistsException e) {
            result = ResultBuilder.createGemFireErrorResult("Cannot execute alter disk-store when a cache exists (Offline command)");
        }
        catch (Exception e) {
            result = this.createErrorResult(e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"destroy disk-store"}, help="Destroy a disk store, including deleting all files on disk used by the disk store. Data for closed regions previously using the disk store will be lost.")
    @CliMetaData(shellOnly=false, relatedTopic={"Disk Store"}, writesToSharedConfiguration=true)
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store that will be destroyed.") String name, @CliOption(key={"group"}, help="Group(s) of members on which the disk store will be destroyed. If no group is specified the disk store will be destroyed on all members.", optionContext="converter.hint.member.groups") @CliMetaData(valueSeparator=",") String[] groups) {
        try {
            Set<DistributedMember> targetMembers;
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(groups, null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new DestroyDiskStoreFunction(), (Object)new Object[]{name}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            XmlEntity xmlEntity = null;
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (result.getMessage() == null) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity != null) continue;
                xmlEntity = result.getXmlEntity();
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No matching disk stores found.");
            }
            Result result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity != null) {
                result.setCommandPersisted(new SharedConfigurationWriter().deleteXmlEntity(xmlEntity, groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while destroying the disk store: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }

    private Result createErrorResult(String message) {
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        erd.addLine(message);
        return ResultBuilder.buildResult(erd);
    }

    @CliAvailabilityIndicator(value={"backup disk-store", "compact disk-store", "describe disk-store", "list disk-stores", "revoke missing-disk-store", "show missing-disk-stores", "create disk-store", "destroy disk-store"})
    public boolean diskStoreCommandsAvailable() {
        return !CliUtil.isGfshVM() || this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    @CliAvailabilityIndicator(value={"describe offline-disk-store"})
    public boolean offlineDiskStoreCommandsAvailable() {
        return true;
    }
}

