/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.domain.MemberConfigurationInfo;
import org.apache.geode.management.internal.cli.functions.AlterRuntimeConfigFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ExportConfigFunction;
import org.apache.geode.management.internal.cli.functions.GetMemberConfigInformationFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.SharedConfigurationWriter;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ConfigCommands
implements CommandMarker {
    private final ExportConfigFunction exportConfigFunction = new ExportConfigFunction();
    private final GetMemberConfigInformationFunction getMemberConfigFunction = new GetMemberConfigInformationFunction();
    private final AlterRuntimeConfigFunction alterRunTimeConfigFunction = new AlterRuntimeConfigFunction();

    private static Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"describe config"}, help="Display configuration details of a member or members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeConfig(@CliOption(key={"member"}, optionContext="converter.hint.all.member.idOrName", help="Name/Id of the member whose configuration will be described.", mandatory=true) String memberNameOrId, @CliOption(key={"hide-defaults"}, help="Whether to hide configuration information for properties with the default value.", unspecifiedDefaultValue="true", specifiedDefaultValue="true") boolean hideDefaults) {
        Result result = null;
        try {
            DistributedMember targetMember = null;
            if (memberNameOrId != null && !memberNameOrId.isEmpty()) {
                targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            }
            if (targetMember != null) {
                ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.getMemberConfigFunction, (Object)new Boolean(hideDefaults), targetMember);
                ArrayList output = (ArrayList)rc.getResult();
                Object obj = output.get(0);
                if (obj != null && obj instanceof MemberConfigurationInfo) {
                    MemberConfigurationInfo memberConfigInfo = (MemberConfigurationInfo)obj;
                    CompositeResultData crd = ResultBuilder.createCompositeResultData();
                    crd.setHeader(CliStrings.format("Configuration of member : \"{0}\"", (Object)memberNameOrId));
                    List<String> jvmArgsList = memberConfigInfo.getJvmInputArguments();
                    TabularResultData jvmInputArgs = crd.addSection().addSection().addTable();
                    for (String jvmArg : jvmArgsList) {
                        jvmInputArgs.accumulate("JVM command line arguments", jvmArg);
                    }
                    this.addSection(crd, memberConfigInfo.getGfePropsSetUsingApi(), "GemFire properties defined using the API");
                    this.addSection(crd, memberConfigInfo.getGfePropsRuntime(), "GemFire properties defined at the runtime");
                    this.addSection(crd, memberConfigInfo.getGfePropsSetFromFile(), "GemFire properties defined with the property file");
                    this.addSection(crd, memberConfigInfo.getGfePropsSetWithDefaults(), "GemFire properties using default values");
                    this.addSection(crd, memberConfigInfo.getCacheAttributes(), "Cache attributes");
                    List<Map<String, String>> cacheServerAttributesList = memberConfigInfo.getCacheServerAttributes();
                    if (cacheServerAttributesList != null && !cacheServerAttributesList.isEmpty()) {
                        CompositeResultData.SectionResultData cacheServerSection = crd.addSection();
                        cacheServerSection.setHeader("Cache-server attributes");
                        for (Map<String, String> cacheServerAttributes : cacheServerAttributesList) {
                            this.addSubSection(cacheServerSection, cacheServerAttributes, "");
                        }
                    }
                    result = ResultBuilder.buildResult(crd);
                }
            } else {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                erd.addLine(CliStrings.format("Member \"{0}\" not found", new Object[]{memberNameOrId}));
                result = ResultBuilder.buildResult(erd);
            }
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"describe config"));
        }
        catch (Exception e) {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            erd.addLine(e.getMessage());
            result = ResultBuilder.buildResult(erd);
        }
        return result;
    }

    private void addSection(CompositeResultData crd, Map<String, String> attrMap, String headerText) {
        if (attrMap != null && !attrMap.isEmpty()) {
            CompositeResultData.SectionResultData section = crd.addSection();
            section.setHeader(headerText);
            section.addSeparator('.');
            TreeSet<String> attributes = new TreeSet<String>(attrMap.keySet());
            for (String attribute : attributes) {
                String attributeValue = attrMap.get(attribute);
                section.addData(attribute, attributeValue);
            }
        }
    }

    private void addSubSection(CompositeResultData.SectionResultData section, Map<String, String> attrMap, String headerText) {
        if (!attrMap.isEmpty()) {
            CompositeResultData.SectionResultData subSection = section.addSection();
            TreeSet<String> attributes = new TreeSet<String>(attrMap.keySet());
            subSection.setHeader(headerText);
            for (String attribute : attributes) {
                String attributeValue = attrMap.get(attribute);
                subSection.addData(attribute, attributeValue);
            }
        }
    }

    @CliCommand(value={"export config"}, help="Export configuration properties for a member or members.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ConfigCommands$Interceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportConfig(@CliOption(key={"member"}, optionContext="converter.hint.all.member.idOrName", help="Name/Id of the member(s) whose configuration will be exported.") @CliMetaData(valueSeparator=",") String member, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members whose configuration will be exported.") @CliMetaData(valueSeparator=",") String group, @CliOption(key={"dir"}, help="Directory to which the exported configuration files will be written.") String dir) {
        Set<DistributedMember> targetMembers;
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        try {
            targetMembers = CliUtil.findAllMatchingMembers(group, member);
        }
        catch (CommandResultException crex) {
            return crex.getResult();
        }
        try {
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.exportConfigFunction, null, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    infoData.addLine(CliStrings.format("Exception while exporting config: {0}", result.getMemberIdOrName(), result.getThrowable()));
                    continue;
                }
                if (!result.isSuccessful()) continue;
                String cacheFileName = result.getMemberIdOrName() + "-cache.xml";
                String propsFileName = result.getMemberIdOrName() + "-gf.properties";
                String[] fileContent = (String[])result.getSerializables();
                infoData.addAsFile(cacheFileName, fileContent[0], "Downloading Cache XML file: {0}", false);
                infoData.addAsFile(propsFileName, fileContent[1], "Downloading properties file: {0}", false);
            }
            return ResultBuilder.buildResult(infoData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            th.printStackTrace(System.err);
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Exception while exporting config: {0}", (Object)(th.getClass().getName() + ": " + th.getMessage())));
        }
    }

    @CliCommand(value={"alter runtime"}, help="Alter a subset of member or members configuration properties while running.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result alterRuntimeConfig(@CliOption(key={"member"}, optionContext="converter.hint.all.member.idOrName", help="Name/Id of the member in whose configuration will be altered.") String memberNameOrId, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Name/Id of the member in whose configuration will be altered.") String group, @CliOption(key={"archive-disk-space-limit"}, unspecifiedDefaultValue="__NULL__", help="Archive disk space limit. Valid values are (in megabytes): 0 - 1000000.") Integer archiveDiskSpaceLimit, @CliOption(key={"archive-file-size-limit"}, unspecifiedDefaultValue="__NULL__", help="Archive file size limit. Valid values are (in megabytes): 0 - 1000000.") Integer archiveFileSizeLimit, @CliOption(key={"log-disk-space-limit"}, unspecifiedDefaultValue="__NULL__", help="Log disk space limit. Valid values are (in megabytes): 0 - 1000000.") Integer logDiskSpaceLimit, @CliOption(key={"log-file-size-limit"}, unspecifiedDefaultValue="__NULL__", help="Log file size limit. Valid values are (in megabytes): 0 - 1000000.") Integer logFileSizeLimit, @CliOption(key={"log-level"}, optionContext="converter.hint.log.levels", help="Log level. Valid values are: none, error, info, config , warning, severe, fine, finer and finest.") String logLevel, @CliOption(key={"statistic-archive-file"}, help="File to which the statistics will be written.") String statisticArchiveFile, @CliOption(key={"statistic-sample-rate"}, unspecifiedDefaultValue="__NULL__", help="Statistic sampling rate. Valid values are (in milliseconds): 100 - 60000.") Integer statisticSampleRate, @CliOption(key={"enable-statistics"}, unspecifiedDefaultValue="__NULL__", help="Whether statistic sampling should be enabled. Valid values are: true and false.") Boolean statisticSamplingEnabled, @CliOption(key={"copy-on-read"}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="false", help="Sets the \"copy on read\" feature for cache read operations") Boolean setCopyOnRead, @CliOption(key={"lock-lease"}, unspecifiedDefaultValue="__NULL__", help="Sets the length, in seconds, of distributed lock leases obtained by this cache.") Integer lockLease, @CliOption(key={"lock-timeout"}, unspecifiedDefaultValue="__NULL__", help="Sets the number of seconds a cache operation may wait to obtain a distributed lock lease before timing out.") Integer lockTimeout, @CliOption(key={"message-sync-interval"}, unspecifiedDefaultValue="__NULL__", help="Sets the frequency (in seconds) at which a message will be sent by the primary cache-server node to all the secondary cache-server nodes to remove the events which have already been dispatched from the queue") Integer messageSyncInterval, @CliOption(key={"search-timeout"}, unspecifiedDefaultValue="__NULL__", help="Sets the number of seconds a cache get operation can spend searching for a value.") Integer searchTimeout) {
        HashMap<String, String> runTimeDistributionConfigAttributes = new HashMap<String, String>();
        HashMap<String, String> rumTimeCacheAttributes = new HashMap<String, String>();
        HashSet<DistributedMember> targetMembers = new HashSet();
        try {
            targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            if (archiveDiskSpaceLimit != null) {
                runTimeDistributionConfigAttributes.put("archive-disk-space-limit", archiveDiskSpaceLimit.toString());
            }
            if (archiveFileSizeLimit != null) {
                runTimeDistributionConfigAttributes.put("archive-file-size-limit", archiveFileSizeLimit.toString());
            }
            if (logDiskSpaceLimit != null) {
                runTimeDistributionConfigAttributes.put("log-disk-space-limit", logDiskSpaceLimit.toString());
            }
            if (logFileSizeLimit != null) {
                runTimeDistributionConfigAttributes.put("log-file-size-limit", logFileSizeLimit.toString());
            }
            if (logLevel != null && !logLevel.isEmpty()) {
                runTimeDistributionConfigAttributes.put("log-level", logLevel);
            }
            if (statisticArchiveFile != null && !statisticArchiveFile.isEmpty()) {
                runTimeDistributionConfigAttributes.put("statistic-archive-file", statisticArchiveFile);
            }
            if (statisticSampleRate != null) {
                runTimeDistributionConfigAttributes.put("statistic-sample-rate", statisticSampleRate.toString());
            }
            if (statisticSamplingEnabled != null) {
                runTimeDistributionConfigAttributes.put("statistic-sampling-enabled", statisticSamplingEnabled.toString());
            }
            if (setCopyOnRead != null) {
                rumTimeCacheAttributes.put("copy-on-read", setCopyOnRead.toString());
            }
            if (lockLease != null && lockLease > 0 && lockLease < Integer.MAX_VALUE) {
                rumTimeCacheAttributes.put("lock-lease", lockLease.toString());
            }
            if (lockTimeout != null && lockTimeout > 0 && lockTimeout < Integer.MAX_VALUE) {
                rumTimeCacheAttributes.put("lock-timeout", lockTimeout.toString());
            }
            if (messageSyncInterval != null && messageSyncInterval > 0 && messageSyncInterval < Integer.MAX_VALUE) {
                rumTimeCacheAttributes.put("message-sync-interval", messageSyncInterval.toString());
            }
            if (searchTimeout != null && searchTimeout > 0 && searchTimeout < Integer.MAX_VALUE) {
                rumTimeCacheAttributes.put("search-timeout", searchTimeout.toString());
            }
            if (!runTimeDistributionConfigAttributes.isEmpty() || !rumTimeCacheAttributes.isEmpty()) {
                HashMap<String, String> allRunTimeAttributes = new HashMap<String, String>();
                allRunTimeAttributes.putAll(runTimeDistributionConfigAttributes);
                allRunTimeAttributes.putAll(rumTimeCacheAttributes);
                ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.alterRunTimeConfigFunction, allRunTimeAttributes, targetMembers);
                List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
                CompositeResultData crd = ResultBuilder.createCompositeResultData();
                TabularResultData tabularData = crd.addSection().addTable();
                TreeSet<String> successfulMembers = new TreeSet<String>();
                TreeSet<String> errorMessages = new TreeSet<String>();
                for (CliFunctionResult result : results) {
                    if (result.getThrowable() != null) {
                        errorMessages.add(result.getThrowable().getMessage());
                        continue;
                    }
                    successfulMembers.add(result.getMemberIdOrName());
                }
                String lineSeparator = System.getProperty("line.separator");
                if (!successfulMembers.isEmpty()) {
                    StringBuilder successMessageBuilder = new StringBuilder();
                    successMessageBuilder.append("Runtime configuration altered successfully for the following member(s)");
                    successMessageBuilder.append(lineSeparator);
                    for (String member : successfulMembers) {
                        successMessageBuilder.append(member);
                        successMessageBuilder.append(lineSeparator);
                    }
                    Properties properties = new Properties();
                    properties.putAll((Map<?, ?>)runTimeDistributionConfigAttributes);
                    Result result = ResultBuilder.createInfoResult(successMessageBuilder.toString());
                    XmlEntity xmlEntity = XmlEntity.builder().withType("cache").withAttributes(rumTimeCacheAttributes).build();
                    result.setCommandPersisted(new SharedConfigurationWriter().modifyPropertiesAndCacheAttributes(properties, xmlEntity, group != null ? group.split(",") : null));
                    return result;
                }
                StringBuilder errorMessageBuilder = new StringBuilder();
                errorMessageBuilder.append("Following errors occurred while altering runtime config");
                errorMessageBuilder.append(lineSeparator);
                for (String errorMessage : errorMessages) {
                    errorMessageBuilder.append(errorMessage);
                    errorMessageBuilder.append(lineSeparator);
                }
                return ResultBuilder.createUserErrorResult(errorMessageBuilder.toString());
            }
            return ResultBuilder.createUserErrorResult("Please provide a relevant parameter(s)");
        }
        catch (CommandResultException crex) {
            return crex.getResult();
        }
        catch (CacheClosedException e) {
            return ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"alter runtime"));
        }
        catch (Exception e) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Exception : {0} , Message : {1}", e.getClass(), e.getMessage()));
        }
    }

    @CliAvailabilityIndicator(value={"describe config", "export config", "alter runtime"})
    public boolean configCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = ConfigCommands.getGfsh() != null && ConfigCommands.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String dir = paramValueMap.get("dir");
            dir = dir == null ? null : dir.trim();
            File saveDirFile = new File(".");
            if (dir != null && !dir.isEmpty()) {
                saveDirFile = new File(dir);
                if (saveDirFile.exists()) {
                    if (!saveDirFile.isDirectory()) {
                        return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not a directory", (Object)dir));
                    }
                } else if (!saveDirFile.mkdirs()) {
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("Directory {0} could not be created", (Object)dir));
                }
            }
            try {
                if (!saveDirFile.canWrite()) {
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not writeable", (Object)saveDirFile.getCanonicalPath()));
                }
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not writeable", (Object)saveDirFile.getName()));
            }
            this.saveDirString = saveDirFile.getAbsolutePath();
            return ResultBuilder.createInfoResult("OK");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (commandResult.hasIncomingFiles()) {
                try {
                    commandResult.saveIncomingFiles(this.saveDirString);
                }
                catch (IOException ioex) {
                    ConfigCommands.getGfsh().logSevere("Unable to export config", ioex);
                }
            }
            return commandResult;
        }
    }
}

