/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.MemberNotFoundException;
import org.springframework.shell.core.CommandMarker;

public abstract class AbstractCommandsSupport
implements CommandMarker {
    protected static SecurityService securityService = SecurityService.getSecurityService();

    protected static void assertArgument(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    protected static void assertState(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected static String convertDefaultValue(String from, String to) {
        return "__DEFAULT__".equals(from) ? to : from;
    }

    protected static String toString(Boolean condition, String trueValue, String falseValue) {
        return Boolean.TRUE.equals(condition) ? StringUtils.defaultIfBlank(trueValue, "true") : StringUtils.defaultIfBlank(falseValue, "false");
    }

    protected static String toString(Throwable t, boolean printStackTrace) {
        String message = t.getMessage();
        if (printStackTrace) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            message = writer.toString();
        }
        return message;
    }

    protected boolean isConnectedAndReady() {
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    protected boolean isDebugging() {
        return this.getGfsh() != null && this.getGfsh().getDebug();
    }

    protected boolean isLogging() {
        return this.getGfsh() != null;
    }

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    protected Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    protected DistributedMember getMember(Cache cache, String memberName) {
        for (DistributedMember member : this.getMembers(cache)) {
            if (!memberName.equalsIgnoreCase(member.getName()) && !memberName.equalsIgnoreCase(member.getId())) continue;
            return member;
        }
        throw new MemberNotFoundException(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberName));
    }

    @Deprecated
    protected Set<DistributedMember> getMembers(Cache cache) {
        HashSet<DistributedMember> members = new HashSet<DistributedMember>(cache.getMembers());
        members.add(cache.getDistributedSystem().getDistributedMember());
        return members;
    }

    protected Execution getMembersFunctionExecutor(Set<DistributedMember> members) {
        return FunctionService.onMembers(members);
    }

    protected void logInfo(String message) {
        this.logInfo(message, null);
    }

    protected void logInfo(Throwable cause) {
        this.logInfo(cause.getMessage(), cause);
    }

    protected void logInfo(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logInfo(message, cause);
        }
    }

    protected void logWarning(String message) {
        this.logWarning(message, null);
    }

    protected void logWarning(Throwable cause) {
        this.logWarning(cause.getMessage(), cause);
    }

    protected void logWarning(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logWarning(message, cause);
        }
    }

    protected void logSevere(String message) {
        this.logSevere(message, null);
    }

    protected void logSevere(Throwable cause) {
        this.logSevere(cause.getMessage(), cause);
    }

    protected void logSevere(String message, Throwable cause) {
        if (this.isLogging()) {
            this.getGfsh().logSevere(message, cause);
        }
    }

    protected <T extends Function> T register(T function) {
        if (FunctionService.isRegistered(function.getId())) {
            function = FunctionService.getFunction(function.getId());
        } else {
            FunctionService.registerFunction(function);
        }
        return function;
    }
}

