/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.internal.cli.CliUtil;
import org.springframework.shell.event.ParseResult;

public class GfshParseResult
extends ParseResult {
    private String userInput;
    private String commandName;
    private Map<String, String> paramValueStringMap;

    protected GfshParseResult(Method method, Object instance, Object[] arguments, String userInput, String commandName, Map<String, String> parametersAsString) {
        super(method, instance, arguments);
        this.userInput = userInput;
        this.commandName = commandName;
        this.paramValueStringMap = new HashMap<String, String>(parametersAsString);
    }

    public String getUserInput() {
        return this.userInput;
    }

    public Map<String, String> getParamValueStrings() {
        return Collections.unmodifiableMap(this.paramValueStringMap);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(GfshParseResult.class.getSimpleName());
        builder.append(" [method=").append(this.getMethod());
        builder.append(", instance=").append(this.getInstance());
        builder.append(", arguments=").append(CliUtil.arrayToString(this.getArguments()));
        builder.append("]");
        return builder.toString();
    }

    public String getCommandName() {
        return this.commandName;
    }
}

