/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class MemberLevelDiskMonitor
extends MBeanStatsMonitor {
    private volatile long diskReadBytes = 0L;
    private volatile long diskWrittenBytes = 0L;
    private volatile int backupsInProgress = 0;
    private volatile int backupsCompleted = 0;
    private volatile long flushedBytes = 0L;
    private volatile long flushes = 0L;
    private volatile long flushTime = 0L;
    private volatile int queueSize = 0;
    private Map<Statistics, ValueMonitor> monitors = new HashMap<Statistics, ValueMonitor>();
    private Map<Statistics, MemberLevelDiskStatisticsListener> listeners = new HashMap<Statistics, MemberLevelDiskStatisticsListener>();

    public MemberLevelDiskMonitor(String name) {
        super(name);
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        ValueMonitor diskMonitor = new ValueMonitor();
        MemberLevelDiskStatisticsListener listener = new MemberLevelDiskStatisticsListener();
        diskMonitor.addListener(listener);
        diskMonitor.addStatistics(stats);
        this.monitors.put(stats, diskMonitor);
        this.listeners.put(stats, listener);
    }

    @Override
    public void removeStatisticsFromMonitor(Statistics stats) {
        MemberLevelDiskStatisticsListener listener;
        ValueMonitor monitor = this.monitors.remove(stats);
        if (monitor != null) {
            monitor.removeStatistics(stats);
        }
        if ((listener = this.listeners.remove(stats)) != null) {
            monitor.removeListener(listener);
        }
        listener.decreaseDiskStoreStats(stats);
    }

    @Override
    public void stopListener() {
        for (Statistics stat : this.listeners.keySet()) {
            ValueMonitor monitor = this.monitors.get(stat);
            monitor.removeListener(this.listeners.get(stat));
            monitor.removeStatistics(stat);
        }
        this.listeners.clear();
        this.monitors.clear();
    }

    @Override
    public Number getStatistic(String name) {
        if (name.equals("readBytes")) {
            return this.getDiskReads();
        }
        if (name.equals("writtenBytes")) {
            return this.getDiskWrites();
        }
        if (name.equals("backupsInProgress")) {
            return this.getBackupsInProgress();
        }
        if (name.equals("backupsCompleted")) {
            return this.getBackupsCompleted();
        }
        if (name.equals("flushedBytes")) {
            return this.getFlushedBytes();
        }
        if (name.equals("flushes")) {
            return this.getFlushes();
        }
        if (name.equals("flushTime")) {
            return this.getFlushTime();
        }
        if (name.equals("queueSize")) {
            return this.getQueueSize();
        }
        return 0;
    }

    private Number computeDelta(MBeanStatsMonitor.DefaultHashMap statsMap, String name, Number currentValue) {
        if (name.equals("readBytes")) {
            Long prevValue = statsMap.get("readBytes").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("recoveredBytes")) {
            Long prevValue = statsMap.get("recoveredBytes").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("writtenBytes")) {
            Long prevValue = statsMap.get("writtenBytes").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("backupsInProgress")) {
            Long prevValue = statsMap.get("backupsInProgress").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("backupsCompleted")) {
            Long prevValue = statsMap.get("backupsCompleted").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("flushedBytes")) {
            Long prevValue = statsMap.get("flushedBytes").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("flushes")) {
            Long prevValue = statsMap.get("flushes").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("flushTime")) {
            Long prevValue = statsMap.get("flushTime").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("queueSize")) {
            Long prevValue = statsMap.get("queueSize").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        return 0;
    }

    private void increaseStats(String name, Number value) {
        if (name.equals("readBytes") || name.equals("recoveredBytes")) {
            this.diskReadBytes += value.longValue();
            return;
        }
        if (name.equals("writtenBytes")) {
            this.diskWrittenBytes += value.longValue();
            return;
        }
        if (name.equals("backupsInProgress")) {
            this.backupsInProgress += value.intValue();
            return;
        }
        if (name.equals("backupsCompleted")) {
            this.backupsCompleted += value.intValue();
            return;
        }
        if (name.equals("flushedBytes")) {
            this.flushedBytes += value.longValue();
            return;
        }
        if (name.equals("flushes")) {
            this.flushes += value.longValue();
            return;
        }
        if (name.equals("flushTime")) {
            this.flushTime += value.longValue();
            return;
        }
        if (name.equals("queueSize")) {
            this.queueSize += value.intValue();
            return;
        }
    }

    public long getDiskReads() {
        return this.diskReadBytes;
    }

    public long getDiskWrites() {
        return this.diskWrittenBytes;
    }

    public int getBackupsInProgress() {
        return this.backupsInProgress;
    }

    public int getBackupsCompleted() {
        return this.backupsCompleted;
    }

    public long getFlushedBytes() {
        return this.flushedBytes;
    }

    public long getFlushes() {
        return this.flushes;
    }

    public long getFlushTime() {
        return this.flushTime;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    private class MemberLevelDiskStatisticsListener
    implements StatisticsListener {
        MBeanStatsMonitor.DefaultHashMap statsMap = new MBeanStatsMonitor.DefaultHashMap();
        private boolean removed = false;

        private MemberLevelDiskStatisticsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(StatisticsNotification notification) {
            MBeanStatsMonitor.DefaultHashMap defaultHashMap = this.statsMap;
            synchronized (defaultHashMap) {
                if (this.removed) {
                    return;
                }
                for (StatisticId statId : notification) {
                    Number value;
                    StatisticDescriptor descriptor = statId.getStatisticDescriptor();
                    String name = descriptor.getName();
                    try {
                        value = notification.getValue(statId);
                    }
                    catch (StatisticNotFoundException e) {
                        value = 0;
                    }
                    MemberLevelDiskMonitor.this.log(name, value);
                    Number deltaValue = MemberLevelDiskMonitor.this.computeDelta(this.statsMap, name, value);
                    this.statsMap.put(name, value);
                    MemberLevelDiskMonitor.this.increaseStats(name, deltaValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decreaseDiskStoreStats(Statistics stats) {
            MBeanStatsMonitor.DefaultHashMap defaultHashMap = this.statsMap;
            synchronized (defaultHashMap) {
                MemberLevelDiskMonitor.this.queueSize = MemberLevelDiskMonitor.this.queueSize - this.statsMap.get("queueSize").intValue();
                MemberLevelDiskMonitor.this.backupsInProgress = MemberLevelDiskMonitor.this.backupsInProgress - this.statsMap.get("backupsInProgress").intValue();
                this.removed = true;
            }
        }
    }
}

