/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;

public class MBeanStatsMonitor
implements StatisticsListener {
    protected ValueMonitor monitor;
    protected DefaultHashMap statsMap;
    protected String monitorName;
    private LogWriterI18n logger;

    public MBeanStatsMonitor(String name) {
        this.monitorName = name;
        this.monitor = new ValueMonitor();
        this.statsMap = new DefaultHashMap();
        this.logger = InternalDistributedSystem.getLoggerI18n();
    }

    public void addStatisticsToMonitor(Statistics stats) {
        StatisticDescriptor[] descriptors;
        this.monitor.addListener(this);
        StatisticsType type = stats.getType();
        for (StatisticDescriptor d : descriptors = type.getStatistics()) {
            this.statsMap.put(d.getName(), stats.get(d));
        }
        this.monitor.addStatistics(stats);
    }

    public void removeStatisticsFromMonitor(Statistics stats) {
        this.statsMap.clear();
    }

    public void stopListener() {
        this.monitor.removeListener(this);
    }

    public Number getStatistic(String statName) {
        return this.statsMap.get(statName) != null ? (Number)this.statsMap.get(statName) : (Number)0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            this.statsMap.put(name, value);
        }
    }

    protected void log(String name, Number value) {
        if (this.logger != null && this.logger.finestEnabled()) {
            this.logger.finest("Monitor = " + this.monitorName + " descriptor = " + name + " And Value = " + value);
        }
    }

    public static class DefaultHashMap {
        private Map<String, Number> internalMap = new HashMap<String, Number>();

        public Number get(String key) {
            return this.internalMap.get(key) != null ? (Number)this.internalMap.get(key) : (Number)0;
        }

        public void put(String key, Number value) {
            this.internalMap.put(key, value);
        }

        public void clear() {
            this.internalMap.clear();
        }
    }
}

