/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LocatorMBeanBridge {
    private static final Logger logger = LogService.getLogger();
    private Locator loc;
    private InternalDistributedSystem system;
    private GemFireCacheImpl cache;

    public LocatorMBeanBridge(Locator loc) {
        this.loc = loc;
        this.system = (InternalDistributedSystem)loc.getDistributedSystem();
        this.cache = GemFireCacheImpl.getInstance();
    }

    public String getBindAddress() {
        return this.loc.getBindAddress().getCanonicalHostName();
    }

    public String getHostnameForClients() {
        return this.loc.getHostnameForClients();
    }

    public String viewLog() {
        return this.fetchLog(this.loc.getLogFile(), 30);
    }

    public int getPort() {
        return this.loc.getPort();
    }

    public boolean isPeerLocator() {
        return this.loc.isPeerLocator();
    }

    public boolean isServerLocator() {
        return this.loc.isServerLocator();
    }

    public String[] listManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> alreadyManaging;
        if (this.cache != null && !(alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging()).isEmpty()) {
            String[] managers = new String[alreadyManaging.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : alreadyManaging) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listPotentialManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> willingToManage;
        if (this.cache != null && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            String[] managers = new String[willingToManage.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : willingToManage) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    private String fetchLog(File logFile, int numLines) {
        if (numLines > 100) {
            numLines = 100;
        }
        if (numLines == 0 || numLines < 0) {
            numLines = 30;
        }
        String mainTail = null;
        try {
            InternalDistributedSystem sys = this.system;
            mainTail = BeanUtilFuncs.tailSystemLog(logFile, numLines);
            if (mainTail == null) {
                mainTail = ManagementStrings.TailLogResponse_NO_LOG_FILE_WAS_SPECIFIED_IN_THE_CONFIGURATION_MESSAGES_IS_BEING_DIRECTED_TO_STDOUT.toLocalizedString();
            }
        }
        catch (IOException e) {
            logger.warn((Message)LocalizedMessage.create(ManagementStrings.TailLogResponse_ERROR_OCCURRED_WHILE_READING_LOGFILE_LOG__0, e));
            mainTail = "";
        }
        if (mainTail == null) {
            return LocalizedStrings.SystemMemberImpl_NO_LOG_FILE_CONFIGURED_LOG_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
        }
        StringBuffer result = new StringBuffer();
        if (mainTail != null) {
            result.append(mainTail);
        }
        return result.toString();
    }
}

