/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management;

import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;

@ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
public interface DiskStoreMXBean {
    public String getName();

    public boolean isAutoCompact();

    public int getCompactionThreshold();

    public boolean isForceCompactionAllowed();

    public long getMaxOpLogSize();

    public long getTimeInterval();

    public int getWriteBufferSize();

    public String[] getDiskDirectories();

    public int getQueueSize();

    public long getTotalBytesOnDisk();

    public float getDiskReadsRate();

    public float getDiskWritesRate();

    public long getDiskReadsAvgLatency();

    public long getDiskWritesAvgLatency();

    public long getFlushTimeAvgLatency();

    public int getTotalQueueSize();

    public int getTotalBackupInProgress();

    public int getTotalBackupCompleted();

    public int getTotalRecoveriesInProgress();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void forceRoll();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public boolean forceCompaction();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void flush();

    public float getDiskUsageWarningPercentage();

    public float getDiskUsageCriticalPercentage();

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void setDiskUsageWarningPercentage(float var1);

    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public void setDiskUsageCriticalPercentage(float var1);
}

