/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.Assert;

public class StoppableCountDownLatch {
    static final long RETRY_TIME = Long.getLong("gemfire.stoppable-retry-interval", 2000L);
    private final CountDownLatch latch;
    private final CancelCriterion stopper;

    public StoppableCountDownLatch(CancelCriterion stopper, int count) {
        Assert.assertTrue(stopper != null);
        this.latch = new CountDownLatch(count);
        this.stopper = stopper;
    }

    public void await() throws InterruptedException {
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!this.latch.await(RETRY_TIME, TimeUnit.MILLISECONDS));
    }

    public boolean await(long msTimeout) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.latch.await(msTimeout, TimeUnit.MILLISECONDS);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.latch.await(timeout, unit);
    }

    public synchronized void countDown() {
        this.latch.countDown();
    }

    public long getCount() {
        return this.latch.getCount();
    }

    public String toString() {
        return "(Stoppable) " + this.latch.toString();
    }
}

