/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class StackTraceCollector {
    private static int MAX_TRACE_SIZE = 131072;
    private Set<String> stackTraceSet = new ConcurrentSkipListSet<String>();
    private volatile boolean on = true;
    private ByteArrayOutputStream ostream = new ByteArrayOutputStream(MAX_TRACE_SIZE);
    private PrintWriter writer = new PrintWriter(this.ostream);

    public boolean isOn() {
        return this.on;
    }

    public boolean isOff() {
        return !this.isOn();
    }

    public void on() {
        this.on = true;
    }

    public void off() {
        this.on = false;
    }

    public boolean add(Throwable throwable) {
        return this.add(this.stackTraceSet, throwable);
    }

    protected synchronized boolean add(Set<String> stackTraceSet, Throwable throwable) {
        if (this.on) {
            String trace = this.convert(throwable);
            return stackTraceSet.add(trace);
        }
        return false;
    }

    public boolean clear() {
        boolean value = this.stackTraceSet.size() > 0;
        this.stackTraceSet.clear();
        return value;
    }

    public boolean contains(Throwable throwable) {
        return this.contains(this.convert(throwable));
    }

    public boolean contains(String stackTrace) {
        return this.stackTraceSet.contains(stackTrace);
    }

    public synchronized String convert(Throwable throwable) {
        throwable.printStackTrace(this.writer);
        this.writer.flush();
        String stackTrace = this.ostream.toString();
        this.ostream.reset();
        return stackTrace;
    }

    public Set<String> view() {
        return Collections.unmodifiableSet(this.stackTraceSet);
    }
}

