/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SingletonValue<T extends Closeable> {
    private final SingletonBuilder<T> builder;
    private final ReentrantLock sync;
    private final Condition change;
    private ValueState state;
    private Thread current;
    private T value;
    private IOException error;

    public SingletonValue(SingletonBuilder<T> builder) {
        this.builder = builder;
        this.state = ValueState.NOT_SET;
        this.sync = new ReentrantLock();
        this.change = this.sync.newCondition();
    }

    public boolean hasCachedValue() {
        this.sync.lock();
        try {
            boolean bl = this.state == ValueState.SET;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    public boolean isCleared() {
        this.sync.lock();
        try {
            boolean bl = this.state == ValueState.CLEARED;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    public T getCachedValue() {
        this.sync.lock();
        try {
            T t = this.value;
            return t;
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T clear(boolean allowReset) {
        this.sync.lock();
        try {
            if (this.state == ValueState.NOT_SET) {
                T t = null;
                return t;
            }
            T result = this.value;
            ValueState old = this.state;
            this.state = allowReset ? ValueState.NOT_SET : ValueState.CLEARED;
            this.current = null;
            this.value = null;
            this.error = null;
            if (old == ValueState.IN_PROGRESS) {
                this.change.signalAll();
            }
            T t = result;
            return t;
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear(T expect, boolean allowReset) {
        this.sync.lock();
        try {
            if (expect != this.value) {
                boolean bl = false;
                return bl;
            }
            ValueState prev = this.state;
            this.clear(allowReset);
            boolean bl = prev == ValueState.SET;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="findbugs is wrong and Darrel agrees")
    public T get() throws IOException {
        assert (this.sync.getHoldCount() == 0);
        this.sync.lock();
        boolean doUnlock = true;
        try {
            switch (this.state) {
                case NOT_SET: {
                    assert (this.current == null);
                    this.current = Thread.currentThread();
                    this.state = ValueState.IN_PROGRESS;
                    doUnlock = false;
                    this.sync.unlock();
                    T t = this.acquireValue();
                    return t;
                }
                case IN_PROGRESS: {
                    this.builder.createInProgress();
                    while (this.state == ValueState.IN_PROGRESS) {
                        try {
                            this.change.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    if (this.error != null) {
                        throw this.error;
                    }
                    doUnlock = false;
                    this.sync.unlock();
                    T t = this.get();
                    return t;
                }
                case SET: {
                    T t = this.value;
                    return t;
                }
                case CLEARED: {
                    throw new IOException("Value has been cleared and cannot be reset");
                }
            }
            throw new IllegalStateException("Unknown ValueState: " + (Object)((Object)this.state));
        }
        finally {
            if (doUnlock) {
                this.sync.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="findbugs is wrong and Darrel agrees")
    private T acquireValue() throws IOException {
        Closeable result = null;
        IOException err = null;
        try {
            result = (Closeable)this.builder.create();
        }
        catch (IOException e) {
            err = e;
        }
        this.sync.lock();
        boolean doUnlock = true;
        try {
            if (this.state != ValueState.IN_PROGRESS || this.current != Thread.currentThread()) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.sync.unlock();
                doUnlock = false;
                T t = this.get();
                return t;
            }
            this.state = err == null ? ValueState.SET : ValueState.NOT_SET;
            this.current = null;
            this.value = result;
            this.error = err;
            try {
                this.builder.postCreate();
            }
            finally {
                this.change.signalAll();
            }
        }
        finally {
            if (doUnlock) {
                this.sync.unlock();
            }
        }
        if (err != null) {
            throw err;
        }
        return (T)result;
    }

    private static enum ValueState {
        NOT_SET,
        IN_PROGRESS,
        SET,
        CLEARED;

    }

    public static interface SingletonBuilder<T extends Closeable> {
        public T create() throws IOException;

        public void postCreate();

        public void createInProgress();
    }
}

