/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.InterruptedIOException;
import java.util.concurrent.Callable;

public class SingletonCallable<T> {
    private Object lock = new Object();
    private volatile boolean running = false;
    private Exception ex = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T runSerially(Callable<T> c) throws Exception {
        T retval = null;
        Object object = this.lock;
        synchronized (object) {
            while (this.running) {
                try {
                    this.lock.wait();
                    if (this.ex == null) continue;
                    throw this.ex;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            this.ex = null;
            this.running = true;
        }
        Exception exception = null;
        try {
            retval = c.call();
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                if (exception != null && !this.ignoreException(exception)) {
                    this.ex = exception;
                }
                this.running = false;
                this.lock.notifyAll();
            }
        }
        if (exception != null) {
            throw exception;
        }
        return retval;
    }

    public boolean ignoreException(Exception e) {
        return false;
    }
}

