/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PasswordUtil {
    private static byte[] init = "string".getBytes();

    public static String encrypt(String password) {
        return PasswordUtil.encrypt(password, true);
    }

    public static String encrypt(String password, boolean echo) {
        String encryptedString = null;
        try {
            SecretKeySpec key = new SecretKeySpec(init, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(password.getBytes());
            encryptedString = PasswordUtil.byteArrayToHexString(encrypted);
            if (echo) {
                System.out.println(LocalizedStrings.PasswordUtil_ENCRYPTED_TO_0.toLocalizedString(encryptedString));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    public static String decrypt(String password) {
        if (password.startsWith("encrypted(") && password.endsWith(")")) {
            byte[] decrypted = null;
            try {
                String toDecrypt = password.substring(10, password.length() - 1);
                SecretKeySpec key = new SecretKeySpec(init, "Blowfish");
                Cipher cipher = Cipher.getInstance("Blowfish");
                cipher.init(2, key);
                decrypted = cipher.doFinal(PasswordUtil.hexStringToByteArray(toDecrypt));
                return new String(decrypted);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return password;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    private static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }
}

