/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class DebuggerSupport {
    private static final Logger logger = LogService.getLogger();

    private DebuggerSupport() {
    }

    public static void waitForJavaDebugger() {
        DebuggerSupport.waitForJavaDebugger(null);
    }

    @SuppressWarnings(value={"IL_INFINITE_LOOP"}, justification="Endless loop is for debugging purposes.")
    public static void waitForJavaDebugger(String extraLogMsg) {
        boolean cont = false;
        String msg = ":";
        if (extraLogMsg != null) {
            msg = msg + extraLogMsg;
        }
        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DebuggerSupport_WAITING_FOR_DEBUGGER_TO_ATTACH_0, msg));
        boolean interrupted = false;
        while (!cont) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DebuggerSupport_DEBUGGER_CONTINUING));
    }
}

