/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.concurrent.Atomics;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.logging.log4j.Logger;

public abstract class StatisticsImpl
implements Statistics {
    static Logger logger = LogService.getLogger();
    private final StatisticsTypeImpl type;
    private final String textId;
    private final long numericId;
    private final int osStatFlags;
    private boolean closed;
    private long uniqueId;
    private final CopyOnWriteHashMap<Integer, IntSupplier> intSuppliers = new CopyOnWriteHashMap();
    private final CopyOnWriteHashMap<Integer, LongSupplier> longSuppliers = new CopyOnWriteHashMap();
    private final CopyOnWriteHashMap<Integer, DoubleSupplier> doubleSuppliers = new CopyOnWriteHashMap();
    private final Set<Object> flakySuppliers = new HashSet<Object>();

    public static Statistics createAtomicNoOS(StatisticsType type, String textId, long numericId, long uniqueId, StatisticsManager mgr) {
        return Atomics.createAtomicStatistics(type, textId, numericId, uniqueId, mgr);
    }

    public StatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, int osStatFlags) {
        this.type = (StatisticsTypeImpl)type;
        this.textId = textId;
        this.numericId = numericId;
        this.uniqueId = uniqueId;
        this.osStatFlags = osStatFlags;
        this.closed = false;
    }

    public final boolean usesSystemCalls() {
        return this.osStatFlags != 0;
    }

    public final int getOsStatFlags() {
        return this.osStatFlags;
    }

    @Override
    public final int nameToId(String name) {
        return this.type.nameToId(name);
    }

    @Override
    public final StatisticDescriptor nameToDescriptor(String name) {
        return this.type.nameToDescriptor(name);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public abstract boolean isAtomic();

    private final boolean isOpen() {
        return !this.closed;
    }

    @Override
    public final StatisticsType getType() {
        return this.type;
    }

    @Override
    public final String getTextId() {
        return this.textId;
    }

    @Override
    public final long getNumericId() {
        return this.numericId;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long uid) {
        this.uniqueId = uid;
    }

    @Override
    public final void setInt(String name, int value) {
        this.setInt(this.nameToDescriptor(name), value);
    }

    @Override
    public final void setInt(StatisticDescriptor descriptor, int value) {
        this.setInt(StatisticsImpl.getIntId(descriptor), value);
    }

    @Override
    public final void setInt(int id, int value) {
        if (this.isOpen()) {
            this._setInt(id, value);
        }
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public final void setLong(String name, long value) {
        this.setLong(this.nameToDescriptor(name), value);
    }

    @Override
    public final void setLong(StatisticDescriptor descriptor, long value) {
        this.setLong(StatisticsImpl.getLongId(descriptor), value);
    }

    @Override
    public final void setLong(int id, long value) {
        if (this.isOpen()) {
            this._setLong(id, value);
        }
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public final void setDouble(String name, double value) {
        this.setDouble(this.nameToDescriptor(name), value);
    }

    @Override
    public final void setDouble(StatisticDescriptor descriptor, double value) {
        this.setDouble(StatisticsImpl.getDoubleId(descriptor), value);
    }

    @Override
    public final void setDouble(int id, double value) {
        if (this.isOpen()) {
            this._setDouble(id, value);
        }
    }

    protected abstract void _setDouble(int var1, double var2);

    @Override
    public final int getInt(String name) {
        return this.getInt(this.nameToDescriptor(name));
    }

    @Override
    public final int getInt(StatisticDescriptor descriptor) {
        return this.getInt(StatisticsImpl.getIntId(descriptor));
    }

    @Override
    public final int getInt(int id) {
        if (this.isOpen()) {
            return this._getInt(id);
        }
        return 0;
    }

    protected abstract int _getInt(int var1);

    @Override
    public final long getLong(String name) {
        return this.getLong(this.nameToDescriptor(name));
    }

    @Override
    public final long getLong(StatisticDescriptor descriptor) {
        return this.getLong(StatisticsImpl.getLongId(descriptor));
    }

    @Override
    public final long getLong(int id) {
        if (this.isOpen()) {
            return this._getLong(id);
        }
        return 0L;
    }

    protected abstract long _getLong(int var1);

    @Override
    public final double getDouble(String name) {
        return this.getDouble(this.nameToDescriptor(name));
    }

    @Override
    public final double getDouble(StatisticDescriptor descriptor) {
        return this.getDouble(StatisticsImpl.getDoubleId(descriptor));
    }

    @Override
    public final double getDouble(int id) {
        if (this.isOpen()) {
            return this._getDouble(id);
        }
        return 0.0;
    }

    protected abstract double _getDouble(int var1);

    @Override
    public final Number get(StatisticDescriptor descriptor) {
        if (this.isOpen()) {
            return this._get((StatisticDescriptorImpl)descriptor);
        }
        return 0;
    }

    @Override
    public final Number get(String name) {
        return this.get(this.nameToDescriptor(name));
    }

    @Override
    public long getRawBits(StatisticDescriptor descriptor) {
        if (this.isOpen()) {
            return this._getRawBits((StatisticDescriptorImpl)descriptor);
        }
        return 0L;
    }

    @Override
    public long getRawBits(String name) {
        return this.getRawBits(this.nameToDescriptor(name));
    }

    @Override
    public final void incInt(String name, int delta) {
        this.incInt(this.nameToDescriptor(name), delta);
    }

    @Override
    public final void incInt(StatisticDescriptor descriptor, int delta) {
        this.incInt(StatisticsImpl.getIntId(descriptor), delta);
    }

    @Override
    public final void incInt(int id, int delta) {
        if (this.isOpen()) {
            this._incInt(id, delta);
        }
    }

    protected abstract void _incInt(int var1, int var2);

    @Override
    public final void incLong(String name, long delta) {
        this.incLong(this.nameToDescriptor(name), delta);
    }

    @Override
    public final void incLong(StatisticDescriptor descriptor, long delta) {
        this.incLong(StatisticsImpl.getLongId(descriptor), delta);
    }

    @Override
    public final void incLong(int id, long delta) {
        if (this.isOpen()) {
            this._incLong(id, delta);
        }
    }

    protected abstract void _incLong(int var1, long var2);

    @Override
    public final void incDouble(String name, double delta) {
        this.incDouble(this.nameToDescriptor(name), delta);
    }

    @Override
    public final void incDouble(StatisticDescriptor descriptor, double delta) {
        this.incDouble(StatisticsImpl.getDoubleId(descriptor), delta);
    }

    @Override
    public final void incDouble(int id, double delta) {
        if (this.isOpen()) {
            this._incDouble(id, delta);
        }
    }

    protected abstract void _incDouble(int var1, double var2);

    public void prepareForSample() {
    }

    public int invokeSuppliers() {
        int errors = 0;
        for (Map.Entry<Integer, IntSupplier> entry : this.intSuppliers.entrySet()) {
            try {
                this._setInt(entry.getKey(), entry.getValue().getAsInt());
            }
            catch (Throwable t) {
                this.logSupplierError(t, entry.getKey(), entry.getValue());
                ++errors;
            }
        }
        for (Map.Entry<Integer, Object> entry : this.longSuppliers.entrySet()) {
            try {
                this._setLong(entry.getKey(), ((LongSupplier)entry.getValue()).getAsLong());
            }
            catch (Throwable t) {
                this.logSupplierError(t, entry.getKey(), entry.getValue());
                ++errors;
            }
        }
        for (Map.Entry<Integer, Object> entry : this.doubleSuppliers.entrySet()) {
            try {
                this._setDouble(entry.getKey(), ((DoubleSupplier)entry.getValue()).getAsDouble());
            }
            catch (Throwable t) {
                this.logSupplierError(t, entry.getKey(), entry.getValue());
                ++errors;
            }
        }
        return errors;
    }

    private void logSupplierError(Throwable t, int statId, Object supplier) {
        if (this.flakySuppliers.add(supplier)) {
            logger.warn("Error invoking supplier for stat {}, id {}", (Object)this.getTextId(), (Object)statId, (Object)t);
        }
    }

    public int getSupplierCount() {
        return this.intSuppliers.size() + this.doubleSuppliers.size() + this.longSuppliers.size();
    }

    @Override
    public IntSupplier setIntSupplier(int id, IntSupplier supplier) {
        if (id >= this.type.getIntStatCount()) {
            throw new IllegalArgumentException("Id " + id + " is not in range for stat" + this.type);
        }
        return this.intSuppliers.put(id, supplier);
    }

    @Override
    public IntSupplier setIntSupplier(String name, IntSupplier supplier) {
        return this.setIntSupplier(this.nameToId(name), supplier);
    }

    @Override
    public IntSupplier setIntSupplier(StatisticDescriptor descriptor, IntSupplier supplier) {
        return this.setIntSupplier(StatisticsImpl.getIntId(descriptor), supplier);
    }

    @Override
    public LongSupplier setLongSupplier(int id, LongSupplier supplier) {
        if (id >= this.type.getLongStatCount()) {
            throw new IllegalArgumentException("Id " + id + " is not in range for stat" + this.type);
        }
        return this.longSuppliers.put(id, supplier);
    }

    @Override
    public LongSupplier setLongSupplier(String name, LongSupplier supplier) {
        return this.setLongSupplier(this.nameToId(name), supplier);
    }

    @Override
    public LongSupplier setLongSupplier(StatisticDescriptor descriptor, LongSupplier supplier) {
        return this.setLongSupplier(StatisticsImpl.getLongId(descriptor), supplier);
    }

    @Override
    public DoubleSupplier setDoubleSupplier(int id, DoubleSupplier supplier) {
        if (id >= this.type.getDoubleStatCount()) {
            throw new IllegalArgumentException("Id " + id + " is not in range for stat" + this.type);
        }
        return this.doubleSuppliers.put(id, supplier);
    }

    @Override
    public DoubleSupplier setDoubleSupplier(String name, DoubleSupplier supplier) {
        return this.setDoubleSupplier(this.nameToId(name), supplier);
    }

    @Override
    public DoubleSupplier setDoubleSupplier(StatisticDescriptor descriptor, DoubleSupplier supplier) {
        return this.setDoubleSupplier(StatisticsImpl.getDoubleId(descriptor), supplier);
    }

    public int hashCode() {
        return (int)this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StatisticsImpl)) {
            return false;
        }
        StatisticsImpl other = (StatisticsImpl)o;
        return this.uniqueId == other.getUniqueId();
    }

    private static final int getIntId(StatisticDescriptor descriptor) {
        return ((StatisticDescriptorImpl)descriptor).checkInt();
    }

    private static final int getLongId(StatisticDescriptor descriptor) {
        return ((StatisticDescriptorImpl)descriptor).checkLong();
    }

    private static final int getDoubleId(StatisticDescriptor descriptor) {
        return ((StatisticDescriptorImpl)descriptor).checkDouble();
    }

    private final Number _get(StatisticDescriptorImpl stat) {
        switch (stat.getTypeCode()) {
            case 5: {
                return this._getInt(stat.getId());
            }
            case 6: {
                return this._getLong(stat.getId());
            }
            case 8: {
                return this._getDouble(stat.getId());
            }
        }
        throw new RuntimeException(LocalizedStrings.StatisticsImpl_UNEXPECTED_STAT_DESCRIPTOR_TYPE_CODE_0.toLocalizedString(stat.getTypeCode()));
    }

    private final long _getRawBits(StatisticDescriptorImpl stat) {
        switch (stat.getTypeCode()) {
            case 5: {
                return this._getInt(stat.getId());
            }
            case 6: {
                return this._getLong(stat.getId());
            }
            case 8: {
                return Double.doubleToRawLongBits(this._getDouble(stat.getId()));
            }
        }
        throw new RuntimeException(LocalizedStrings.StatisticsImpl_UNEXPECTED_STAT_DESCRIPTOR_TYPE_CODE_0.toLocalizedString(stat.getTypeCode()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("uniqueId=").append(this.uniqueId);
        sb.append(", numericId=").append(this.numericId);
        sb.append(", textId=").append(this.textId);
        sb.append(", type=").append(this.type.getName());
        sb.append(", closed=").append(this.closed);
        sb.append("}");
        return sb.toString();
    }
}

