/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public abstract class AbstractStatisticsFactory
implements StatisticsFactory,
StatisticsManager {
    private final long id;
    private final String name;
    private final CopyOnWriteArrayList<Statistics> statsList;
    private int statsListModCount = 0;
    private long statsListUniqueId = 1L;
    private final Object statsListUniqueIdLock;
    private final StatisticsTypeFactory tf;
    private final long startTime;

    public AbstractStatisticsFactory(long id, String name, long startTime) {
        this.id = id;
        this.name = name;
        this.startTime = startTime;
        this.statsList = new CopyOnWriteArrayList();
        this.statsListUniqueIdLock = new Object();
        this.tf = StatisticsTypeFactoryImpl.singleton();
    }

    public void close() {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final int getStatListModCount() {
        return this.statsListModCount;
    }

    @Override
    public final List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public final int getStatisticsCount() {
        int result = 0;
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        if (statsList != null) {
            result = statsList.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics findStatistics(long id) {
        CopyOnWriteArrayList<Statistics> statsList;
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = statsList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            for (Statistics s : statsList) {
                if (s.getUniqueId() != id) continue;
                return s;
            }
        }
        throw new RuntimeException(LocalizedStrings.PureStatSampler_COULD_NOT_FIND_STATISTICS_INSTANCE.toLocalizedString());
    }

    @Override
    public final boolean statisticsExists(long id) {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        for (Statistics s : statsList) {
            if (s.getUniqueId() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Statistics[] getStatistics() {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        return statsList.toArray(new Statistics[statsList.size()]);
    }

    @Override
    public final Statistics createStatistics(StatisticsType type) {
        return this.createOsStatistics(type, null, 0L, 0);
    }

    @Override
    public final Statistics createStatistics(StatisticsType type, String textId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    @Override
    public final Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        LocalStatisticsImpl result = new LocalStatisticsImpl(type, textId, numericId, myUniqueId, false, osStatFlags, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public final Statistics[] findStatisticsByType(StatisticsType type) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (type != s.getType()) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public final Statistics[] findStatisticsByTextId(String textId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (!s.getTextId().equals(textId)) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public final Statistics[] findStatisticsByNumericId(long numericId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (numericId != s.getNumericId()) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    public final Statistics findStatisticsByUniqueId(long uniqueId) {
        for (Statistics s : this.statsList) {
            if (uniqueId != s.getUniqueId()) continue;
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroyStatistics(Statistics stats) {
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            if (this.statsList.remove(stats)) {
                ++this.statsListModCount;
            }
        }
    }

    @Override
    public final Statistics createAtomicStatistics(StatisticsType type) {
        return this.createAtomicStatistics(type, null, 0L);
    }

    @Override
    public final Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.createAtomicStatistics(type, textId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        Statistics result = StatisticsImpl.createAtomicNoOS(type, textId, numericId, myUniqueId, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public final StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.tf.createType(name, description, stats);
    }

    @Override
    public final StatisticsType findType(String name) {
        return this.tf.findType(name);
    }

    @Override
    public final StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return this.tf.createTypesFromXml(reader);
    }

    @Override
    public final StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.tf.createIntCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createLongCounter(String name, String description, String units) {
        return this.tf.createLongCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return this.tf.createDoubleCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.tf.createIntGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createLongGauge(String name, String description, String units) {
        return this.tf.createLongGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return this.tf.createDoubleGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleGauge(name, description, units, largerBetter);
    }
}

