/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;

public interface LifecycleListener {
    public static final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();

    public void afterCreate(MemoryAllocatorImpl var1);

    public void afterReuse(MemoryAllocatorImpl var1);

    public void beforeClose(MemoryAllocatorImpl var1);

    public static void invokeBeforeClose(MemoryAllocatorImpl allocator) {
        for (LifecycleListener listener : lifecycleListeners) {
            listener.beforeClose(allocator);
        }
    }

    public static void invokeAfterReuse(MemoryAllocatorImpl allocator) {
        for (LifecycleListener listener : lifecycleListeners) {
            listener.afterReuse(allocator);
        }
    }

    public static void invokeAfterCreate(MemoryAllocatorImpl allocator) {
        for (LifecycleListener listener : lifecycleListeners) {
            listener.afterCreate(allocator);
        }
    }

    public static void removeLifecycleListener(LifecycleListener listener) {
        lifecycleListeners.remove(listener);
    }

    public static void addLifecycleListener(LifecycleListener listener) {
        lifecycleListeners.add(listener);
    }
}

