/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.index.IndexCreationData;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RegionCreation
implements Region,
Extensible<Region<?, ?>> {
    private final String name;
    private String refid;
    private boolean hasAttributes;
    private final String fullPath;
    private RegionAttributesCreation attrs;
    private Map subregions = new LinkedHashMap();
    private Map values = new HashMap();
    private List indexes = new ArrayList();
    private final CacheCreation cache;
    private final SimpleExtensionPoint<Region<?, ?>> extensionPoint = new SimpleExtensionPoint<RegionCreation>(this, this);

    public RegionCreation(CacheCreation cache, RegionCreation parent, String name, String refid) {
        this.cache = cache;
        this.fullPath = parent != null ? parent.getFullPath() + "/" + name : "/" + name;
        this.name = name;
        this.refid = refid;
        this.attrs = new RegionAttributesCreation(this.cache);
        if (refid != null) {
            this.attrs.setRefid(refid);
            this.attrs.inheritAttributes(cache);
        }
    }

    public RegionCreation(CacheCreation cache, String name, String refid) {
        this(cache, null, name, refid);
    }

    public RegionCreation(CacheCreation cache, String name) {
        this(cache, null, name, null);
    }

    @Override
    public Object put(Object key, Object value) throws TimeoutException, CacheWriterException {
        return this.values.put(key, value);
    }

    private void fillIn(Region region) throws TimeoutException, CacheWriterException, RegionExistsException {
        for (Map.Entry entry : this.values.entrySet()) {
            region.put(entry.getKey(), entry.getValue());
        }
        if (region instanceof Extensible) {
            Extensible extensible = (Extensible)((Object)region);
            this.extensionPoint.fireCreate(extensible);
        }
        for (RegionCreation sub : this.subregions.values()) {
            sub.create(region);
        }
    }

    private void setMutableAttributes(Region region) {
        AttributesMutator mutator = region.getAttributesMutator();
        RegionAttributesCreation attrs = this.attrs;
        if (attrs.hasCacheListeners()) {
            mutator.initCacheListeners(attrs.getCacheListeners());
        }
        if (attrs.hasCacheLoader()) {
            mutator.setCacheLoader(attrs.getCacheLoader());
        }
        if (attrs.hasCacheWriter()) {
            mutator.setCacheWriter(attrs.getCacheWriter());
        }
        if (attrs.hasEntryIdleTimeout()) {
            mutator.setEntryIdleTimeout(attrs.getEntryIdleTimeout());
        }
        if (attrs.hasCustomEntryIdleTimeout()) {
            mutator.setCustomEntryIdleTimeout(attrs.getCustomEntryIdleTimeout());
        }
        if (attrs.hasEntryTimeToLive()) {
            mutator.setEntryTimeToLive(attrs.getEntryTimeToLive());
        }
        if (attrs.hasCustomEntryTimeToLive()) {
            mutator.setCustomEntryTimeToLive(attrs.getCustomEntryTimeToLive());
        }
        if (attrs.hasRegionIdleTimeout()) {
            mutator.setRegionIdleTimeout(attrs.getEntryIdleTimeout());
        }
        if (attrs.hasRegionTimeToLive()) {
            mutator.setRegionTimeToLive(attrs.getRegionTimeToLive());
        }
        if (attrs.hasCloningEnabled()) {
            mutator.setCloningEnabled(attrs.getCloningEnabled());
        }
    }

    void createRoot(Cache cache) throws TimeoutException, CacheWriterException, RegionExistsException {
        Region root = null;
        this.attrs.inheritAttributes(cache);
        this.attrs.setIndexes(this.indexes);
        this.attrs.prepareForValidation();
        this.extensionPoint.beforeCreate(cache);
        try {
            root = ((GemFireCacheImpl)cache).basicCreateRegion(this.name, new AttributesFactory(this.attrs).create());
        }
        catch (RegionExistsException ex) {
            root = ex.getRegion();
            this.setMutableAttributes(root);
        }
        catch (RegionDestroyedException ex) {
            cache.getLoggerI18n().warning(LocalizedStrings.RegionCreation_REGION_DESTROYED_DURING_INITIALIZATION, this.name);
        }
        if (root != null) {
            this.fillIn(root);
        }
    }

    void addIndexData(IndexCreationData icd) {
        this.indexes.add(icd);
    }

    void create(Region parent) throws TimeoutException, CacheWriterException, RegionExistsException {
        this.attrs.inheritAttributes(parent.getCache());
        this.attrs.prepareForValidation();
        this.attrs.setIndexes(this.indexes);
        Region me = null;
        try {
            me = parent.createSubregion(this.name, new AttributesFactory(this.attrs).create());
        }
        catch (RegionExistsException ex) {
            me = ex.getRegion();
            this.setMutableAttributes(me);
        }
        catch (RegionDestroyedException ex) {
            this.cache.getLoggerI18n().warning(LocalizedStrings.RegionCreation_REGION_DESTROYED_DURING_INITIALIZATION, this.name);
        }
        if (me != null) {
            String id = this.attrs.getId();
            if (id != null) {
                RegionAttributes realAttrs = me.getAttributes();
                me.getCache().setRegionAttributes(id, realAttrs);
            }
            this.fillIn(me);
        }
    }

    public boolean sameAs(Region other) {
        if (other == null) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            throw new RuntimeException(LocalizedStrings.RegionCreation_REGION_NAMES_DIFFER_THIS_0_OTHER_1.toLocalizedString(this.getName(), other.getName()));
        }
        if (!this.attrs.sameAs(other.getAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionCreation_REGION_ATTRIBUTES_DIFFER_THIS_0_OTHER_1.toLocalizedString(this.attrs, other.getAttributes()));
        }
        Set myEntries = this.basicEntries(false);
        Set otherEntries = ((LocalRegion)other).basicEntries(false);
        if (myEntries.size() != otherEntries.size()) {
            return false;
        }
        for (Region.Entry myEntry : myEntries) {
            Region.Entry otherEntry = other.getEntry(myEntry.getKey());
            if (otherEntry == null) {
                return false;
            }
            if (myEntry.getValue().equals(otherEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setAttributes(RegionAttributes attrs) {
        this.setAttributes(attrs, true);
    }

    public void setAttributes(RegionAttributes attrs, boolean setRefid) {
        this.hasAttributes = true;
        this.attrs = attrs instanceof RegionAttributesCreation ? (RegionAttributesCreation)attrs : new RegionAttributesCreation(this.cache, attrs, false);
        if (setRefid && this.attrs.getRefid() == null) {
            this.attrs.setRefid(this.getRefid());
        }
        if (attrs.getPartitionAttributes() != null && attrs.getEvictionAttributes() != null && attrs.getEvictionAttributes().getAlgorithm().isLRUMemory() && attrs.getPartitionAttributes().getLocalMaxMemory() != 0 && attrs.getEvictionAttributes().getMaximum() != attrs.getPartitionAttributes().getLocalMaxMemory()) {
            this.getCache().getLoggerI18n().warning(LocalizedStrings.Mem_LRU_Eviction_Attribute_Reset, new Object[]{this.getName(), attrs.getEvictionAttributes().getMaximum(), attrs.getPartitionAttributes().getLocalMaxMemory()});
            attrs.getEvictionAttributes();
            this.attrs.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes(attrs.getPartitionAttributes().getLocalMaxMemory(), attrs.getEvictionAttributes().getObjectSizer(), attrs.getEvictionAttributes().getAction()));
        }
    }

    public RegionAttributes getAttributes() {
        return this.attrs;
    }

    public Region getSubregion(String regionName) {
        return (Region)this.subregions.get(regionName);
    }

    void addSubregion(String name, RegionCreation region) throws RegionExistsException {
        if (this.subregions.containsKey(name)) {
            RegionCreation existing = (RegionCreation)this.subregions.get(name);
            throw new RegionExistsException(existing);
        }
        this.subregions.put(name, region);
    }

    public Set subregions(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_SUBREGIONS_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        return new HashSet(this.subregions.values());
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_WRITING_A_REGIONCREATION_TO_DISK_IS_NOT_SUPPORTED.toLocalizedString());
    }

    public void registerInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getDurableInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestListRegex() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public Set keySetOnServer() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public boolean containsKeyOnServer(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public Region.Entry getEntry(Object key) {
        Object value = this.values.get(key);
        if (value == null) {
            return null;
        }
        return new Entry(key, value);
    }

    public Set entries(boolean recursive) {
        return this.basicEntries(recursive);
    }

    public Set basicEntries(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_ENTRIES_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : this.values.entrySet()) {
            set.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public Region getParentRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public AttributesMutator getAttributesMutator() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheStatistics getStatistics() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidateRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void destroyRegion(Object aCacheWriterParam) throws CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroyRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Region createSubregion(String subregionName, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        RegionCreation subregion = new RegionCreation(this.cache, this, subregionName, null);
        subregion.setAttributes(attrs);
        this.addSubregion(subregionName, subregion);
        return subregion;
    }

    @Override
    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object get(Object key, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object put(Object key, Object value, Object aCacheWriterParam) throws TimeoutException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void create(Object key, Object value, Object aCacheWriterParam) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidate(Object key, Object callbackArgument) throws TimeoutException, EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidate(Object key) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidate(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object destroy(Object key, Object aCacheWriterParam) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroy(Object key) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroy(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Set keys() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public RegionService getRegionService() {
        return this.cache;
    }

    @Override
    public Object getUserAttribute() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setUserAttribute(Object value) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isDestroyed() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsValueForKey(Object key) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Lock getRegionDistributedLock() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Lock getDistributedLock(Object key) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean existsValue(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public SelectResults query(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Object selectValue(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void putAll(Map arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void putAll(Map arg0, Object callbackArg) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map getAll(Collection keys) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map getAll(Collection keys, Object callback) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Object remove(Object arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Set entrySet(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_ENTRIES_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : this.values.entrySet()) {
            set.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    @Override
    public void localClear() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void forceRolling() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public boolean forceCompaction() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public String getRefid() {
        return this.refid;
    }

    public boolean hasAttributes() {
        return this.hasAttributes;
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection keys) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void removeAll(Collection keys, Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ExtensionPoint<Region<?, ?>> getExtensionPoint() {
        return this.extensionPoint;
    }

    static class Entry
    implements Region.Entry {
        private Object key;
        private Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public Region getRegion() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CacheStatistics getStatistics() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object getUserAttribute() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object setUserAttribute(Object userAttribute) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public boolean isDestroyed() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    }
}

