/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;

public class GatewayReceiverStats
extends CacheServerStats {
    private static final String typeName = "GatewayReceiverStatistics";
    private static final String DUPLICATE_BATCHES_RECEIVED = "duplicateBatchesReceived";
    private static final String OUT_OF_ORDER_BATCHES_RECEIVED = "outoforderBatchesReceived";
    private static final String EARLY_ACKS = "earlyAcks";
    private static final String EVENTS_RECEIVED = "eventsReceived";
    private static final String CREAT_REQUESTS = "createRequests";
    private static final String UPDATE_REQUESTS = "updateRequest";
    private static final String DESTROY_REQUESTS = "destroyRequest";
    private static final String UNKNOWN_OPERATIONS_RECEIVED = "unknowsOperationsReceived";
    private static final String EXCEPTIONS_OCCURED = "exceptionsOccured";
    private int duplicateBatchesReceivedId;
    private int outoforderBatchesReceivedId;
    private int earlyAcksId;
    private int eventsReceivedId;
    private int createRequestId;
    private int updateRequestId;
    private int destroyRequestId;
    private int unknowsOperationsReceivedId;
    private int exceptionsOccuredId;

    public static GatewayReceiverStats createGatewayReceiverStats(String ownerName) {
        InternalDistributedSystem f = InternalDistributedSystem.getAnyInstance();
        StatisticDescriptor[] descriptors = new StatisticDescriptor[]{f.createIntCounter(DUPLICATE_BATCHES_RECEIVED, "number of batches which have already been seen by this GatewayReceiver", "nanoseconds"), f.createIntCounter(OUT_OF_ORDER_BATCHES_RECEIVED, "number of batches which are out of order on this GatewayReceiver", "operations"), f.createIntCounter(EARLY_ACKS, "number of early acknowledgements sent to gatewaySenders", "operations"), f.createIntCounter(EVENTS_RECEIVED, "total number events across the batched received by this GatewayReceiver", "operations"), f.createIntCounter(CREAT_REQUESTS, "total number of create operations received by this GatewayReceiver", "operations"), f.createIntCounter(UPDATE_REQUESTS, "total number of update operations received by this GatewayReceiver", "operations"), f.createIntCounter(DESTROY_REQUESTS, "total number of destroy operations received by this GatewayReceiver", "operations"), f.createIntCounter(UNKNOWN_OPERATIONS_RECEIVED, "total number of unknown operations received by this GatewayReceiver", "operations"), f.createIntCounter(EXCEPTIONS_OCCURED, "number of exceptions occured while porcessing the batches", "operations")};
        return new GatewayReceiverStats(f, ownerName, typeName, descriptors);
    }

    public GatewayReceiverStats(StatisticsFactory f, String ownerName, String typeName, StatisticDescriptor[] descriptiors) {
        super(f, ownerName, typeName, descriptiors);
        this.duplicateBatchesReceivedId = this.statType.nameToId(DUPLICATE_BATCHES_RECEIVED);
        this.outoforderBatchesReceivedId = this.statType.nameToId(OUT_OF_ORDER_BATCHES_RECEIVED);
        this.earlyAcksId = this.statType.nameToId(EARLY_ACKS);
        this.eventsReceivedId = this.statType.nameToId(EVENTS_RECEIVED);
        this.createRequestId = this.statType.nameToId(CREAT_REQUESTS);
        this.updateRequestId = this.statType.nameToId(UPDATE_REQUESTS);
        this.destroyRequestId = this.statType.nameToId(DESTROY_REQUESTS);
        this.unknowsOperationsReceivedId = this.statType.nameToId(UNKNOWN_OPERATIONS_RECEIVED);
        this.exceptionsOccuredId = this.statType.nameToId(EXCEPTIONS_OCCURED);
    }

    public void incDuplicateBatchesReceived() {
        this.stats.incInt(this.duplicateBatchesReceivedId, 1);
    }

    public int getDuplicateBatchesReceived() {
        return this.stats.getInt(this.duplicateBatchesReceivedId);
    }

    public void incOutoforderBatchesReceived() {
        this.stats.incInt(this.outoforderBatchesReceivedId, 1);
    }

    public int getOutoforderBatchesReceived() {
        return this.stats.getInt(this.outoforderBatchesReceivedId);
    }

    public void incEarlyAcks() {
        this.stats.incInt(this.earlyAcksId, 1);
    }

    public int getEarlyAcks() {
        return this.stats.getInt(this.earlyAcksId);
    }

    public void incEventsReceived(int delta) {
        this.stats.incInt(this.eventsReceivedId, delta);
    }

    public int getEventsReceived() {
        return this.stats.getInt(this.eventsReceivedId);
    }

    public void incCreateRequest() {
        this.stats.incInt(this.createRequestId, 1);
    }

    public int getCreateRequest() {
        return this.stats.getInt(this.createRequestId);
    }

    public void incUpdateRequest() {
        this.stats.incInt(this.updateRequestId, 1);
    }

    public int getUpdateRequest() {
        return this.stats.getInt(this.updateRequestId);
    }

    public void incDestroyRequest() {
        this.stats.incInt(this.destroyRequestId, 1);
    }

    public int getDestroyRequest() {
        return this.stats.getInt(this.destroyRequestId);
    }

    public void incUnknowsOperationsReceived() {
        this.stats.incInt(this.unknowsOperationsReceivedId, 1);
    }

    public int getUnknowsOperationsReceived() {
        return this.stats.getInt(this.unknowsOperationsReceivedId);
    }

    public void incExceptionsOccured() {
        this.stats.incInt(this.exceptionsOccuredId, 1);
    }

    public int getExceptionsOccured() {
        return this.stats.getInt(this.exceptionsOccuredId);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }
}

