/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.security.NotAuthorizedException;

public class UnregisterInterestList
extends BaseCommand {
    private static final UnregisterInterestList singleton = new UnregisterInterestList();

    public static Command getCommand() {
        return singleton;
    }

    private UnregisterInterestList() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part numberOfKeysPart = null;
        String regionName = null;
        Object key = null;
        List<Object> keys = null;
        int numberOfKeys = 0;
        int partNumber = 0;
        servConn.setAsTrue(2);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        Part isClosingListPart = msg.getPart(1);
        byte[] isClosingListPartBytes = (byte[])isClosingListPart.getObject();
        boolean isClosingList = isClosingListPartBytes[0] == 1;
        boolean keepalive = false;
        try {
            Part keepalivePart = msg.getPart(2);
            byte[] keepalivePartBytes = (byte[])keepalivePart.getObject();
            keepalive = keepalivePartBytes[0] == 1;
        }
        catch (Exception e) {
            UnregisterInterestList.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        numberOfKeysPart = msg.getPart(3);
        numberOfKeys = numberOfKeysPart.getInt();
        partNumber = 4;
        keys = new ArrayList<Object>();
        for (int i = 0; i < numberOfKeys; ++i) {
            keyPart = msg.getPart(partNumber + i);
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                UnregisterInterestList.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            keys.add(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for the following {} keys in region {}: {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)numberOfKeys, (Object)regionName, keys);
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.UnRegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_UNREGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.UnRegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)servConn.getName(), (Object)s);
            UnregisterInterestList.writeErrorResponse(msg, 23, s, servConn);
            servConn.setAsTrue(1);
            return;
        }
        try {
            this.securityService.authorizeRegionRead(regionName);
        }
        catch (NotAuthorizedException ex) {
            UnregisterInterestList.writeException(msg, ex, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
            try {
                UnregisterInterestOperationContext unregisterContext = authzRequest.unregisterInterestListAuthorize(regionName, keys);
                keys = (List)unregisterContext.getKey();
            }
            catch (NotAuthorizedException ex) {
                UnregisterInterestList.writeException(msg, ex, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        servConn.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, keys, isClosingList, servConn.getProxyID(), keepalive);
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent unregister interest response for the following {} keys in region {}: {}", (Object)servConn.getName(), (Object)numberOfKeys, (Object)regionName, keys);
        }
    }
}

