/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class RollbackCommand
extends BaseCommand {
    private static final RollbackCommand singleton = new RollbackCommand();

    public static Command getCommand() {
        return singleton;
    }

    private RollbackCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        servConn.setAsTrue(2);
        TXManagerImpl txMgr = (TXManagerImpl)servConn.getCache().getCacheTransactionManager();
        InternalDistributedMember client = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
        int uniqId = msg.getTransactionId();
        TXId txId = new TXId(client, uniqId);
        if (txMgr.isHostedTxRecentlyCompleted(txId) && logger.isDebugEnabled()) {
            logger.debug("TX: found a recently rolled back tx: {}", (Object)txId);
            this.sendRollbackReply(msg, servConn);
            txMgr.removeHostedTXState(txId);
            return;
        }
        TXStateProxy txState = txMgr.getTXState();
        try {
            if (txState != null) {
                txId = txState.getTxId();
                txMgr.rollback();
                this.sendRollbackReply(msg, servConn);
            } else {
                this.sendRollbackReply(msg, servConn);
            }
        }
        catch (Exception e) {
            RollbackCommand.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: removing tx state for {}", (Object)txId);
            }
            if (txId != null) {
                TXStateProxy proxy = txMgr.removeHostedTXState(txId);
                if (logger.isDebugEnabled()) {
                    logger.debug("TX: removed tx state proxy {}", (Object)proxy);
                }
            }
        }
    }

    private void sendRollbackReply(Message msg, ServerConnection servConn) throws IOException {
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
    }
}

