/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class RegisterInterest
extends BaseCommand {
    private static final RegisterInterest singleton = new RegisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        InterestResultPolicy policy = null;
        int interestType2 = msg.getPart(1).getInt();
        try {
            policy = (InterestResultPolicy)msg.getPart(2).getObject();
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = msg.getPart(3);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        keyPart = msg.getPart(4);
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean sendUpdatesAsInvalidates = false;
        if (msg.getNumberOfParts() > 5) {
            try {
                Part notifyPart = msg.getPart(5);
                byte[] notifyPartBytes = (byte[])notifyPart.getObject();
                sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
            }
            catch (Exception e) {
                RegisterInterest.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest request ({} bytes) from {} for region {} key {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            StringId message = null;
            if (key == null) {
                message = LocalizedStrings.RegisterInterest_THE_INPUT_KEY_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            if (regionName == null) {
                message = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            logger.warn("{}: {}", (Object)servConn.getName(), (Object)message.toLocalizedString());
            RegisterInterest.writeChunkedErrorResponse(msg, 21, message.toLocalizedString(), servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)servConn.getCache().getRegion(regionName);
        if (region == null) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RegisterInterest_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_REQUEST, new Object[]{servConn.getName(), regionName}));
        }
        try {
            if (interestType2 == 1) {
                this.securityService.authorizeRegionRead(regionName);
            } else {
                this.securityService.authorizeRegionRead(regionName, key.toString());
            }
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                RegisterInterestOperationContext registerContext = authzRequest.registerInterestAuthorize(regionName, key, interestType2, policy);
                key = registerContext.getKey();
            }
            servConn.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, key, servConn.getProxyID(), interestType2, isDurable, sendUpdatesAsInvalidates, false, 0, true);
        }
        catch (Exception e) {
            RegisterInterest.checkForInterrupt(servConn, e);
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        CacheClientProxy ccp = servConn.getAcceptor().getCacheClientNotifier().getClientProxy(servConn.getProxyID());
        if (ccp == null) {
            IOException ioex = new IOException(LocalizedStrings.RegisterInterest_CACHECLIENTPROXY_FOR_THIS_CLIENT_IS_NO_LONGER_ON_THE_SERVER_SO_REGISTERINTEREST_OPERATION_IS_UNSUCCESSFUL.toLocalizedString());
            RegisterInterest.writeChunkedException(msg, ioex, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isPrimary = ccp.isPrimary();
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        if (!isPrimary) {
            chunkedResponseMsg.setMessageType(33);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", (Object)servConn.getName(), (Object)regionName, key, (Object)chunkedResponseMsg);
            }
            chunkedResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(32);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            try {
                RegisterInterest.fillAndSendRegisterInterestResponseChunks(region, key, interestType2, policy, servConn);
                servConn.setAsTrue(1);
            }
            catch (Exception e) {
                RegisterInterest.writeChunkedException(msg, e, false, servConn, chunkedResponseMsg);
                servConn.setAsTrue(1);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent register interest response for region {} key {}", (Object)servConn.getName(), (Object)regionName, key);
            }
        }
    }
}

