/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.security.GemFireSecurityException;

public class PutUserCredentials
extends BaseCommand {
    private static final PutUserCredentials singleton = new PutUserCredentials();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        int numberOfParts;
        boolean isSecureMode = msg.isSecureMode();
        if (isSecureMode && (numberOfParts = msg.getNumberOfParts()) == 1) {
            try {
                servConn.setAsTrue(2);
                byte[] uniqueId = servConn.setCredentials(msg);
                PutUserCredentials.writeResponse(uniqueId, null, msg, false, servConn);
            }
            catch (GemFireSecurityException gfse) {
                if (servConn.getSecurityLogWriter().warningEnabled()) {
                    servConn.getSecurityLogWriter().warning(LocalizedStrings.ONE_ARG, servConn.getName() + ": Security exception: " + gfse.toString() + (gfse.getCause() != null ? ", caused by: " + gfse.getCause().toString() : ""));
                }
                PutUserCredentials.writeException(msg, gfse, false, servConn);
            }
            catch (Exception ex) {
                if (servConn.getLogWriter().warningEnabled()) {
                    servConn.getLogWriter().warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{servConn.getProxyID(), ""}, (Throwable)ex);
                }
                PutUserCredentials.writeException(msg, ex, false, servConn);
            }
            finally {
                servConn.setAsTrue(1);
            }
        }
    }
}

