/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;

public class Put65
extends BaseCommand {
    private static final Put65 singleton = new Put65();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long p_start) throws IOException, InterruptedException {
        Object oldValue;
        boolean oldValueIsObject;
        boolean sendOldValue;
        EventIDHolder clientEvent;
        LocalRegion region;
        boolean isDebugEnabled;
        CacheServerStats stats;
        Object key;
        String regionName;
        Part valuePart;
        long start;
        block84: {
            Operation operation;
            start = p_start;
            Part regionNamePart = null;
            Part keyPart = null;
            valuePart = null;
            Part callbackArgPart = null;
            regionName = null;
            Object callbackArg = null;
            key = null;
            Part eventPart = null;
            StringBuffer errMessage = new StringBuffer();
            boolean isDelta = false;
            CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
            stats = servConn.getCacheServerStats();
            servConn.setAsTrue(2);
            long oldStart = start;
            start = DistributionStats.getStatTime();
            stats.incReadPutRequestTime(start - oldStart);
            int idx = 0;
            regionNamePart = msg.getPart(idx++);
            try {
                operation = (Operation)msg.getPart(idx++).getObject();
                if (operation == null) {
                    operation = Operation.UPDATE;
                }
            }
            catch (ClassNotFoundException e) {
                Put65.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            int flags = msg.getPart(idx++).getInt();
            boolean requireOldValue = (flags & 1) == 1;
            boolean haveExpectedOldValue = (flags & 2) == 2;
            Object expectedOldValue = null;
            if (haveExpectedOldValue) {
                try {
                    expectedOldValue = msg.getPart(idx++).getObject();
                }
                catch (ClassNotFoundException e) {
                    Put65.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
            keyPart = msg.getPart(idx++);
            try {
                isDelta = (Boolean)msg.getPart(idx).getObject();
            }
            catch (Exception e) {
                Put65.writeException(msg, 70, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            int n = ++idx;
            valuePart = msg.getPart(n);
            int n2 = ++idx;
            eventPart = msg.getPart(n2);
            if (msg.getNumberOfParts() > ++idx) {
                callbackArgPart = msg.getPart(idx++);
                try {
                    callbackArg = callbackArgPart.getObject();
                }
                catch (Exception e) {
                    Put65.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
            regionName = regionNamePart.getString();
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                Put65.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("{}: Received {}put request ({} bytes) from {} for region {} key {} txId {} posdup: {}", (Object)servConn.getName(), (Object)(isDelta ? " delta " : " "), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName, key, (Object)msg.getTransactionId(), (Object)msg.isRetry());
            }
            if (key == null || regionName == null) {
                String putMsg;
                if (key == null) {
                    putMsg = " The input key for the put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)servConn.getName(), (Object)putMsg);
                    }
                    errMessage.append(putMsg);
                }
                if (regionName == null) {
                    putMsg = " The input region name for the put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)servConn.getName(), (Object)putMsg);
                    }
                    errMessage.append(putMsg);
                }
                Put65.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            region = (LocalRegion)servConn.getCache().getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                Put65.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            if (valuePart.isNull() && operation != Operation.PUT_IF_ABSENT && region.containsKey(key)) {
                String putMsg = " Attempted to put a null value for existing key " + key;
                if (isDebugEnabled) {
                    logger.debug("{}:{}", (Object)servConn.getName(), (Object)putMsg);
                }
                errMessage.append(putMsg);
                Put65.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            clientEvent = new EventIDHolder(new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId));
            Breadcrumbs.setEventId(clientEvent.getEventId());
            if (msg.isRetry()) {
                clientEvent.setPossibleDuplicate(true);
                if (region.getAttributes().getConcurrencyChecksEnabled()) {
                    clientEvent.setRegion(region);
                    if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                        clientEvent.setPossibleDuplicate(false);
                    }
                }
            }
            boolean result = false;
            sendOldValue = false;
            oldValueIsObject = true;
            oldValue = null;
            try {
                Version clientVersion;
                Object value = null;
                if (!isDelta) {
                    value = valuePart.getSerializedForm();
                }
                boolean isObject = valuePart.isObject();
                boolean isMetaRegion = region.isUsedForMetaRegion();
                msg.setMetaRegion(isMetaRegion);
                this.securityService.authorizeRegionWrite(regionName, key.toString());
                AuthorizeRequest authzRequest = null;
                if (!isMetaRegion) {
                    authzRequest = servConn.getAuthzRequest();
                }
                if (authzRequest != null) {
                    if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                        authzRequest.createRegionAuthorize((String)key);
                    } else {
                        PutOperationContext putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg);
                        value = putContext.getValue();
                        isObject = putContext.isObject();
                        callbackArg = putContext.getCallbackArg();
                    }
                }
                if (isDebugEnabled) {
                    logger.debug("processing put65 with operation={}", (Object)operation);
                }
                if (operation == Operation.PUT_IF_ABSENT) {
                    if (msg.isRetry() && clientEvent.getVersionTag() != null) {
                        if (isDebugEnabled) {
                            logger.debug("putIfAbsent operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        region.basicBridgePutIfAbsent(key, value, isObject, callbackArg, servConn.getProxyID(), true, clientEvent);
                        oldValue = null;
                    } else {
                        oldValue = region.basicBridgePutIfAbsent(key, value, isObject, callbackArg, servConn.getProxyID(), true, clientEvent);
                    }
                    sendOldValue = true;
                    oldValueIsObject = true;
                    clientVersion = servConn.getClientVersion();
                    if (oldValue instanceof CachedDeserializable) {
                        oldValue = ((CachedDeserializable)oldValue).getSerializedValue();
                    } else if (oldValue instanceof byte[]) {
                        oldValueIsObject = false;
                    } else if (oldValue instanceof Token && clientVersion.compareTo(Version.GFE_651) <= 0) {
                        HeapDataOutputStream str = new HeapDataOutputStream(Version.CURRENT);
                        DataOutputStream dstr = new DataOutputStream(str);
                        InternalDataSerializer.writeSerializableObject(oldValue, dstr);
                        oldValue = str.toByteArray();
                    }
                    result = true;
                } else if (operation == Operation.REPLACE) {
                    if (requireOldValue) {
                        if (msg.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null && isDebugEnabled) {
                            logger.debug("replace(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        oldValue = region.basicBridgeReplace(key, value, isObject, callbackArg, servConn.getProxyID(), true, clientEvent);
                        sendOldValue = !clientEvent.isConcurrencyConflict();
                        oldValueIsObject = true;
                        clientVersion = servConn.getClientVersion();
                        if (oldValue instanceof CachedDeserializable) {
                            oldValue = ((CachedDeserializable)oldValue).getSerializedValue();
                        } else if (oldValue instanceof byte[]) {
                            oldValueIsObject = false;
                        } else if (oldValue instanceof Token && clientVersion.compareTo(Version.GFE_651) <= 0) {
                            HeapDataOutputStream str = new HeapDataOutputStream(Version.CURRENT);
                            DataOutputStream dstr = new DataOutputStream(str);
                            InternalDataSerializer.writeSerializableObject(oldValue, dstr);
                            oldValue = str.toByteArray();
                        }
                        if (isDebugEnabled) {
                            logger.debug("returning {} from replace(K,V)", oldValue);
                        }
                        result = true;
                    } else {
                        boolean didPut = region.basicBridgeReplace(key, expectedOldValue, value, isObject, callbackArg, servConn.getProxyID(), true, clientEvent);
                        if (msg.isRetry() && clientEvent.getVersionTag() != null) {
                            if (isDebugEnabled) {
                                logger.debug("replace(k,v,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                            }
                            didPut = true;
                        }
                        sendOldValue = true;
                        oldValueIsObject = true;
                        Object object = oldValue = didPut ? Boolean.TRUE : Boolean.FALSE;
                        if (isDebugEnabled) {
                            logger.debug("returning {} from replace(K,V,V)", oldValue);
                        }
                        result = true;
                    }
                } else if (value == null && !isDelta) {
                    result = region.basicBridgeCreate(key, null, true, callbackArg, servConn.getProxyID(), true, clientEvent, false);
                    if (msg.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null) {
                        result = true;
                        if (isDebugEnabled) {
                            logger.debug("create(k,null) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                    }
                } else {
                    TXManagerImpl txMgr;
                    byte[] delta = null;
                    if (isDelta) {
                        delta = valuePart.getSerializedForm();
                    }
                    result = (txMgr = (TXManagerImpl)servConn.getCache().getCacheTransactionManager()).getTXState() != null && operation.isCreate() ? region.basicBridgeCreate(key, (byte[])value, isObject, callbackArg, servConn.getProxyID(), true, clientEvent, true) : region.basicBridgePut(key, value, delta, isObject, callbackArg, servConn.getProxyID(), true, clientEvent);
                    if (msg.isRetry() && clientEvent.isConcurrencyConflict() && clientEvent.getVersionTag() != null) {
                        if (isDebugEnabled) {
                            logger.debug("put(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        result = true;
                    }
                }
                if (result) {
                    servConn.setModificationInfo(true, regionName, key);
                    break block84;
                }
                String message = servConn.getName() + ": Failed to put entry for region " + regionName + " key " + key + " value " + valuePart;
                if (isDebugEnabled) {
                    logger.debug(message);
                }
                throw new Exception(message);
            }
            catch (RegionDestroyedException rde) {
                Put65.writeException(msg, rde, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            catch (ResourceException re) {
                Put65.writeException(msg, re, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            catch (InvalidDeltaException ide) {
                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.UpdateOperation_ERROR_APPLYING_DELTA_FOR_KEY_0_OF_REGION_1, new Object[]{key, regionName}));
                Put65.writeException(msg, 70, ide, false, servConn);
                servConn.setAsTrue(1);
                region.getCachePerfStats().incDeltaFullValuesRequested();
                return;
            }
            catch (Exception ce) {
                Put65.checkForInterrupt(servConn, ce);
                Put65.writeException(msg, ce, false, servConn);
                servConn.setAsTrue(1);
                if (ce instanceof GemFireSecurityException) {
                    if (isDebugEnabled) {
                        logger.debug("{}: Unexpected Security exception", (Object)servConn.getName(), (Object)ce);
                    }
                } else if (isDebugEnabled) {
                    logger.debug("{}: Unexpected Exception", (Object)servConn.getName(), (Object)ce);
                }
                return;
            }
            finally {
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessPutTime(start - oldStart2);
            }
        }
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(msg, servConn, pr, sendOldValue, oldValueIsObject, oldValue, pr.getNetworkHopType(), clientEvent.getVersionTag());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(msg, servConn, sendOldValue, oldValueIsObject, oldValue, clientEvent.getVersionTag());
            }
        } else {
            this.writeReply(msg, servConn, sendOldValue, oldValueIsObject, oldValue, clientEvent.getVersionTag());
        }
        servConn.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent put response back to {} for region {} key {} value {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)regionName, key, (Object)valuePart);
        }
        stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(sendOldValue ? 3 : 1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        if (sendOldValue) {
            replyMsg.addIntPart(oldValueIsObject ? 1 : 0);
            replyMsg.addObjPart(oldValue);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, byte nwHopType, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(sendOldValue ? 3 : 1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHopType});
        if (sendOldValue) {
            replyMsg.addIntPart(oldValueIsObject ? 1 : 0);
            replyMsg.addObjPart(oldValue);
        }
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

