/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.operations.KeySetOperationContext;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.security.NotAuthorizedException;

public class KeySet
extends BaseCommand {
    private static final KeySet singleton = new KeySet();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        String regionName = null;
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received key set request ({} bytes) from {} for region {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName);
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.KeySet_0_THE_INPUT_REGION_NAME_FOR_THE_KEY_SET_REQUEST_IS_NULL.toLocalizedString(servConn.getName());
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.KeySet_0_THE_INPUT_REGION_NAME_FOR_THE_KEY_SET_REQUEST_IS_NULL, servConn.getName()));
            KeySet.writeKeySetErrorResponse(msg, 41, message, servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)servConn.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.KeySet__0_WAS_NOT_FOUND_DURING_KEY_SET_REQUEST.toLocalizedString(regionName);
            KeySet.writeRegionDestroyedEx(msg, regionName, reason, servConn);
            servConn.setAsTrue(1);
            return;
        }
        try {
            this.securityService.authorizeRegionRead(regionName);
        }
        catch (NotAuthorizedException ex) {
            KeySet.writeChunkedException(msg, ex, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        KeySetOperationContext keySetContext = null;
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        if (authzRequest != null) {
            try {
                keySetContext = authzRequest.keySetAuthorize(regionName);
            }
            catch (NotAuthorizedException ex) {
                KeySet.writeChunkedException(msg, ex, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        chunkedResponseMsg.setMessageType(1);
        chunkedResponseMsg.setTransactionId(msg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        try {
            this.fillAndSendKeySetResponseChunks(region, regionName, keySetContext, servConn);
            servConn.setAsTrue(1);
        }
        catch (Exception e) {
            KeySet.checkForInterrupt(servConn, e);
            KeySet.writeChunkedException(msg, e, false, servConn, servConn.getChunkedResponseMessage());
            servConn.setAsTrue(1);
            return;
        }
        if (isDebugEnabled) {
            logger.debug("{}: Sent key set response for the region {}", (Object)servConn.getName(), (Object)regionName);
        }
    }

    private void fillAndSendKeySetResponseChunks(LocalRegion region, String regionName, KeySetOperationContext context, ServerConnection servConn) throws IOException {
        Set keySet = region.keys();
        KeySetOperationContext keySetContext = context;
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        if (postAuthzRequest != null) {
            keySetContext = postAuthzRequest.keySetAuthorize(regionName, keySet, keySetContext);
            keySet = keySetContext.getKeySet();
        }
        ArrayList keyList = new ArrayList(maximumChunkSize);
        boolean isTraceEnabled = logger.isTraceEnabled();
        for (Object entryKey : keySet) {
            keyList.add(entryKey);
            if (isTraceEnabled) {
                logger.trace("{}: fillAndSendKeySetResponseKey <{}>; list size was {}; region: {}", (Object)servConn.getName(), entryKey, (Object)keyList.size(), (Object)region.getFullPath());
            }
            if (keyList.size() != maximumChunkSize) continue;
            KeySet.sendKeySetResponseChunk(region, keyList, false, servConn);
            keyList.clear();
        }
        KeySet.sendKeySetResponseChunk(region, keyList, true, servConn);
    }

    private static void sendKeySetResponseChunk(Region region, List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} key set response chunk for region={}{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)region.getFullPath(), (Object)(logger.isTraceEnabled() ? " keys=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""));
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

