/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class ExecuteFunction
extends BaseCommand {
    private static final ExecuteFunction singleton = new ExecuteFunction();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        byte hasResult;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        block22: {
            function = null;
            args = null;
            memberMappedArg = null;
            hasResult = 0;
            try {
                hasResult = msg.getPart(0).getSerializedForm()[0];
                if (hasResult == 1) {
                    servConn.setAsTrue(2);
                    servConn.setAsTrue(3);
                }
                function = msg.getPart(1).getStringOrObject();
                args = msg.getPart(2).getObject();
                Part part = msg.getPart(3);
                if (part != null) {
                    memberMappedArg = (MemberMappedArgument)part.getObject();
                }
            }
            catch (ClassNotFoundException exception) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
                if (hasResult != 1) break block22;
                ExecuteFunction.writeChunkedException(msg, exception, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (function == null) {
            String message = LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", (Object)servConn.getName(), (Object)message);
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        try {
            Function functionObject = null;
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", (Object)servConn.getName(), (Object)message);
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStats.getFunctionStats(functionObject.getId());
            this.securityService.authorizeDataWrite();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage m = servConn.getFunctionResponseMessage();
            m.setTransactionId(msg.getTransactionId());
            ServerToClientFunctionResultSender resultSender = new ServerToClientFunctionResultSender(m, 63, servConn, functionObject, executeContext);
            InternalDistributedMember localVM = (InternalDistributedMember)servConn.getCache().getDistributedSystem().getDistributedMember();
            FunctionContextImpl context = null;
            context = memberMappedArg != null ? new FunctionContextImpl(functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender) : new FunctionContextImpl(functionObject.getId(), args, resultSender);
            HandShake handShake = (HandShake)servConn.getHandshake();
            int earlierClientReadTimeout = handShake.getClientReadTimeout();
            handShake.setClientReadTimeout(0);
            try {
                long startExecution = stats.startTime();
                stats.startFunctionExecution(functionObject.hasResult());
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: " + servConn.toString() + "with context :" + ((Object)context).toString());
                }
                GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
                HeapMemoryMonitor hmm = cache.getResourceManager().getHeapMonitor();
                if (functionObject.optimizeForWrite() && cache != null && hmm.getState().isCritical() && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
                    Set<DistributedMember> sm = Collections.singleton(cache.getMyId());
                    throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(functionObject.getId(), sm), sm);
                }
                functionObject.execute(context);
                stats.endFunctionExecution(startExecution, functionObject.hasResult());
            }
            catch (FunctionException functionException) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw functionException;
            }
            catch (Exception exception) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw new FunctionException(exception);
            }
            finally {
                handShake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException ioException) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioException);
            String message = LocalizedStrings.ExecuteFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, msg, message, servConn, ioException);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)internalfunctionException);
            }
            String message = internalfunctionException.getMessage();
            this.sendException(hasResult, msg, message, servConn, internalfunctionException);
        }
        catch (Exception e) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, msg, message, servConn, e);
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection servConn, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction.writeFunctionResponseException(msg, 2, message, servConn, e);
            servConn.setAsTrue(1);
        }
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection servConn) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction.writeFunctionResponseError(msg, 64, message, servConn);
            servConn.setAsTrue(1);
        }
    }
}

