/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.security.GemFireSecurityException;

public class Destroy
extends BaseCommand {
    private static final Destroy singleton = new Destroy();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startparam) throws IOException, InterruptedException {
        long start = startparam;
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        eventPart = msg.getPart(2);
        if (msg.getNumberOfParts() > 3) {
            callbackArgPart = msg.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy request ({} bytes) from {} for region {} key {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            Destroy.writeErrorResponse(msg, 10, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)servConn.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.Destroy__0_WAS_NOT_FOUND_DURING_DESTROY_REQUEST.toLocalizedString(regionName);
            Destroy.writeRegionDestroyedEx(msg, regionName, reason, servConn);
            servConn.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
        try {
            this.securityService.authorizeRegionWrite(regionName, key.toString());
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                } else {
                    DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                }
            }
            region.basicBridgeDestroy(key, callbackArg, servConn.getProxyID(), true, new EventIDHolder(eventId));
            servConn.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_DURING_ENTRY_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{servConn.getName(), key}));
        }
        catch (RegionDestroyedException rde) {
            Destroy.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Destroy.checkForInterrupt(servConn, e);
            Destroy.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)servConn.getName(), (Object)e);
                }
            } else {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Destroy_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
            }
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessDestroyTime(start - oldStart2);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(msg, servConn, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(msg, servConn);
            }
        } else {
            this.writeReply(msg, servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent destroy response for region {} key {}", (Object)servConn.getName(), (Object)regionName, key);
        }
        stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
    }
}

