/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import org.apache.geode.distributed.DistributedMember;

public class ServerQueueStatus {
    private int qSize = 0;
    private byte epType = 0;
    private DistributedMember memberId = null;
    private int pdxSize = 0;

    public ServerQueueStatus(DistributedMember memberId) {
        this(0, 0, memberId);
    }

    public ServerQueueStatus(byte epType, int qSize, DistributedMember memberId) {
        this.qSize = qSize;
        this.epType = epType;
        this.memberId = memberId;
    }

    public boolean isPrimary() {
        return this.epType == 2;
    }

    public boolean isRedundant() {
        return this.epType == 1;
    }

    public boolean isNonRedundant() {
        return this.epType == 0;
    }

    public int getServerQueueSize() {
        return this.qSize;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ServerQueueStatus [").append("qSize=").append(this.qSize).append("; epType=").append(this.getTypeAsString()).append("]");
        return buffer.toString();
    }

    protected String getTypeAsString() {
        String type = null;
        type = this.isNonRedundant() ? "NON_REDUNDANT" : (this.isRedundant() ? "REDUNDANT" : "PRIMARY");
        return type;
    }

    public int getPdxSize() {
        return this.pdxSize;
    }

    public void setPdxSize(int pdxSize) {
        this.pdxSize = pdxSize;
    }

    public DistributedMember getMemberId() {
        return this.memberId;
    }
}

