/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class RemoveClientFromBlacklistMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private ClientProxyMembershipID proxyID;

    @Override
    protected void process(DistributionManager dm) {
        List<CacheServer> l;
        try {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        }
        catch (Exception ignore) {
            InternalDistributedSystem ds = dm.getSystem();
            if (ds != null && logger.isTraceEnabled()) {
                logger.trace("The node does not contain cache & so QDM Message will return.", (Throwable)ignore);
            }
            return;
        }
        GemFireCacheImpl c = GemFireCacheImpl.getInstance();
        if (c != null && (l = c.getCacheServers()) != null) {
            for (CacheServerImpl cacheServerImpl : l) {
                InternalDistributedSystem ds;
                CacheClientNotifier ccn = cacheServerImpl.getAcceptor().getCacheClientNotifier();
                Set s = ccn.getBlacklistedClient();
                if (s == null || !s.remove(this.proxyID) || (ds = dm.getSystem()) == null || !logger.isDebugEnabled()) continue;
                logger.debug("Remove the client from black list as its queue is already destroyed: {}", (Object)this.proxyID);
            }
        }
    }

    public RemoveClientFromBlacklistMessage() {
        this.setRecipient(ALL_RECIPIENTS);
    }

    public void setProxyID(ClientProxyMembershipID proxyID) {
        this.proxyID = proxyID;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.proxyID, out);
    }

    @Override
    public int getDSFID() {
        return -44;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.proxyID = ClientProxyMembershipID.readCanonicalized(in);
    }
}

