/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.util.BlobHelper;

public class CacheServerHelper {
    public static void setIsDefaultServer(CacheServer server) {
        if (server instanceof CacheServerImpl) {
            ((CacheServerImpl)server).setIsDefaultServer();
        }
    }

    public static boolean isDefaultServer(CacheServer server) {
        if (!(server instanceof CacheServerImpl)) {
            return false;
        }
        return ((CacheServerImpl)server).isDefaultServer();
    }

    public static byte[] serialize(Object obj) throws IOException {
        return CacheServerHelper.serialize(obj, false);
    }

    public static byte[] serialize(Object obj, boolean zipObject) throws IOException {
        return zipObject ? CacheServerHelper.zip(obj) : BlobHelper.serializeToBlob(obj);
    }

    public static Object deserialize(byte[] blob) throws IOException, ClassNotFoundException {
        return CacheServerHelper.deserialize(blob, false);
    }

    public static Object deserialize(byte[] blob, boolean unzipObject) throws IOException, ClassNotFoundException {
        return unzipObject ? CacheServerHelper.unzip(blob) : BlobHelper.deserializeBlob(blob);
    }

    public static Object deserialize(byte[] blob, Version version, boolean unzipObject) throws IOException, ClassNotFoundException {
        return unzipObject ? CacheServerHelper.unzip(blob) : BlobHelper.deserializeBlob(blob, version, null);
    }

    public static byte[] zip(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(baos);
        ObjectOutputStream oos = new ObjectOutputStream(gz);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        byte[] blob = baos.toByteArray();
        return blob;
    }

    public static Object unzip(byte[] blob) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(blob);
        GZIPInputStream gs = new GZIPInputStream(bais);
        ObjectInputStream ois = new ObjectInputStream(gs);
        Object obj = ois.readObject();
        ois.close();
        bais.close();
        return obj;
    }

    public static byte[] toUTF(String s) {
        HeapDataOutputStream hdos = new HeapDataOutputStream(s);
        return hdos.toByteArray();
    }

    public static String fromUTF(byte[] bytearr) {
        int c;
        int count;
        int utflen = bytearr.length;
        int chararr_count = 0;
        char[] chararr = new char[utflen];
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new RuntimeException(LocalizedStrings.CacheServerHelper_UTF8_EXCEPTION.toLocalizedString(), new UTFDataFormatException("malformed input: partial character at end"));
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new RuntimeException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new RuntimeException(LocalizedStrings.CacheServerHelper_UTF8_EXCEPTION.toLocalizedString(), new UTFDataFormatException("malformed input: partial character at end"));
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new RuntimeException(LocalizedStrings.CacheServerHelper_UTF8_EXCEPTION.toLocalizedString(), new UTFDataFormatException("malformed input around byte " + (count - 1)));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new RuntimeException(LocalizedStrings.CacheServerHelper_UTF8_EXCEPTION.toLocalizedString(), new UTFDataFormatException("malformed input around byte " + count));
        }
        return new String(chararr, 0, chararr_count);
    }

    private CacheServerHelper() {
    }
}

