/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.persistence.BackupInspector;

class WindowsBackupInspector
extends BackupInspector {
    private static final String INCREMENTAL_MARKER = "rem Incremental backup";
    static final String RESTORE_FILE = "restore.bat";

    WindowsBackupInspector(File backupDir) throws IOException {
        super(backupDir);
    }

    @Override
    public String getCopyFromForOplogFile(String oplogFileName) {
        String copyFrom = null;
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (null != line) {
            String[] parts = line.split("\\s");
            copyFrom = parts[1].substring(1, parts[1].length() - 1) + File.separator + parts[3];
        }
        return copyFrom;
    }

    @Override
    public String getCopyToForOplogFile(String oplogFileName) {
        String copyTo = null;
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (null != line) {
            String[] parts = line.split("\\s");
            copyTo = parts[2].substring(1, parts[2].length() - 1) + File.separator + parts[3];
        }
        return copyTo;
    }

    @Override
    protected void parseOplogLines(BufferedReader reader) throws IOException {
        String line = null;
        String oplogName = "";
        while (null != (line = reader.readLine())) {
            if (line.startsWith("robocopy")) {
                int beginIndex = line.lastIndexOf("\"") + 2;
                int endIndex = line.indexOf("/njh", beginIndex) - 1;
                oplogName = line.substring(beginIndex, endIndex);
                this.oplogFileNames.add(oplogName);
                this.oplogLineMap.put(oplogName, line);
                continue;
            }
            if (line.startsWith("IF") || !line.contains("Exit Functions")) continue;
            break;
        }
    }

    @Override
    protected String getIncrementalMarker() {
        return INCREMENTAL_MARKER;
    }

    @Override
    protected File getRestoreFile(File backupDir) {
        return new File(backupDir, RESTORE_FILE);
    }
}

