/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.FileUtil;

public class RestoreScript {
    public static final String EXIT_MARKER = "Exit Functions";
    private static final ScriptGenerator UNIX_GENERATOR = new UnixScriptGenerator();
    private static final ScriptGenerator WINDOWS_GENERATOR = new WindowsScriptGenerator();
    private Map<File, File> baselineFiles = new HashMap<File, File>();
    private final Map<File, File> backedUpFiles = new LinkedHashMap<File, File>();
    private final List<File> existenceTests = new ArrayList<File>();

    public void addBaselineFiles(Map<File, File> baselineFiles) {
        this.baselineFiles.putAll(baselineFiles);
    }

    public void addFile(File originalFile, File backupFile) {
        this.backedUpFiles.put(backupFile, originalFile.getAbsoluteFile());
    }

    public void addExistenceTest(File originalFile) {
        this.existenceTests.add(originalFile.getAbsoluteFile());
    }

    public void generate(File outputDir) throws FileNotFoundException {
        if (this.isWindows()) {
            this.generateWindowsScript(outputDir);
        } else {
            this.generateUnixScript(outputDir);
        }
    }

    private void generateWindowsScript(File outputDir) throws FileNotFoundException {
        File outputFile = new File(outputDir, "restore.bat");
        this.generateScript(outputDir, outputFile, WINDOWS_GENERATOR);
    }

    private void generateUnixScript(File outputDir) throws FileNotFoundException {
        File outputFile = new File(outputDir, "restore.sh");
        this.generateScript(outputDir, outputFile, UNIX_GENERATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateScript(File outputDir, File outputFile, ScriptGenerator osGenerator) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(outputFile);){
            osGenerator.writePreamble(writer);
            writer.println();
            osGenerator.writeComment(writer, "Restore a backup of gemfire persistent data to the location it was backed up");
            osGenerator.writeComment(writer, "from.");
            osGenerator.writeComment(writer, "This script will refuse to restore if the original data still exists.");
            writer.println();
            osGenerator.writeComment(writer, "This script was automatically generated by the gemfire backup utility.");
            writer.println();
            osGenerator.writeComment(writer, "Test for existing originals. If they exist, do not restore the backup.");
            for (File file : this.existenceTests) {
                osGenerator.writeExistenceTest(writer, file);
            }
            writer.println();
            osGenerator.writeComment(writer, "Restore data");
            for (Map.Entry entry : this.backedUpFiles.entrySet()) {
                File backup = (File)entry.getKey();
                boolean backupHasFiles = backup.isDirectory() && backup.list().length != 0;
                backup = FileUtil.removeParent(outputDir, backup);
                File original = (File)entry.getValue();
                if (original.isDirectory()) {
                    osGenerator.writeCopyDirectoryContents(writer, backup, original, backupHasFiles);
                    continue;
                }
                osGenerator.writeCopyFile(writer, backup, original);
            }
            if (!this.baselineFiles.isEmpty()) {
                writer.println();
                osGenerator.writeComment(writer, "Incremental backup.  Restore baseline originals from previous backups.");
                for (Map.Entry entry : this.baselineFiles.entrySet()) {
                    osGenerator.writeCopyFile(writer, (File)entry.getKey(), (File)entry.getValue());
                }
            }
            if (this.isWindows()) {
                osGenerator.writeExit(writer);
            }
        }
        outputFile.setExecutable(true, true);
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.indexOf("Windows") != -1;
    }

    private static class UnixScriptGenerator
    implements ScriptGenerator {
        private UnixScriptGenerator() {
        }

        @Override
        public void writePreamble(PrintWriter writer) {
            writer.println("#!/bin/bash -e");
            writer.println("cd `dirname $0`");
        }

        @Override
        public void writeComment(PrintWriter writer, String string) {
            writer.println("#" + string);
        }

        @Override
        public void writeCopyDirectoryContents(PrintWriter writer, File backup, File original, boolean backupHasFiles) {
            writer.println("mkdir -p '" + original + "'");
            if (backupHasFiles) {
                writer.println("cp -rp '" + backup + "'/* '" + original + "'");
            }
        }

        @Override
        public void writeCopyFile(PrintWriter writer, File backup, File original) {
            writer.println("cp -p '" + backup + "' '" + original + "'");
        }

        @Override
        public void writeExistenceTest(PrintWriter writer, File file) {
            writer.println("test -e '" + file + "' && echo 'Backup not restored. Refusing to overwrite " + file + "' && exit 1 ");
        }

        @Override
        public void writeExit(PrintWriter writer) {
        }
    }

    private static class WindowsScriptGenerator
    implements ScriptGenerator {
        final String ERROR_CHECK = "IF %ERRORLEVEL% GEQ 4 GOTO Exit_Bad";

        private WindowsScriptGenerator() {
        }

        @Override
        public void writePreamble(PrintWriter writer) {
            writer.println("echo off");
        }

        @Override
        public void writeComment(PrintWriter writer, String string) {
            writer.println("rem " + string);
        }

        @Override
        public void writeCopyDirectoryContents(PrintWriter writer, File backup, File original, boolean backupHasFiles) {
            writer.println("mkdir \"" + original + "\"");
            writer.println("C:\\Windows\\System32\\Robocopy.exe \"" + backup + "\" \"" + original + "\" /e /njh /njs");
            writer.println("IF %ERRORLEVEL% GEQ 4 GOTO Exit_Bad");
        }

        @Override
        public void writeCopyFile(PrintWriter writer, File source, File destination) {
            String fileName = source.getName();
            String sourcePath = source.getParent() == null ? "." : source.getParent();
            String destinationPath = destination.getParent() == null ? "." : destination.getParent();
            writer.println("C:\\Windows\\System32\\Robocopy.exe \"" + sourcePath + "\" \"" + destinationPath + "\" " + fileName + " /njh /njs");
            writer.println("IF %ERRORLEVEL% GEQ 4 GOTO Exit_Bad");
        }

        @Override
        public void writeExistenceTest(PrintWriter writer, File file) {
            writer.println("IF EXIST \"" + file + "\" echo \"Backup not restored. Refusing to overwrite " + file + "\" && exit /B 1 ");
        }

        @Override
        public void writeExit(PrintWriter writer) {
            this.writeComment(writer, RestoreScript.EXIT_MARKER);
            writer.println(":Exit_Good\nexit /B 0\n\n:Exit_Bad\nexit /B 1");
        }
    }

    private static interface ScriptGenerator {
        public void writePreamble(PrintWriter var1);

        public void writeExit(PrintWriter var1);

        public void writeCopyFile(PrintWriter var1, File var2, File var3);

        public void writeCopyDirectoryContents(PrintWriter var1, File var2, File var3, boolean var4);

        public void writeExistenceTest(PrintWriter var1, File var2);

        public void writeComment(PrintWriter var1, String var2);
    }
}

