/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class RemovePersistentMemberMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private PersistentMemberID id;
    private int processorId;
    private PersistentMemberID initializingId;

    public RemovePersistentMemberMessage() {
    }

    public RemovePersistentMemberMessage(String regionPath, PersistentMemberID id, PersistentMemberID initializingId, int processorId) {
        this.regionPath = regionPath;
        this.id = id;
        this.initializingId = initializingId;
        this.processorId = processorId;
    }

    public static void send(Set<InternalDistributedMember> members, DM dm, String regionPath, PersistentMemberID id, PersistentMemberID initializingId) throws ReplyException {
        if (id == null && initializingId == null) {
            return;
        }
        ReplyProcessor21 processor = new ReplyProcessor21(dm, members);
        RemovePersistentMemberMessage msg = new RemovePersistentMemberMessage(regionPath, id, initializingId, processor.getProcessorId());
        msg.setRecipients(members);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        Object state = null;
        Object myId = null;
        ReplyException exception = null;
        try {
            Bucket proxy;
            Cache cache = CacheFactory.getInstance(dm.getSystem());
            Region region = cache.getRegion(this.regionPath);
            PersistenceAdvisor persistenceAdvisor = null;
            if (region instanceof DistributedRegion) {
                persistenceAdvisor = ((DistributedRegion)region).getPersistenceAdvisor();
            } else if (region == null && (proxy = PartitionedRegionHelper.getProxyBucketRegion(GemFireCacheImpl.getInstance(), this.regionPath, false)) != null) {
                persistenceAdvisor = proxy.getPersistenceAdvisor();
            }
            if (persistenceAdvisor != null) {
                if (this.id != null) {
                    persistenceAdvisor.removeMember(this.id);
                }
                if (this.initializingId != null) {
                    persistenceAdvisor.removeMember(this.initializingId);
                }
            }
        }
        catch (RegionDestroyedException e) {
            logger.debug("<RegionDestroyed> {}", (Object)this);
        }
        catch (CancelException e) {
            logger.debug("<CancelException> {}", (Object)this);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (exception != null) {
                replyMsg.setException(exception);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    @Override
    public int getDSFID() {
        return 2109;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean hasInitializingId;
        super.fromData(in);
        this.regionPath = DataSerializer.readString(in);
        this.processorId = in.readInt();
        boolean hasId = in.readBoolean();
        if (hasId) {
            this.id = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(this.id, in);
        }
        if (hasInitializingId = in.readBoolean()) {
            this.initializingId = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(this.initializingId, in);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeInt(this.processorId);
        out.writeBoolean(this.id != null);
        if (this.id != null) {
            InternalDataSerializer.invokeToData(this.id, out);
        }
        out.writeBoolean(this.initializingId != null);
        if (this.initializingId != null) {
            InternalDataSerializer.invokeToData(this.initializingId, out);
        }
    }
}

