/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.persistence.ConflictingPersistentDataException;
import org.apache.geode.cache.persistence.RevokedPersistentDataException;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.MembershipViewRequest;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistenceObserverHolder;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.persistence.PersistentMemberState;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;
import org.apache.geode.internal.cache.persistence.PersistentMembershipView;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryMessage;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryResults;
import org.apache.geode.internal.cache.persistence.PrepareNewPersistentMemberMessage;
import org.apache.geode.internal.cache.persistence.RemovePersistentMemberMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PersistenceAdvisorImpl
implements PersistenceAdvisor {
    private static final Logger logger = LogService.getLogger();
    protected CacheDistributionAdvisor advisor;
    private DistributedLockService dl;
    protected String regionPath;
    protected PersistentMemberView storage;
    protected volatile boolean online = false;
    private volatile Set<PersistentStateListener> listeners = Collections.emptySet();
    private DiskRegionStats stats;
    private PersistentMemberManager memberManager;
    private ProfileChangeListener listener;
    private volatile boolean initialized;
    private volatile boolean shouldUpdatePersistentView;
    protected volatile boolean isClosed;
    private volatile boolean holdingTieLock;
    private Set<PersistentMemberID> recoveredMembers;
    private Set<PersistentMemberID> removedMembers = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberID> equalMembers;
    private volatile Set<PersistentMemberID> allMembersWaitingFor;
    private volatile Set<PersistentMemberID> offlineMembersWaitingFor;
    protected final Object lock;
    private static final int PERSISTENT_VIEW_RETRY = Integer.getInteger("gemfire.PERSISTENT_VIEW_RETRY", 5);

    public PersistenceAdvisorImpl(CacheDistributionAdvisor advisor, DistributedLockService dl, PersistentMemberView storage, String regionPath, DiskRegionStats diskStats, PersistentMemberManager memberManager) {
        this.advisor = advisor;
        this.dl = dl;
        this.regionPath = regionPath;
        this.storage = storage;
        this.stats = diskStats;
        this.listener = new ProfileChangeListener();
        this.memberManager = memberManager;
        this.lock = advisor;
        this.recoveredMembers = this.getPersistedMembers();
        this.equalMembers = new HashSet<PersistentMemberID>(storage.getOfflineAndEqualMembers());
        for (PersistentMemberID id : this.equalMembers) {
            storage.memberOnline(id);
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.wasAboutToDestroy()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_FINISHING_INCOMPLETE_DESTROY, this.regionPath));
            this.finishPendingDestroy();
        }
        this.advisor.addProfileChangeListener(this.listener);
        HashSet<PersistentMemberPattern> revokedMembers = this.memberManager.addRevocationListener(this.listener, this.storage.getRevokedMembers());
        for (PersistentMemberPattern pattern : revokedMembers) {
            this.memberRevoked(pattern);
        }
        this.startMemberLogging();
        this.initialized = true;
    }

    protected void startMemberLogging() {
        this.addListener(new PersistentStateListener.PersistentStateAdapter(){

            @Override
            public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
                if (logger.isDebugEnabled()) {
                    HashSet onlineMembers = new HashSet();
                    HashSet<PersistentMemberID> members = new HashSet<PersistentMemberID>();
                    members.addAll(PersistenceAdvisorImpl.this.advisor.adviseInitializedPersistentMembers().values());
                    members.remove(persistentID);
                    TransformUtils.transform(members, onlineMembers, TransformUtils.persistentMemberIdToLogEntryTransformer);
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_PERSISTENT_VIEW, new Object[]{PersistenceAdvisorImpl.this.regionPath, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(persistentID), onlineMembers}));
                }
            }
        });
    }

    @Override
    public boolean acquireTieLock() {
        this.holdingTieLock = this.dl.lock("PERSISTENCE_" + this.regionPath, 0L, -1L);
        return this.holdingTieLock;
    }

    @Override
    public void releaseTieLock() {
        if (this.holdingTieLock) {
            this.dl.unlock("PERSISTENCE_" + this.regionPath);
            this.holdingTieLock = false;
        }
    }

    @Override
    public PersistentStateQueryResults getMyStateOnMembers(Set<InternalDistributedMember> members) throws ReplyException {
        PersistentStateQueryResults results = PersistentStateQueryMessage.send(members, this.advisor.getDistributionManager(), this.regionPath, this.storage.getMyPersistentID(), this.storage.getMyInitializingID());
        return results;
    }

    @Override
    public PersistentMemberState getPersistedStateOfMember(PersistentMemberID id) {
        if (this.isRevoked(id)) {
            return PersistentMemberState.REVOKED;
        }
        if (this.equalMembers != null && this.equalMembers.contains(id)) {
            return PersistentMemberState.EQUAL;
        }
        for (PersistentMemberID online : this.storage.getOnlineMembers()) {
            if (!online.isOlderOrEqualVersionOf(id)) continue;
            return PersistentMemberState.ONLINE;
        }
        for (PersistentMemberID offline : this.storage.getOfflineMembers()) {
            if (!id.isOlderOrEqualVersionOf(offline)) continue;
            return PersistentMemberState.OFFLINE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMembershipView(InternalDistributedMember replicate, boolean targetReinitializing) {
        this.beginUpdatingPersistentView();
        DM dm = this.advisor.getDistributionManager();
        PersistentMembershipView view = MembershipViewRequest.send(replicate, dm, this.regionPath, targetReinitializing);
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Updating persistent view from {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)replicate);
        }
        Object object = this.lock;
        synchronized (object) {
            PersistentMemberID myId = this.getPersistentID();
            Map<InternalDistributedMember, PersistentMemberID> peersOnlineMembers = view.getOnlineMembers();
            Set<PersistentMemberID> peersOfflineMembers = view.getOfflineMembers();
            for (PersistentMemberID id : peersOnlineMembers.values()) {
                if (this.isRevoked(id) || this.removedMembers.contains(id) || id.equals(myId) || this.recoveredMembers.remove(id) || id.diskStoreId.equals(this.getDiskStoreID())) continue;
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Processing membership view from peer. Marking {} as online because {} says its online", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)replicate);
                }
                this.storage.memberOnline(id);
            }
            for (PersistentMemberID id : peersOfflineMembers) {
                if (this.isRevoked(id) || this.removedMembers.contains(id) || id.equals(myId) || this.recoveredMembers.remove(id) || id.diskStoreId.equals(this.getDiskStoreID())) continue;
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Processing membership view from peer. Marking {} as online because {} says its offline, but we have never seen it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)replicate);
                }
                this.storage.memberOnline(id);
            }
            for (PersistentMemberID id : this.recoveredMembers) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Processing membership view from peer. Removing {} because {} doesn't have it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id, (Object)replicate);
                }
                this.storage.memberRemoved(id);
            }
        }
        Set<PersistentMemberPattern> revokedMembers = view.getRevokedMembers();
        for (PersistentMemberPattern revoked : revokedMembers) {
            this.memberManager.revokeMember(revoked);
        }
    }

    protected boolean isRevoked(PersistentMemberID id) {
        return this.memberManager.isRevoked(this.regionPath, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnline(boolean didGII, boolean atomicCreation, PersistentMemberID newId) throws ReplyException {
        if (this.online) {
            return;
        }
        if (!didGII) {
            this.setInitializing(newId);
        }
        Object object = this.lock;
        synchronized (object) {
            HashSet<PersistentMemberID> membersToMarkOffline = new HashSet<PersistentMemberID>(this.storage.getOnlineMembers());
            Map<InternalDistributedMember, PersistentMemberID> onlineMembers = !atomicCreation ? this.advisor.adviseInitializedPersistentMembers() : this.advisor.advisePersistentMembers();
            membersToMarkOffline.removeAll(onlineMembers.values());
            if (this.equalMembers != null && !this.equalMembers.isEmpty()) {
                Collection<PersistentMemberID> allMembers = this.advisor.advisePersistentMembers().values();
                HashSet<DiskStoreID> runningDiskStores = new HashSet<DiskStoreID>();
                for (PersistentMemberID mem : allMembers) {
                    runningDiskStores.add(mem.diskStoreId);
                }
                Iterator<PersistentMemberID> itr = this.equalMembers.iterator();
                while (itr.hasNext()) {
                    PersistentMemberID id = itr.next();
                    if (runningDiskStores.contains(id.diskStoreId)) continue;
                    itr.remove();
                }
                membersToMarkOffline.removeAll(this.equalMembers);
            }
            for (PersistentMemberID id : membersToMarkOffline) {
                this.storage.memberOffline(id);
            }
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Persisting the new membership view and ID as online. Online members {}. Offline members {}. Equal memebers {}.", (Object)this.shortDiskStoreId(), (Object)this.regionPath, this.storage.getOnlineMembers(), this.storage.getOfflineMembers(), this.equalMembers);
            }
            this.storage.setInitialized();
            this.online = true;
            this.removedMembers = Collections.emptySet();
        }
        if (this.stats != null) {
            this.stats.incInitializations(!didGII);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginUpdatingPersistentView() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shouldUpdatePersistentView) {
                this.shouldUpdatePersistentView = true;
                Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.advisor.adviseInitializedPersistentMembers();
                for (Map.Entry<InternalDistributedMember, PersistentMemberID> entry : onlineMembers.entrySet()) {
                    this.memberOnline(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInitializing(PersistentMemberID newId) {
        this.beginUpdatingPersistentView();
        DM dm = this.advisor.getDistributionManager();
        PersistentMemberID oldId = this.getPersistentID();
        PersistentMemberID initializingId = this.getInitializingID();
        Set profileUpdateRecipients = this.advisor.adviseProfileUpdate();
        if (newId == null || !newId.equals(oldId) && !newId.equals(initializingId)) {
            if (initializingId != null) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: We still have an initializing id: {}. Telling peers to remove the old id {} and transitioning this initializing id to old id. recipients {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)initializingId, (Object)oldId, (Object)profileUpdateRecipients);
                }
                long viewVersion = this.advisor.startOperation();
                try {
                    PrepareNewPersistentMemberMessage.send(profileUpdateRecipients, dm, this.regionPath, oldId, initializingId);
                }
                finally {
                    if (viewVersion != -1L) {
                        this.advisor.endOperation(viewVersion);
                    }
                }
                oldId = initializingId;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Persisting my new persistent ID {}", (Object)newId);
            }
            this.storage.setInitializing(newId);
        }
        profileUpdateRecipients = this.advisor.adviseProfileUpdate();
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Sending the new ID to peers. They should remove the old id {}. Recipients: {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)oldId, (Object)profileUpdateRecipients);
        }
        if (newId != null) {
            PrepareNewPersistentMemberMessage.send(profileUpdateRecipients, dm, this.regionPath, oldId, newId);
        }
    }

    @Override
    public PersistentMemberID generatePersistentID() {
        return this.storage.generatePersistentID();
    }

    @Override
    public PersistentMembershipView getMembershipView() {
        if (!this.initialized) {
            return null;
        }
        Set<PersistentMemberID> offlineMembers = this.getPersistedMembers();
        Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.advisor.adviseInitializedPersistentMembers();
        offlineMembers.removeAll(onlineMembers.values());
        PersistentMemberID myId = this.getPersistentID();
        if (myId != null) {
            onlineMembers.put(this.advisor.getDistributionManager().getDistributionManagerId(), myId);
        }
        PersistentMembershipView view = new PersistentMembershipView(offlineMembers, onlineMembers, this.memberManager.getRevokedMembers());
        return view;
    }

    @Override
    public Set<PersistentMemberID> getPersistedMembers() {
        Set<PersistentMemberID> offlineMembers = this.storage.getOfflineMembers();
        Set<PersistentMemberID> equalMembers = this.storage.getOfflineAndEqualMembers();
        Set<PersistentMemberID> onlineMembers = this.storage.getOnlineMembers();
        HashSet<PersistentMemberID> persistentMembers = new HashSet<PersistentMemberID>();
        persistentMembers.addAll(offlineMembers);
        persistentMembers.addAll(equalMembers);
        persistentMembers.addAll(onlineMembers);
        return persistentMembers;
    }

    @Override
    public PersistentMemberID getPersistentIDIfOnline() {
        if (this.online) {
            return this.storage.getMyPersistentID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberOffline(InternalDistributedMember distributedMember, PersistentMemberID persistentID) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Member offine. id={}, persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)distributedMember, (Object)persistentID);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean foundMember = false;
            foundMember |= this.recoveredMembers.remove(persistentID);
            foundMember |= this.equalMembers.remove(persistentID);
            foundMember |= this.getPersistedMembers().contains(persistentID);
            if (this.shouldUpdatePersistentView && this.online) {
                try {
                    if (this.storage.getOfflineAndEqualMembers().contains(persistentID)) {
                        return;
                    }
                    if (foundMember) {
                        if (PersistenceObserverHolder.getInstance().memberOffline(this.regionPath, persistentID)) {
                            this.storage.memberOffline(persistentID);
                        }
                        PersistenceObserverHolder.getInstance().afterPersistedOffline(this.regionPath, persistentID);
                    }
                }
                catch (DiskAccessException e) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_UNABLE_TO_PERSIST_MEMBERSHIP_CHANGE), (Throwable)e);
                }
            }
            this.notifyListenersMemberOffline(distributedMember, persistentID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberOnline(InternalDistributedMember distributedMember, PersistentMemberID persistentID) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Sending the new ID to peers.  Member online. id={}, persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)distributedMember, (Object)persistentID);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldUpdatePersistentView) {
                this.recoveredMembers.remove(persistentID);
                try {
                    if (PersistenceObserverHolder.getInstance().memberOnline(this.regionPath, persistentID)) {
                        this.storage.memberOnline(persistentID);
                    }
                    PersistenceObserverHolder.getInstance().afterPersistedOnline(this.regionPath, persistentID);
                }
                catch (DiskAccessException e) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_UNABLE_TO_PERSIST_MEMBERSHIP_CHANGE), (Throwable)e);
                }
            } else if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Not marking member online in persistent view because we're still in initialization", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
            }
            this.notifyListenersMemberOnline(distributedMember, persistentID);
        }
    }

    private void memberRevoked(PersistentMemberPattern pattern) {
        this.storage.memberRevoked(pattern);
        for (PersistentMemberID id : this.storage.getOfflineMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
        for (PersistentMemberID id : this.storage.getOnlineMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
        for (PersistentMemberID id : this.storage.getOfflineAndEqualMembers()) {
            if (!pattern.matches(id)) continue;
            this.memberRemoved(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberRemoved(PersistentMemberID id, boolean revoked) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Member removed. persistentID={}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
        }
        Object object = this.lock;
        synchronized (object) {
            this.recoveredMembers.remove(id);
            this.equalMembers.remove(id);
            if (!this.online) {
                this.removedMembers.add(id);
            }
            try {
                if (PersistenceObserverHolder.getInstance().memberRemoved(this.regionPath, id)) {
                    this.storage.memberRemoved(id);
                }
                for (PersistentMemberID persistedId : this.getPersistedMembers()) {
                    if (!persistedId.isOlderOrEqualVersionOf(id)) continue;
                    this.storage.memberRemoved(persistedId);
                }
                PersistenceObserverHolder.getInstance().afterRemovePersisted(this.regionPath, id);
            }
            catch (DiskAccessException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_UNABLE_TO_PERSIST_MEMBERSHIP_CHANGE), (Throwable)e);
            }
            this.notifyListenersMemberRemoved(id, revoked);
        }
    }

    @Override
    public PersistentMemberID getPersistentID() {
        return this.storage.getMyPersistentID();
    }

    @Override
    public PersistentMemberID getInitializingID() {
        return this.storage.getMyInitializingID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PersistentStateListener listener) {
        PersistenceAdvisorImpl persistenceAdvisorImpl = this;
        synchronized (persistenceAdvisorImpl) {
            HashSet<PersistentStateListener> tmpListeners = new HashSet<PersistentStateListener>(this.listeners);
            tmpListeners.add(listener);
            this.listeners = Collections.unmodifiableSet(tmpListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PersistentStateListener listener) {
        PersistenceAdvisorImpl persistenceAdvisorImpl = this;
        synchronized (persistenceAdvisorImpl) {
            HashSet<PersistentStateListener> tmpListeners = new HashSet<PersistentStateListener>(this.listeners);
            tmpListeners.remove(listener);
            this.listeners = Collections.unmodifiableSet(tmpListeners);
        }
    }

    private void notifyListenersMemberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        for (PersistentStateListener listener : this.listeners) {
            listener.memberOnline(member, persistentID);
        }
    }

    private void notifyListenersMemberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        for (PersistentStateListener listener : this.listeners) {
            listener.memberOffline(member, persistentID);
        }
    }

    private void notifyListenersMemberRemoved(PersistentMemberID persistentID, boolean revoked) {
        for (PersistentStateListener listener : this.listeners) {
            listener.memberRemoved(persistentID, revoked);
        }
    }

    @Override
    public HashSet<PersistentMemberID> getPersistedOnlineOrEqualMembers() {
        HashSet<PersistentMemberID> members = new HashSet<PersistentMemberID>(this.storage.getOnlineMembers());
        members.addAll(this.equalMembers);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareNewMember(InternalDistributedMember sender, PersistentMemberID oldId, PersistentMemberID newId) {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
            logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Preparing new persistent id {}. Old id is {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)newId, (Object)oldId);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.advisor.containsId(sender)) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Refusing to prepare id because {} is not in our advisor", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)sender);
                }
                return;
            }
            this.storage.memberOnline(newId);
            if (oldId != null && !oldId.equals(newId) && this.initialized) {
                this.memberRemoved(oldId, false);
            }
        }
    }

    protected String shortDiskStoreId() {
        DiskStoreID diskStoreID = this.getDiskStoreID();
        return diskStoreID == null ? "mem" : diskStoreID.abbrev();
    }

    @Override
    public void removeMember(PersistentMemberID id) {
        this.memberRemoved(id, false);
    }

    @Override
    public void markMemberOffline(InternalDistributedMember member, PersistentMemberID id) {
        this.memberOffline(member, id);
    }

    public void setWaitingOnMembers(Set<PersistentMemberID> allMembersToWaitFor, Set<PersistentMemberID> offlineMembersToWaitFor) {
        this.allMembersWaitingFor = allMembersToWaitFor;
        this.offlineMembersWaitingFor = offlineMembersToWaitFor;
    }

    @Override
    public boolean checkMyStateOnMembers(Set<InternalDistributedMember> replicates) throws ReplyException {
        PersistentStateQueryResults remoteStates = this.getMyStateOnMembers(replicates);
        boolean equal = false;
        for (Map.Entry<InternalDistributedMember, PersistentMemberState> entry : remoteStates.stateOnPeers.entrySet()) {
            PersistentMemberState remoteState;
            InternalDistributedMember member = entry.getKey();
            PersistentMemberID remoteId = remoteStates.persistentIds.get(member);
            PersistentMemberID myId = this.getPersistentID();
            PersistentMemberState stateOnPeer = entry.getValue();
            if (PersistentMemberState.REVOKED.equals((Object)stateOnPeer)) {
                throw new RevokedPersistentDataException(LocalizedStrings.PersistentMemberManager_Member_0_is_already_revoked.toLocalizedString(myId));
            }
            if (myId != null && stateOnPeer == null) {
                String message = LocalizedStrings.CreatePersistentRegionProcessor_SPLIT_DISTRIBUTED_SYSTEM.toLocalizedString(this.regionPath, member, remoteId, myId);
                throw new ConflictingPersistentDataException(message);
            }
            if (myId != null && stateOnPeer == PersistentMemberState.EQUAL) {
                equal = true;
            }
            if (remoteId == null || (remoteState = this.getPersistedStateOfMember(remoteId)) != PersistentMemberState.OFFLINE) continue;
            String message = LocalizedStrings.CreatePersistentRegionProcessor_INITIALIZING_FROM_OLD_DATA.toLocalizedString(this.regionPath, member, remoteId, myId);
            throw new ConflictingPersistentDataException(message);
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishPendingDestroy() {
        long viewVersion = this.advisor.startOperation();
        try {
            RemovePersistentMemberMessage.send(this.advisor.adviseProfileUpdate(), this.advisor.getDistributionManager(), this.regionPath, this.getPersistentID(), this.getInitializingID());
            this.storage.finishPendingDestroy();
        }
        finally {
            if (viewVersion != -1L) {
                this.advisor.endOperation(viewVersion);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.recoveredMembers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CacheDistributionAdvisor.InitialImageAdvice getInitialImageAdvice(CacheDistributionAdvisor.InitialImageAdvice previousAdvice, boolean recoverFromDisk) {
        isPersistAdvisorDebubEnabled = PersistenceAdvisorImpl.logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR);
        listener = new MembershipChangeListener();
        this.advisor.addMembershipAndProxyListener(listener);
        this.addListener(listener);
        while (true) {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            previouslyOnlineMembers = this.getPersistedOnlineOrEqualMembers();
                            this.advisor.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                            advice = this.advisor.adviseInitialImage(previousAdvice, true);
                            if (advice.getReplicates().isEmpty()) break block29;
                            if (isPersistAdvisorDebubEnabled) {
                                PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: There are members currently online. Checking for our state on those members and then initializing", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                            }
                            if (recoverFromDisk) {
                                if (this.checkMyStateOnMembers(advice.getReplicates())) {
                                    if (isPersistAdvisorDebubEnabled) {
                                        PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: We have the same data on disk as one of {} recovering gracefully", (Object)this.shortDiskStoreId(), (Object)this.regionPath, advice.getReplicates());
                                    }
                                    advice.getReplicates().clear();
                                } else {
                                    var7_8 = this.lock;
                                    synchronized (var7_8) {
                                        this.equalMembers.clear();
                                    }
                                }
                            }
                            var7_8 = advice;
                            this.advisor.removeMembershipAndProxyListener(listener);
                            this.removeListener(listener);
                            return var7_8;
                        }
                        if (!advice.getNonPersistent().isEmpty()) {
                            this.updateViewFromNonPersistent(recoverFromDisk, advice);
                            previouslyOnlineMembers = this.getPersistedOnlineOrEqualMembers();
                        }
                        if (previousAdvice != null && !previousAdvice.getReplicates().isEmpty()) {
                            PersistenceAdvisorImpl.logger.info((Message)LocalizedMessage.create(LocalizedStrings.PersistenceAdvisorImpl_RETRYING_GII));
                            previousAdvice = null;
                            continue;
                        }
                        if (!previouslyOnlineMembers.isEmpty()) break block30;
                        if (isPersistAdvisorDebubEnabled) {
                            PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: No previously online members. Recovering with the data from the local disk", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                        }
                        var7_8 = advice;
                        this.advisor.removeMembershipAndProxyListener(listener);
                        this.removeListener(listener);
                        return var7_8;
                    }
                    offlineMembers = new HashSet<PersistentMemberID>();
                    membersToWaitFor = this.getMembersToWaitFor(previouslyOnlineMembers, offlineMembers);
                    if (!membersToWaitFor.isEmpty()) ** GOTO lbl73
                    if (isPersistAdvisorDebubEnabled) {
                        PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: All of the previously online members are now online and waiting for us. Acquiring tie lock. Previously online members {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, advice.getReplicates());
                    }
                    if (!this.acquireTieLock()) break block31;
                    advice = this.advisor.adviseInitialImage(previousAdvice, true);
                    if (isPersistAdvisorDebubEnabled) {
                        PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Acquired the lock. This member will initialize", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                    }
                    if (!advice.getReplicates().isEmpty()) {
                        if (isPersistAdvisorDebubEnabled) {
                            PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Another member has initialized while we were getting the lock. We will initialize from that member", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                        }
                        this.checkMyStateOnMembers(advice.getReplicates());
                    }
                    var9_11 = advice;
                    this.advisor.removeMembershipAndProxyListener(listener);
                    this.removeListener(listener);
                    return var9_11;
                }
                if (isPersistAdvisorDebubEnabled) {
                    PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Failed to acquire the lock.", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                }
                break block32;
lbl73:
                // 1 sources

                if (isPersistAdvisorDebubEnabled) {
                    PersistenceAdvisorImpl.logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Going to wait for these member ids: {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, membersToWaitFor);
                }
            }
            this.beginWaitingForMembershipChange(membersToWaitFor);
            try {
                listener.waitForChange(membersToWaitFor, offlineMembers);
                continue;
            }
            finally {
                this.endWaitingForMembershipChange();
            }
            {
                catch (InterruptedException e) {
                    PersistenceAdvisorImpl.logger.debug("Interrupted while trying to determine latest persisted copy: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            continue;
            break;
        }
        catch (Throwable var11_13) {
            this.advisor.removeMembershipAndProxyListener(listener);
            this.removeListener(listener);
            throw var11_13;
        }
    }

    public void updateViewFromNonPersistent(boolean recoverFromDisk, CacheDistributionAdvisor.InitialImageAdvice advice) {
        for (InternalDistributedMember replicate : advice.getNonPersistent()) {
            try {
                this.updateMembershipView(replicate, recoverFromDisk);
                return;
            }
            catch (ReplyException e) {
                if (!logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) continue;
                logger.debug(LogMarker.PERSIST_ADVISOR, "Failed to update membership view", (Throwable)e);
            }
        }
    }

    public Set<PersistentMemberID> getMembersToWaitFor(Set<PersistentMemberID> previouslyOnlineMembers, Set<PersistentMemberID> offlineMembers) throws ReplyException, InterruptedException {
        PersistentMemberID myPersistentID = this.getPersistentID();
        PersistentMemberID myInitializingId = this.getInitializingID();
        HashSet<PersistentMemberID> membersToWaitFor = new HashSet<PersistentMemberID>(previouslyOnlineMembers);
        offlineMembers.addAll(previouslyOnlineMembers);
        if (myPersistentID != null || myInitializingId != null) {
            InternalDistributedMember memberId;
            Set members = this.advisor.adviseProfileUpdate();
            Set<InternalDistributedMember> membersHostingThisRegion = this.advisor.adviseGeneric();
            PersistentStateQueryResults results = PersistentStateQueryMessage.send(members, this.advisor.getDistributionManager(), this.regionPath, myPersistentID, myInitializingId);
            boolean addedMembers = true;
            while (addedMembers) {
                addedMembers = false;
                for (Map.Entry<InternalDistributedMember, Object> entry : results.onlineMemberMap.entrySet()) {
                    memberId = entry.getKey();
                    Set peersOnlineMembers = (Set)entry.getValue();
                    PersistentMemberID persistentID = results.persistentIds.get(memberId);
                    PersistentMemberID initializingID = results.initializingIds.get(memberId);
                    if (!membersToWaitFor.contains(persistentID) && !membersToWaitFor.contains(initializingID)) continue;
                    for (PersistentMemberID peerOnlineMember : peersOnlineMembers) {
                        if (this.isRevoked(peerOnlineMember) || peerOnlineMember.diskStoreId.equals(this.getDiskStoreID()) || this.storage.getOfflineMembers().contains(peerOnlineMember) || !membersToWaitFor.add(peerOnlineMember)) continue;
                        addedMembers = true;
                        this.storage.memberOnline(peerOnlineMember);
                        if (!logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) continue;
                        logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Adding {} to the list of members we're wait for, because {} has newer or equal data than is and is waiting for that member", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)peerOnlineMember, (Object)memberId);
                    }
                }
            }
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Initial state of membersToWaitFor, before pruning {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, membersToWaitFor);
            }
            for (Map.Entry<InternalDistributedMember, Object> entry : results.stateOnPeers.entrySet()) {
                memberId = entry.getKey();
                PersistentMemberID persistentID = results.persistentIds.get(memberId);
                PersistentMemberID initializingID = results.initializingIds.get(memberId);
                DiskStoreID diskStoreID = results.diskStoreIds.get(memberId);
                PersistentMemberState state = (PersistentMemberState)((Object)entry.getValue());
                if (PersistentMemberState.REVOKED.equals((Object)state)) {
                    throw new RevokedPersistentDataException(LocalizedStrings.PersistentMemberManager_Member_0_is_already_revoked.toLocalizedString(myPersistentID));
                }
                if (membersHostingThisRegion.contains(memberId) && persistentID != null && state != null && myInitializingId == null && (state.equals((Object)PersistentMemberState.ONLINE) || state.equals((Object)PersistentMemberState.EQUAL))) {
                    if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                        logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Not waiting for {} because it thinks our state was {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)persistentID, (Object)state);
                    }
                    this.removeNewerPersistentID(membersToWaitFor, persistentID);
                }
                if (persistentID != null) {
                    this.removeNewerPersistentID(offlineMembers, persistentID);
                }
                if (membersHostingThisRegion.contains(memberId) && initializingID != null && state != null && (state.equals((Object)PersistentMemberState.ONLINE) || state.equals((Object)PersistentMemberState.EQUAL))) {
                    if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                        logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Not waiting for {} because it thinks our state was {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)initializingID, (Object)state);
                    }
                    this.removeNewerPersistentID(membersToWaitFor, initializingID);
                }
                if (initializingID != null) {
                    this.removeNewerPersistentID(offlineMembers, initializingID);
                }
                if (initializingID != null || !(persistentID == null & diskStoreID != null)) continue;
                this.removeByDiskStoreID(membersToWaitFor, diskStoreID);
                this.removeByDiskStoreID(offlineMembers, diskStoreID);
            }
        }
        return membersToWaitFor;
    }

    private void removeNewerPersistentID(Set<PersistentMemberID> membersToWaitFor, PersistentMemberID persistentID) {
        Iterator<PersistentMemberID> itr = membersToWaitFor.iterator();
        while (itr.hasNext()) {
            PersistentMemberID id = itr.next();
            if (!persistentID.isOlderOrEqualVersionOf(id)) continue;
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Not waiting for {} because local member knows more about it", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
            }
            itr.remove();
        }
    }

    private void removeByDiskStoreID(Set<PersistentMemberID> membersToWaitFor, DiskStoreID diskStoreID) {
        Iterator<PersistentMemberID> itr = membersToWaitFor.iterator();
        while (itr.hasNext()) {
            PersistentMemberID id = itr.next();
            if (!id.diskStoreId.equals(diskStoreID)) continue;
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR)) {
                logger.debug(LogMarker.PERSIST_ADVISOR, "{}-{}: Not waiting for {} because it no longer has this region in it's disk store", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)id);
            }
            itr.remove();
            this.memberRemoved(id, false);
        }
    }

    protected void beginWaitingForMembershipChange(Set<PersistentMemberID> membersToWaitFor) {
    }

    protected void endWaitingForMembershipChange() {
    }

    @Override
    public boolean wasHosting() {
        return this.getPersistentID() != null || this.getInitializingID() != null;
    }

    protected String getRegionPathForOfflineMembers() {
        return this.regionPath;
    }

    protected Set<PersistentMemberID> getMissingMembers() {
        return this.offlineMembersWaitingFor;
    }

    public Set<PersistentMemberID> getAllMembersToWaitFor() {
        return this.allMembersWaitingFor;
    }

    protected void logWaitingForMember(Set<PersistentMemberID> allMembersToWaitFor, Set<PersistentMemberID> offlineMembersToWaitFor) {
        HashSet membersToWaitForLogEntries = new HashSet();
        if (offlineMembersToWaitFor != null && !offlineMembersToWaitFor.isEmpty()) {
            TransformUtils.transform(offlineMembersToWaitFor, membersToWaitForLogEntries, TransformUtils.persistentMemberIdToLogEntryTransformer);
            StartupStatus.startup(LocalizedStrings.CreatePersistentRegionProcessor_WAITING_FOR_LATEST_MEMBER, new Object[]{this.regionPath, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.getPersistentID()), membersToWaitForLogEntries});
        } else {
            TransformUtils.transform(allMembersToWaitFor, membersToWaitForLogEntries, TransformUtils.persistentMemberIdToLogEntryTransformer);
            StartupStatus.startup(LocalizedStrings.CreatePersistentRegionProcessor_WAITING_FOR_ONLINE_LATEST_MEMBER, new Object[]{this.regionPath, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.getPersistentID()), membersToWaitForLogEntries});
        }
    }

    protected void checkInterruptedByShutdownAll() {
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.memberManager.removeRevocationListener(this.listener);
        this.advisor.removeProfileChangeListener(this.listener);
        this.releaseTieLock();
    }

    private boolean wasAboutToDestroy() {
        return this.storage.wasAboutToDestroy() || this.storage.wasAboutToDestroyDataStorage();
    }

    protected synchronized void resetState() {
        this.online = false;
        this.removedMembers = new HashSet<PersistentMemberID>();
    }

    public void flushMembershipChanges() {
        try {
            this.advisor.waitForCurrentOperations();
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Override
    public void persistMembersOfflineAndEqual(Map<InternalDistributedMember, PersistentMemberID> map) {
        for (PersistentMemberID persistentID : map.values()) {
            this.storage.memberOfflineAndEqual(persistentID);
        }
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return this.storage.getDiskStoreID();
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    private class ProfileChangeListener
    implements ProfileListener,
    PersistentMemberManager.MemberRevocationListener {
        private ProfileChangeListener() {
        }

        @Override
        public void profileCreated(DistributionAdvisor.Profile profile) {
            this.profileUpdated(profile);
        }

        @Override
        public void profileRemoved(DistributionAdvisor.Profile profile, boolean regionDestroyed) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (cp.persistentID != null) {
                if (regionDestroyed) {
                    PersistenceAdvisorImpl.this.memberRemoved(cp.persistentID, false);
                } else {
                    PersistenceAdvisorImpl.this.memberOffline(profile.getDistributedMember(), cp.persistentID);
                }
            }
        }

        @Override
        public void profileUpdated(DistributionAdvisor.Profile profile) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (cp.persistentID != null && cp.persistenceInitialized) {
                PersistenceAdvisorImpl.this.memberOnline(profile.getDistributedMember(), cp.persistentID);
            }
        }

        @Override
        public void revoked(PersistentMemberPattern pattern) {
            PersistenceAdvisorImpl.this.memberRevoked(pattern);
        }

        @Override
        public Set<PersistentMemberID> getMissingMemberIds() {
            return PersistenceAdvisorImpl.this.getMissingMembers();
        }

        @Override
        public String getRegionPath() {
            return PersistenceAdvisorImpl.this.getRegionPathForOfflineMembers();
        }

        @Override
        public boolean matches(PersistentMemberPattern pattern) {
            return pattern.matches(PersistenceAdvisorImpl.this.getPersistentID()) || pattern.matches(PersistenceAdvisorImpl.this.getInitializingID());
        }

        @Override
        public void addPersistentIDs(Set<PersistentMemberID> localData) {
            PersistentMemberID id = PersistenceAdvisorImpl.this.getPersistentID();
            if (id != null) {
                localData.add(id);
            }
            if ((id = PersistenceAdvisorImpl.this.getInitializingID()) != null) {
                localData.add(id);
            }
        }
    }

    protected class MembershipChangeListener
    implements MembershipListener,
    PersistentStateListener {
        private boolean warned = false;
        private final long warningTime;
        private boolean membershipChanged = false;

        public MembershipChangeListener() {
            long waitThreshold = PersistenceAdvisorImpl.this.advisor.getDistributionManager().getConfig().getAckWaitThreshold();
            this.warningTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(waitThreshold);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForChange(Set<PersistentMemberID> allMembersToWaitFor, Set<PersistentMemberID> offlineMembersToWaitFor) throws InterruptedException {
            MembershipChangeListener membershipChangeListener = this;
            synchronized (membershipChangeListener) {
                try {
                    PersistenceAdvisorImpl.this.setWaitingOnMembers(allMembersToWaitFor, offlineMembersToWaitFor);
                    long exitTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(PERSISTENT_VIEW_RETRY);
                    while (!this.membershipChanged && !PersistenceAdvisorImpl.this.isClosed) {
                        PersistenceAdvisorImpl.this.checkInterruptedByShutdownAll();
                        PersistenceAdvisorImpl.this.advisor.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                        this.wait(100L);
                        long time = System.nanoTime();
                        if (time > exitTime) break;
                        if (this.warned || time <= this.warningTime) continue;
                        PersistenceAdvisorImpl.this.logWaitingForMember(allMembersToWaitFor, offlineMembersToWaitFor);
                        this.warned = true;
                    }
                    this.membershipChanged = false;
                }
                finally {
                    PersistenceAdvisorImpl.this.setWaitingOnMembers(null, null);
                }
            }
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
            this.afterMembershipChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void afterMembershipChange() {
            MembershipChangeListener membershipChangeListener = this;
            synchronized (membershipChangeListener) {
                this.membershipChanged = true;
                this.notifyAll();
            }
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            this.afterMembershipChange();
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
            this.afterMembershipChange();
        }

        @Override
        public void memberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
            this.afterMembershipChange();
        }

        @Override
        public void memberRemoved(PersistentMemberID id, boolean revoked) {
            this.afterMembershipChange();
        }
    }
}

