/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.lru;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEvictorTask;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.logging.log4j.Logger;

public class HeapEvictor
implements ResourceListener<MemoryEvent> {
    private static final Logger logger = LogService.getLogger();
    public static final int MAX_EVICTOR_THREADS = Integer.getInteger("gemfire.HeapLRUCapacityController.MAX_EVICTOR_THREADS", Runtime.getRuntime().availableProcessors() * 4) + 1;
    public static final boolean DISABLE_HEAP_EVICTIOR_THREAD_POOL = Boolean.getBoolean("gemfire.HeapLRUCapacityController.DISABLE_HEAP_EVICTIOR_THREAD_POOL");
    public static final boolean EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST = Boolean.valueOf(System.getProperty("gemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst", "true"));
    public static final int MINIMUM_ENTRIES_PER_BUCKET = Integer.getInteger("gemfire.HeapLRUCapacityController.inlineEvictionThreshold", 0);
    public static final long TOTAL_BYTES_TO_EVICT_FROM_HEAP;
    public static final int BUCKET_SORTING_INTERVAL;
    private static final String EVICTOR_THREAD_GROUP_NAME = "EvictorThreadGroup";
    private static final String EVICTOR_THREAD_NAME = "EvictorThread";
    private ThreadPoolExecutor evictorThreadPool = null;
    private AtomicBoolean mustEvict = new AtomicBoolean(false);
    protected final Cache cache;
    private final ArrayList testTaskSetSizes = new ArrayList();
    public volatile int testAbortAfterLoopCount = Integer.MAX_VALUE;
    private BlockingQueue<Runnable> poolQueue;
    private AtomicBoolean isRunning = new AtomicBoolean(true);
    protected volatile int numEvictionLoopsCompleted = 0;
    protected volatile int numFastLoops;
    private long previousBytesUsed;
    private final Object evictionLock = new Object();

    public HeapEvictor(Cache gemFireCache) {
        this.cache = gemFireCache;
        this.initializeEvictorThreadPool();
    }

    protected boolean includePartitionedRegion(PartitionedRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getDataStore() != null && !region.getAttributes().getOffHeap();
    }

    protected boolean includeLocalRegion(LocalRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && !region.getAttributes().getOffHeap();
    }

    private List<LocalRegion> getAllRegionList() {
        ArrayList<LocalRegion> allRegionList = new ArrayList<LocalRegion>();
        InternalResourceManager irm = (InternalResourceManager)this.cache.getResourceManager();
        for (ResourceListener listener : irm.getResourceListeners(this.getResourceType())) {
            LocalRegion lr;
            if (listener instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)listener;
                if (!this.includePartitionedRegion(pr)) continue;
                allRegionList.addAll(pr.getDataStore().getAllLocalBucketRegions());
                continue;
            }
            if (!(listener instanceof LocalRegion) || !this.includeLocalRegion(lr = (LocalRegion)listener)) continue;
            allRegionList.add(lr);
        }
        if (MINIMUM_ENTRIES_PER_BUCKET > 0) {
            Iterator iter = allRegionList.iterator();
            while (iter.hasNext()) {
                LocalRegion lr = (LocalRegion)iter.next();
                if (!(lr instanceof BucketRegion) || ((BucketRegion)lr).getNumEntriesInVM() > (long)MINIMUM_ENTRIES_PER_BUCKET) continue;
                iter.remove();
            }
        }
        return allRegionList;
    }

    private List<LocalRegion> getAllSortedRegionList() {
        List<LocalRegion> allRegionList = this.getAllRegionList();
        final Object2LongOpenHashMap sizes = new Object2LongOpenHashMap(allRegionList.size());
        for (LocalRegion r : allRegionList) {
            long size = r instanceof BucketRegion ? (long)((BucketRegion)r).getSizeForEviction() : (long)r.size();
            sizes.put((Object)r, size);
        }
        Collections.sort(allRegionList, new Comparator<LocalRegion>(){

            @Override
            public int compare(LocalRegion r1, LocalRegion r2) {
                long numEntries2;
                long numEntries1 = sizes.get((Object)r1);
                if (numEntries1 > (numEntries2 = sizes.get((Object)r2).longValue())) {
                    return -1;
                }
                if (numEntries1 < numEntries2) {
                    return 1;
                }
                return 0;
            }
        });
        return allRegionList;
    }

    public GemFireCacheImpl getGemFireCache() {
        return (GemFireCacheImpl)this.cache;
    }

    private void initializeEvictorThreadPool() {
        final LoggingThreadGroup evictorThreadGroup = LoggingThreadGroup.createThreadGroup(this.getEvictorThreadGroupName(), logger);
        ThreadFactory evictorThreadFactory = new ThreadFactory(){
            private int next = 0;

            @Override
            public Thread newThread(Runnable command) {
                Thread t = new Thread(evictorThreadGroup, command, HeapEvictor.this.getEvictorThreadName() + this.next++);
                t.setDaemon(true);
                return t;
            }
        };
        if (!DISABLE_HEAP_EVICTIOR_THREAD_POOL) {
            this.poolQueue = new OverflowQueueWithDMStats(this.getGemFireCache().getCachePerfStats().getEvictionQueueStatHelper());
            this.evictorThreadPool = new ThreadPoolExecutor(MAX_EVICTOR_THREADS, MAX_EVICTOR_THREADS, 15L, TimeUnit.SECONDS, this.poolQueue, evictorThreadFactory);
        }
    }

    private void submitRegionEvictionTask(Callable<Object> task) {
        this.evictorThreadPool.submit(task);
    }

    public ThreadPoolExecutor getEvictorThreadPool() {
        if (this.isRunning.get()) {
            return this.evictorThreadPool;
        }
        return null;
    }

    public int getRunningAndScheduledTasks() {
        if (this.isRunning.get()) {
            return this.evictorThreadPool.getActiveCount() + this.evictorThreadPool.getQueue().size();
        }
        return -1;
    }

    private void createAndSubmitWeightedRegionEvictionTasks() {
        List<LocalRegion> allRegionList = this.getAllSortedRegionList();
        float numEntriesInVm = 0.0f;
        for (LocalRegion lr : allRegionList) {
            if (lr instanceof BucketRegion) {
                numEntriesInVm += (float)((BucketRegion)lr).getSizeForEviction();
                continue;
            }
            numEntriesInVm += (float)lr.getRegionMap().sizeInVM();
        }
        for (LocalRegion lr : allRegionList) {
            ArrayList<LocalRegion> regionsForSingleTask = new ArrayList<LocalRegion>(1);
            float regionEntryCnt = 0.0f;
            regionEntryCnt = lr instanceof BucketRegion ? (float)((BucketRegion)lr).getSizeForEviction() : (float)lr.getRegionMap().sizeInVM();
            float percentage = regionEntryCnt / numEntriesInVm;
            long bytesToEvictPerTask = (long)((float)this.getTotalBytesToEvict() * percentage);
            regionsForSingleTask.add(lr);
            if (!this.mustEvict()) break;
            this.submitRegionEvictionTask(new RegionEvictorTask(regionsForSingleTask, this, bytesToEvictPerTask));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<Callable<Object>> createRegionEvictionTasks() {
        HashSet<Callable<Object>> evictorTaskSet = new HashSet<Callable<Object>>();
        int threadsAvailable = this.getEvictorThreadPool().getCorePoolSize();
        long bytesToEvictPerTask = this.getTotalBytesToEvict() / (long)threadsAvailable;
        List<LocalRegion> allRegionList = this.getAllRegionList();
        Collections.shuffle(allRegionList);
        int allRegionSetSize = allRegionList.size();
        if (allRegionList.isEmpty()) {
            return evictorTaskSet;
        }
        if (allRegionSetSize <= threadsAvailable) {
            for (LocalRegion localRegion : allRegionList) {
                ArrayList<LocalRegion> regionList = new ArrayList<LocalRegion>(1);
                regionList.add(localRegion);
                RegionEvictorTask task = new RegionEvictorTask(regionList, this, bytesToEvictPerTask);
                evictorTaskSet.add(task);
            }
            for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
                this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
            }
            return evictorTaskSet;
        }
        int numRegionsInTask = allRegionSetSize / threadsAvailable;
        Object var8_11 = null;
        Iterator<LocalRegion> itr = allRegionList.iterator();
        for (int i = 0; i < threadsAvailable; ++i) {
            ArrayList<LocalRegion> arrayList = new ArrayList<LocalRegion>(numRegionsInTask);
            for (int j = 1; j <= numRegionsInTask; ++j) {
                if (!itr.hasNext()) continue;
                arrayList.add(itr.next());
            }
            evictorTaskSet.add(new RegionEvictorTask(arrayList, this, bytesToEvictPerTask));
        }
        while (itr.hasNext()) {
            void var8_12;
            var8_12.add(itr.next());
        }
        for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
            this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
        }
        return evictorTaskSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(MemoryEvent event) {
        if (DISABLE_HEAP_EVICTIOR_THREAD_POOL) {
            return;
        }
        if (this.isRunning.get() && event.isLocal()) {
            if (event.getState().isEviction()) {
                final LogWriter logWriter = this.cache.getLogger();
                if (this.mustEvict.get()) {
                    if (logWriter.fineEnabled()) {
                        logWriter.fine("Updating eviction in response to memory event: " + event + ". previousBytesUsed=" + this.previousBytesUsed);
                    }
                    Object object = this.evictionLock;
                    synchronized (object) {
                        this.numEvictionLoopsCompleted = 0;
                        this.numFastLoops = (int)((event.getBytesUsed() - event.getThresholds().getEvictionThresholdClearBytes() + this.getTotalBytesToEvict()) / this.getTotalBytesToEvict());
                        this.evictionLock.notifyAll();
                    }
                    return;
                }
                if (!this.mustEvict.compareAndSet(false, true)) {
                    return;
                }
                this.numEvictionLoopsCompleted = 0;
                this.numFastLoops = (int)((event.getBytesUsed() - event.getThresholds().getEvictionThresholdClearBytes() + this.getTotalBytesToEvict()) / this.getTotalBytesToEvict());
                if (logWriter.fineEnabled()) {
                    logWriter.fine("Starting eviction in response to memory event: " + event);
                }
                Runnable evictionManagerTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            if (HeapEvictor.this.numEvictionLoopsCompleted < HeapEvictor.this.testAbortAfterLoopCount) {
                                try {
                                    if (EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
                                        HeapEvictor.this.createAndSubmitWeightedRegionEvictionTasks();
                                    } else {
                                        for (Callable task : HeapEvictor.this.createRegionEvictionTasks()) {
                                            HeapEvictor.this.submitRegionEvictionTask(task);
                                        }
                                    }
                                    RegionEvictorTask.setLastTaskCompletionTime(System.currentTimeMillis());
                                    Object object = HeapEvictor.this.evictionLock;
                                    synchronized (object) {
                                        int delayTime = HeapEvictor.this.getEvictionLoopDelayTime();
                                        if (logWriter.fineEnabled()) {
                                            logWriter.fine("Eviction loop delay time calculated to be " + delayTime + " milliseconds. Fast Loops=" + HeapEvictor.this.numFastLoops + ", Loop #=" + HeapEvictor.this.numEvictionLoopsCompleted + 1);
                                        }
                                        ++HeapEvictor.this.numEvictionLoopsCompleted;
                                        try {
                                            HeapEvictor.this.evictionLock.wait(delayTime);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (HeapEvictor.this.mustEvict.get()) {
                                        HeapEvictor.this.evictorThreadPool.submit(this);
                                    }
                                }
                                catch (RegionDestroyedException e) {
                                    if (!HeapEvictor.this.mustEvict.get()) break block13;
                                    HeapEvictor.this.evictorThreadPool.submit(this);
                                }
                            }
                        }
                    }
                };
                this.evictorThreadPool.submit(evictionManagerTask);
            } else {
                this.mustEvict.set(false);
            }
        }
    }

    protected int getEvictionLoopDelayTime() {
        int delayTime = 850;
        if (this.numEvictionLoopsCompleted - this.numFastLoops > 2) {
            delayTime = 3000;
        } else if (this.numEvictionLoopsCompleted >= this.numFastLoops) {
            delayTime = (this.numEvictionLoopsCompleted - this.numFastLoops + 3) * 500;
        }
        return delayTime;
    }

    public boolean mustEvict() {
        return this.mustEvict.get();
    }

    public void close() {
        this.getEvictorThreadPool().shutdownNow();
        this.isRunning.set(false);
    }

    public ArrayList testOnlyGetSizeOfTasks() {
        if (this.isRunning.get()) {
            return this.testTaskSetSizes;
        }
        return null;
    }

    protected String getEvictorThreadGroupName() {
        return EVICTOR_THREAD_GROUP_NAME;
    }

    protected String getEvictorThreadName() {
        return EVICTOR_THREAD_NAME;
    }

    public long getTotalBytesToEvict() {
        return TOTAL_BYTES_TO_EVICT_FROM_HEAP;
    }

    protected InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.HEAP_MEMORY;
    }

    static {
        BUCKET_SORTING_INTERVAL = Integer.getInteger("gemfire.HeapLRUCapacityController.higherEntryCountBucketCalculationInterval", 100);
        float evictionBurstPercentage = Float.parseFloat(System.getProperty("gemfire.HeapLRUCapacityController.evictionBurstPercentage", "0.4"));
        long maxTenuredBytes = HeapMemoryMonitor.getTenuredPoolMaxMemory();
        TOTAL_BYTES_TO_EVICT_FROM_HEAP = (long)((double)maxTenuredBytes * 0.01 * (double)evictionBurstPercentage);
    }
}

