/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.internal.locks.DLockBatch;
import org.apache.geode.distributed.internal.locks.DLockBatchId;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.IdentityArrayList;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.cache.locks.TXLockIdImpl;

public final class TXLockBatch
implements DLockBatch,
DataSerializableFixedID {
    private TXLockIdImpl txLockId;
    private List reqs;
    private Set participants;

    public TXLockBatch(TXLockId txLockId, List reqs, Set participants) {
        this.txLockId = (TXLockIdImpl)txLockId;
        this.reqs = reqs;
        this.participants = participants;
    }

    @Override
    public InternalDistributedMember getOwner() {
        return this.txLockId.getMemberId();
    }

    public TXLockId getTXLockId() {
        return this.txLockId;
    }

    @Override
    public DLockBatchId getBatchId() {
        return this.txLockId;
    }

    public void setParticipants(Set participants) {
        this.participants = participants;
    }

    @Override
    public void grantedBy(LockGrantorId lockGrantorId) {
        this.txLockId.setLockGrantorId(lockGrantorId);
    }

    @Override
    public List getReqs() {
        if (this.reqs != null && !(this.reqs instanceof IdentityArrayList)) {
            this.reqs = new IdentityArrayList(this.reqs);
        }
        return this.reqs;
    }

    public String toString() {
        return "[TXLockBatch: txLockId=" + this.txLockId + "; reqs=" + this.reqs + "; participants=" + this.participants + "]";
    }

    public Set getParticipants() {
        return this.participants;
    }

    public TXLockBatch() {
    }

    @Override
    public int getDSFID() {
        return -58;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.txLockId = TXLockIdImpl.createFromData(in);
        this.participants = InternalDataSerializer.readSet(in);
        int reqsSize = in.readInt();
        if (reqsSize >= 0) {
            this.reqs = new IdentityArrayList(reqsSize);
            for (int i = 0; i < reqsSize; ++i) {
                this.reqs.add(TXRegionLockRequestImpl.createFromData(in));
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.invokeToData(this.txLockId, out);
        InternalDataSerializer.writeSet(this.participants, out);
        if (this.reqs == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.reqs.size());
            for (TXRegionLockRequestImpl elem : this.reqs) {
                InternalDataSerializer.invokeToData(elem, out);
            }
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

