/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;

public class RegionFunctionContextImpl
extends FunctionContextImpl
implements InternalRegionFunctionContext {
    private final Region dataSet;
    private final Set<?> filter;
    private final Map<String, LocalDataSet> colocatedLocalDataMap;
    private final Set<Integer> localBucketSet;
    private final boolean isPossibleDuplicate;

    public RegionFunctionContextImpl(String functionId, Region dataSet, Object args, Set<?> routingObjects, Map<String, LocalDataSet> colocatedLocalDataMap, Set<Integer> localBucketSet, ResultSender<?> resultSender, boolean isPossibleDuplicate) {
        super(functionId, args, resultSender);
        this.dataSet = dataSet;
        this.filter = routingObjects;
        this.colocatedLocalDataMap = colocatedLocalDataMap;
        this.localBucketSet = localBucketSet;
        this.isPossibleDuplicate = isPossibleDuplicate;
        this.setFunctionContexts();
    }

    private void setFunctionContexts() {
        if (this.colocatedLocalDataMap != null) {
            for (LocalDataSet ls : this.colocatedLocalDataMap.values()) {
                ls.setFunctionContext(this);
            }
        }
    }

    @Override
    public <K, V> Region<K, V> getDataSet() {
        return this.dataSet;
    }

    @Override
    public Set<?> getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[RegionFunctionContextImpl:");
        buf.append("dataSet=");
        buf.append(this.dataSet);
        buf.append(";filter=");
        buf.append(this.filter);
        buf.append(";args=");
        buf.append(this.getArguments());
        buf.append(']');
        return buf.toString();
    }

    public Region getLocalDataSet(Region r) {
        if (this.colocatedLocalDataMap != null) {
            return this.colocatedLocalDataMap.get(r.getFullPath());
        }
        return null;
    }

    @Override
    public Map<String, LocalDataSet> getColocatedLocalDataSets() {
        if (this.colocatedLocalDataMap != null) {
            HashMap<String, LocalDataSet> ret = new HashMap<String, LocalDataSet>(this.colocatedLocalDataMap);
            ret.remove(this.dataSet.getFullPath());
            return Collections.unmodifiableMap(ret);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.isPossibleDuplicate;
    }

    @Override
    public <K, V> Set<Integer> getLocalBucketSet(Region<K, V> region) {
        if (!region.getAttributes().getDataPolicy().withPartitioning()) {
            return null;
        }
        return this.localBucketSet;
    }
}

