/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class FunctionExecutionNodePruner {
    public static final Logger logger = LogService.getLogger();

    public static HashMap<InternalDistributedMember, HashSet<Integer>> pruneNodes(PartitionedRegion pr, Set<Integer> buckets) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The buckets to be pruned are: {}", buckets);
        }
        HashMap<InternalDistributedMember, HashSet> nodeToBucketsMap = new HashMap<InternalDistributedMember, HashSet>();
        HashMap<InternalDistributedMember, HashSet<Integer>> prunedNodeToBucketsMap = new HashMap<InternalDistributedMember, HashSet<Integer>>();
        try {
            for (Integer bucketId : buckets) {
                Set<InternalDistributedMember> nodes = pr.getRegionAdvisor().getBucketOwners(bucketId);
                if (isDebugEnabled) {
                    logger.debug("FunctionExecutionNodePruner: The buckets owners of the bucket: {} are: {}", (Object)bucketId, nodes);
                }
                for (InternalDistributedMember node : nodes) {
                    HashSet bucketSet;
                    if (nodeToBucketsMap.get(node) == null) {
                        bucketSet = new HashSet();
                        bucketSet.add(bucketId);
                        nodeToBucketsMap.put(node, bucketSet);
                        continue;
                    }
                    bucketSet = (HashSet)nodeToBucketsMap.get(node);
                    bucketSet.add(bucketId);
                    nodeToBucketsMap.put(node, bucketSet);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The node to buckets map is: {}", nodeToBucketsMap);
        }
        HashSet<Integer> currentBucketSet = new HashSet<Integer>();
        InternalDistributedMember localNode = pr.getRegionAdvisor().getDistributionManager().getId();
        if (nodeToBucketsMap.get(localNode) != null) {
            HashSet bucketSet = (HashSet)nodeToBucketsMap.get(localNode);
            if (isDebugEnabled) {
                logger.debug("FunctionExecutionNodePruner: Adding the node: {} which is lcoal and buckets {} to prunedMap", (Object)localNode, (Object)bucketSet);
            }
            currentBucketSet.addAll(bucketSet);
            prunedNodeToBucketsMap.put(localNode, bucketSet);
            nodeToBucketsMap.remove(localNode);
        }
        while (!currentBucketSet.equals(buckets) && nodeToBucketsMap.size() != 0) {
            InternalDistributedMember node = FunctionExecutionNodePruner.findNextNode(nodeToBucketsMap.entrySet(), currentBucketSet);
            if (node == null) {
                if (!isDebugEnabled) break;
                logger.debug("FunctionExecutionNodePruner: Breaking out of prunedMap calculation due to no available nodes for remaining buckets");
                break;
            }
            HashSet bucketSet = (HashSet)nodeToBucketsMap.get(node);
            bucketSet.removeAll(currentBucketSet);
            if (!bucketSet.isEmpty()) {
                currentBucketSet.addAll(bucketSet);
                prunedNodeToBucketsMap.put(node, bucketSet);
                if (isDebugEnabled) {
                    logger.debug("FunctionExecutionNodePruner: Adding the node: {} and buckets {} to prunedMap", (Object)node, (Object)bucketSet);
                }
            }
            nodeToBucketsMap.remove(node);
        }
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The final prunedNodeToBucket calculated is: {}", prunedNodeToBucketsMap);
        }
        return prunedNodeToBucketsMap;
    }

    private static InternalDistributedMember findNextNode(Set<Map.Entry<InternalDistributedMember, HashSet<Integer>>> entrySet, HashSet<Integer> currentBucketSet) {
        InternalDistributedMember node = null;
        int max = -1;
        ArrayList<InternalDistributedMember> nodesOfEqualSize = new ArrayList<InternalDistributedMember>();
        for (Map.Entry<InternalDistributedMember, HashSet<Integer>> entry : entrySet) {
            HashSet buckets = new HashSet();
            buckets.addAll(entry.getValue());
            buckets.removeAll(currentBucketSet);
            if (max < buckets.size()) {
                max = buckets.size();
                node = entry.getKey();
                nodesOfEqualSize.clear();
                nodesOfEqualSize.add(node);
                continue;
            }
            if (max != buckets.size()) continue;
            nodesOfEqualSize.add(node);
        }
        return nodesOfEqualSize.size() > 0 ? (InternalDistributedMember)nodesOfEqualSize.get(PartitionedRegion.rand.nextInt(nodesOfEqualSize.size())) : null;
    }

    public static HashMap<Integer, HashSet> groupByBucket(PartitionedRegion pr, Set routingKeys, boolean primaryMembersNeeded, boolean hasRoutingObjects, boolean isBucketSetAsFilter) {
        HashMap<Integer, HashSet> bucketToKeysMap = new HashMap<Integer, HashSet>();
        for (Object key : routingKeys) {
            Integer bucketId = isBucketSetAsFilter ? (Integer)key : (hasRoutingObjects ? Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, key)) : Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, Operation.FUNCTION_EXECUTION, key, null, null)));
            InternalDistributedMember mem = null;
            mem = primaryMembersNeeded ? pr.getOrCreateNodeForBucketWrite(bucketId, null) : pr.getOrCreateNodeForBucketRead(bucketId);
            if (mem == null) {
                throw new FunctionException(LocalizedStrings.PartitionedRegion_NO_TARGET_NODE_FOUND_FOR_KEY_0.toLocalizedString(key));
            }
            HashSet bucketKeys = bucketToKeysMap.get(bucketId);
            if (bucketKeys == null) {
                bucketKeys = new HashSet();
                bucketToKeysMap.put(bucketId, bucketKeys);
            }
            bucketKeys.add(key);
        }
        return bucketToKeysMap;
    }

    public static HashSet<Integer> getBucketSet(PartitionedRegion pr, Set routingKeys, boolean hasRoutingObjects, boolean isBucketSetAsFilter) {
        HashSet<Integer> bucketSet = null;
        for (Object key : routingKeys) {
            Integer bucketId = isBucketSetAsFilter ? (Integer)key : (hasRoutingObjects ? Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, key)) : Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, Operation.FUNCTION_EXECUTION, key, null, null)));
            if (bucketSet == null) {
                bucketSet = new HashSet<Integer>();
            }
            bucketSet.add(bucketId);
        }
        return bucketSet;
    }

    public static HashMap<InternalDistributedMember, HashSet<Integer>> groupByMemberToBuckets(PartitionedRegion pr, Set<Integer> bucketSet, boolean primaryOnly) {
        if (primaryOnly) {
            HashMap<InternalDistributedMember, HashSet<Integer>> memberToBucketsMap = new HashMap<InternalDistributedMember, HashSet<Integer>>();
            try {
                for (Integer bucketId : bucketSet) {
                    InternalDistributedMember mem = pr.getOrCreateNodeForBucketWrite(bucketId, null);
                    HashSet<Integer> buckets = memberToBucketsMap.get(mem);
                    if (buckets == null) {
                        buckets = new HashSet();
                        memberToBucketsMap.put(mem, buckets);
                    }
                    buckets.add(bucketId);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return memberToBucketsMap;
        }
        return FunctionExecutionNodePruner.pruneNodes(pr, bucketSet);
    }
}

