/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.control.ResourceMonitor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.MemoryUsageListener;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class OffHeapMemoryMonitor
implements ResourceMonitor,
MemoryUsageListener {
    private static final Logger logger = LogService.getLogger();
    private volatile MemoryThresholds thresholds = new MemoryThresholds(0L);
    private volatile MemoryEvent mostRecentEvent = new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, MemoryThresholds.MemoryState.DISABLED, MemoryThresholds.MemoryState.DISABLED, null, 0L, true, this.thresholds);
    private volatile MemoryThresholds.MemoryState currentState = MemoryThresholds.MemoryState.DISABLED;
    Boolean started = false;
    private boolean hasEvictionThreshold = false;
    private Thread memoryListenerThread;
    private final OffHeapMemoryUsageListener offHeapMemoryUsageListener;
    private final InternalResourceManager resourceManager;
    private final ResourceAdvisor resourceAdvisor;
    private final GemFireCacheImpl cache;
    private final ResourceManagerStats stats;
    private final MemoryAllocator memoryAllocator;
    public volatile OffHeapMemoryMonitorObserver testHook;
    private volatile boolean deliverNextAbnormalEvent = false;

    OffHeapMemoryMonitor(InternalResourceManager resourceManager, GemFireCacheImpl cache, MemoryAllocator memoryAllocator, ResourceManagerStats stats) {
        this.resourceManager = resourceManager;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        this.cache = cache;
        this.stats = stats;
        this.memoryAllocator = memoryAllocator;
        if (memoryAllocator != null) {
            this.thresholds = new MemoryThresholds(this.memoryAllocator.getTotalMemory());
        }
        this.offHeapMemoryUsageListener = new OffHeapMemoryUsageListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitoring() {
        OffHeapMemoryMonitor offHeapMemoryMonitor = this;
        synchronized (offHeapMemoryMonitor) {
            if (this.started.booleanValue()) {
                return;
            }
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("OffHeapMemoryMonitor Threads", logger);
            Thread t = new Thread((ThreadGroup)group, this.offHeapMemoryUsageListener);
            t.setName(t.getName() + " OffHeapMemoryListener");
            t.setPriority(10);
            t.setDaemon(true);
            t.start();
            this.memoryListenerThread = t;
            this.memoryAllocator.addMemoryUsageListener(this);
            this.started = true;
        }
    }

    @Override
    public void stopMonitoring() {
        this.stopMonitoring(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring(boolean waitForThread) {
        Thread threadToWaitFor = null;
        OffHeapMemoryMonitor offHeapMemoryMonitor = this;
        synchronized (offHeapMemoryMonitor) {
            if (!this.started.booleanValue()) {
                return;
            }
            this.memoryAllocator.removeMemoryUsageListener(this);
            this.offHeapMemoryUsageListener.stop();
            if (waitForThread) {
                threadToWaitFor = this.memoryListenerThread;
            }
            this.memoryListenerThread = null;
            this.started = false;
        }
        if (threadToWaitFor != null) {
            try {
                threadToWaitFor.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void updateMemoryUsed(long bytesUsed) {
        boolean willSendEvent = this.mightSendEvent(bytesUsed);
        OffHeapMemoryMonitorObserver _testHook = this.testHook;
        if (_testHook != null) {
            _testHook.beginUpdateMemoryUsed(bytesUsed, willSendEvent);
        }
        if (!willSendEvent) {
            return;
        }
        this.offHeapMemoryUsageListener.deliverEvent();
        if (_testHook != null) {
            _testHook.afterNotifyUpdateMemoryUsed(bytesUsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCriticalThreshold(float criticalThreshold) {
        OffHeapMemoryMonitor offHeapMemoryMonitor = this;
        synchronized (offHeapMemoryMonitor) {
            if (criticalThreshold == this.thresholds.getCriticalThreshold()) {
                return;
            }
            if (criticalThreshold > 100.0f || criticalThreshold < 0.0f) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
            }
            if (this.memoryAllocator == null) {
                throw new IllegalStateException(LocalizedStrings.OffHeapMemoryMonitor_NO_OFF_HEAP_MEMORY_HAS_BEEN_CONFIGURED.toLocalizedString());
            }
            if (criticalThreshold != 0.0f && this.thresholds.isEvictionThresholdEnabled() && criticalThreshold <= this.thresholds.getEvictionThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GTE_EVICTION_PERCENTAGE.toLocalizedString());
            }
            this.cache.setQueryMonitorRequiredForResourceManager(criticalThreshold != 0.0f);
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), criticalThreshold, this.thresholds.getEvictionThreshold());
            this.updateStateAndSendEvent(this.getBytesUsed());
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeOffHeapCriticalThreshold(this.thresholds.getCriticalThresholdBytes());
        }
    }

    float getCriticalThreshold() {
        return this.thresholds.getCriticalThreshold();
    }

    public boolean hasEvictionThreshold() {
        return this.hasEvictionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEvictionThreshold(float evictionThreshold) {
        this.hasEvictionThreshold = true;
        OffHeapMemoryMonitor offHeapMemoryMonitor = this;
        synchronized (offHeapMemoryMonitor) {
            if (evictionThreshold == this.thresholds.getEvictionThreshold()) {
                return;
            }
            if (evictionThreshold > 100.0f || evictionThreshold < 0.0f) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_EVICTION_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
            }
            if (this.memoryAllocator == null) {
                throw new IllegalStateException(LocalizedStrings.OffHeapMemoryMonitor_NO_OFF_HEAP_MEMORY_HAS_BEEN_CONFIGURED.toLocalizedString());
            }
            if (evictionThreshold != 0.0f && this.thresholds.isCriticalThresholdEnabled() && evictionThreshold >= this.thresholds.getCriticalThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryMonitor_EVICTION_PERCENTAGE_LTE_CRITICAL_PERCENTAGE.toLocalizedString());
            }
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), this.thresholds.getCriticalThreshold(), evictionThreshold);
            this.updateStateAndSendEvent(this.getBytesUsed());
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeOffHeapEvictionThreshold(this.thresholds.getEvictionThresholdBytes());
        }
    }

    public float getEvictionThreshold() {
        return this.thresholds.getEvictionThreshold();
    }

    public boolean updateStateAndSendEvent() {
        return this.updateStateAndSendEvent(this.getBytesUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStateAndSendEvent(long bytesUsed) {
        boolean result = false;
        OffHeapMemoryMonitor offHeapMemoryMonitor = this;
        synchronized (offHeapMemoryMonitor) {
            MemoryEvent mre = this.mostRecentEvent;
            MemoryThresholds.MemoryState oldState = mre.getState();
            MemoryThresholds thresholds = this.thresholds;
            OffHeapMemoryMonitorObserver _testHook = this.testHook;
            MemoryThresholds.MemoryState newState = thresholds.computeNextState(oldState, bytesUsed);
            if (oldState != newState) {
                this.currentState = newState;
                MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, thresholds);
                if (_testHook != null) {
                    _testHook.updateStateAndSendEventBeforeProcess(bytesUsed, event);
                }
                this.mostRecentEvent = event;
                this.processLocalEvent(event);
                this.updateStatsFromEvent(event);
                result = true;
            } else if (!oldState.isNormal() && bytesUsed != mre.getBytesUsed() && this.deliverNextAbnormalEvent) {
                this.deliverNextAbnormalEvent = false;
                MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, thresholds);
                if (_testHook != null) {
                    _testHook.updateStateAndSendEventBeforeAbnormalProcess(bytesUsed, event);
                }
                this.mostRecentEvent = event;
                this.processLocalEvent(event);
                result = true;
            } else if (_testHook != null) {
                _testHook.updateStateAndSendEventIgnore(bytesUsed, oldState, newState, mre.getBytesUsed(), this.deliverNextAbnormalEvent);
            }
        }
        return result;
    }

    private boolean mightSendEvent(long bytesUsed) {
        MemoryThresholds thresholds;
        MemoryThresholds.MemoryState newState;
        MemoryEvent mre = this.mostRecentEvent;
        MemoryThresholds.MemoryState oldState = mre.getState();
        if (oldState != (newState = (thresholds = mre.getThresholds()).computeNextState(oldState, bytesUsed))) {
            return true;
        }
        return !oldState.isNormal() && bytesUsed != mre.getBytesUsed() && this.deliverNextAbnormalEvent;
    }

    void deliverNextAbnormalEvent() {
        this.deliverNextAbnormalEvent = true;
    }

    private void updateStatsFromEvent(MemoryEvent event) {
        if (event.isLocal()) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
                this.stats.incOffHeapCriticalEvents();
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
                this.stats.incOffHeapSafeEvents();
            }
            if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
                this.stats.incOffHeapEvictionStartEvents();
            } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
                this.stats.incOffHeapEvictionStopEvents();
            }
        }
    }

    @Override
    public void fillInProfile(ResourceAdvisor.ResourceManagerProfile profile) {
        MemoryEvent eventToPopulate = this.mostRecentEvent;
        profile.setOffHeapData(eventToPopulate.getBytesUsed(), eventToPopulate.getState(), eventToPopulate.getThresholds());
    }

    public MemoryThresholds.MemoryState getState() {
        return this.currentState;
    }

    public MemoryThresholds getThresholds() {
        MemoryThresholds saveThresholds = this.thresholds;
        return new MemoryThresholds(saveThresholds.getMaxMemoryBytes(), saveThresholds.getCriticalThreshold(), saveThresholds.getEvictionThreshold());
    }

    public long getBytesUsed() {
        if (this.memoryAllocator == null) {
            return 0L;
        }
        return this.memoryAllocator.getUsedMemory();
    }

    void processLocalEvent(MemoryEvent event) {
        assert (event.isLocal());
        if (logger.isDebugEnabled()) {
            logger.debug("Handling new local event {}", (Object)event);
        }
        if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_CRITICAL_THRESHOLD, new Object[]{event.getMember(), "off-heap"}));
        } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.MemoryMonitor_MEMBER_BELOW_CRITICAL_THRESHOLD, new Object[]{event.getMember(), "off-heap"}));
        }
        if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_HIGH_THRESHOLD, new Object[]{event.getMember(), "off-heap"}));
        } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.MemoryMonitor_MEMBER_BELOW_HIGH_THRESHOLD, new Object[]{event.getMember(), "off-heap"}));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Informing remote members of event {}", (Object)event);
        }
        this.resourceAdvisor.updateRemoteProfile();
        this.resourceManager.deliverLocalEvent(event);
    }

    @Override
    public void notifyListeners(Set<ResourceListener> listeners, ResourceEvent event) {
        for (ResourceListener listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (CancelException cancelException) {
            }
            catch (Throwable t) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.MemoryMonitor_EXCEPTION_OCCURED_WHEN_NOTIFYING_LISTENERS), t);
            }
        }
    }

    public String toString() {
        return "OffHeapMemoryMonitor [thresholds=" + this.thresholds + ", mostRecentEvent=" + this.mostRecentEvent + "]";
    }

    class OffHeapMemoryUsageListener
    implements Runnable {
        private boolean deliverEvent = false;
        private boolean stopRequested = false;

        OffHeapMemoryUsageListener() {
        }

        public synchronized void deliverEvent() {
            this.deliverEvent = true;
            this.notifyAll();
        }

        public synchronized void stop() {
            this.stopRequested = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("OffHeapMemoryUsageListener is starting {}", (Object)this);
            }
            int callsWithNoEvent = 0;
            int MS_TIMEOUT = 10;
            int MAX_CALLS_WITH_NO_EVENT = 100;
            boolean exitRunLoop = false;
            while (!exitRunLoop) {
                if (!OffHeapMemoryMonitor.this.updateStateAndSendEvent()) {
                    if (++callsWithNoEvent > 100) {
                        OffHeapMemoryMonitor.this.deliverNextAbnormalEvent();
                        callsWithNoEvent = 0;
                    }
                } else {
                    callsWithNoEvent = 0;
                }
                OffHeapMemoryUsageListener offHeapMemoryUsageListener = this;
                synchronized (offHeapMemoryUsageListener) {
                    if (this.stopRequested) {
                        exitRunLoop = true;
                    } else if (this.deliverEvent) {
                        this.deliverEvent = false;
                    } else {
                        try {
                            this.wait(10L);
                            this.deliverEvent = false;
                        }
                        catch (InterruptedException iex) {
                            logger.warn("OffHeapMemoryUsageListener was interrupted {}", (Object)this);
                            this.stopRequested = true;
                            exitRunLoop = true;
                        }
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("OffHeapMemoryUsageListener is stopping {}", (Object)this);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append(" Thread").append(" #").append(System.identityHashCode(this));
            return sb.toString();
        }
    }

    public static interface OffHeapMemoryMonitorObserver {
        public void beginUpdateMemoryUsed(long var1, boolean var3);

        public void afterNotifyUpdateMemoryUsed(long var1);

        public void beginUpdateStateAndSendEvent(long var1, boolean var3);

        public void updateStateAndSendEventBeforeProcess(long var1, MemoryEvent var3);

        public void updateStateAndSendEventBeforeAbnormalProcess(long var1, MemoryEvent var3);

        public void updateStateAndSendEventIgnore(long var1, MemoryThresholds.MemoryState var3, MemoryThresholds.MemoryState var4, long var5, boolean var7);
    }
}

