/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.apache.geode.CancelException;
import org.apache.geode.Statistics;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SetUtils;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.control.ResourceMonitor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.LocalStatListener;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HeapMemoryMonitor
implements NotificationListener,
ResourceMonitor {
    private static final Logger logger = LogService.getLogger();
    private static final String HEAP_POOL = System.getProperty("gemfire.ResourceManager.HEAP_POOL");
    public static final String POLLER_INTERVAL_PROP = "gemfire.heapPollerInterval";
    private static final int POLLER_INTERVAL = Integer.getInteger("gemfire.heapPollerInterval", 500);
    private ThreadLocal<MemoryEvent> upcomingEvent = new ThreadLocal();
    private ScheduledExecutorService pollerExecutor;
    private final LocalStatListener statListener = new LocalHeapStatListener();
    private static final int memoryStateChangeTolerance;
    private static final MemoryPoolMXBean tenuredMemoryPoolMXBean;
    private static final long tenuredPoolMaxMemory;
    private volatile MemoryThresholds thresholds = new MemoryThresholds(tenuredPoolMaxMemory);
    private volatile MemoryEvent mostRecentEvent = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, MemoryThresholds.MemoryState.DISABLED, MemoryThresholds.MemoryState.DISABLED, null, 0L, true, this.thresholds);
    private volatile MemoryThresholds.MemoryState currentState = MemoryThresholds.MemoryState.DISABLED;
    private Boolean started = false;
    private boolean hasEvictionThreshold = false;
    private int criticalToleranceCounter;
    private int evictionToleranceCounter;
    private final InternalResourceManager resourceManager;
    private final ResourceAdvisor resourceAdvisor;
    private final GemFireCacheImpl cache;
    private final ResourceManagerStats stats;
    private static boolean testDisableMemoryUpdates;
    private static long testBytesUsedForThresholdSet;

    static boolean isTenured(MemoryPoolMXBean memoryPoolMXBean) {
        if (memoryPoolMXBean.getType() != MemoryType.HEAP) {
            return false;
        }
        String name = memoryPoolMXBean.getName();
        return name.equals("CMS Old Gen") || name.equals("PS Old Gen") || name.equals("G1 Old Gen") || name.equals("Old Space") || name.equals("Tenured Gen") || name.equals("Java heap") || name.equals("GenPauseless Old Gen") || HEAP_POOL != null && name.equals(HEAP_POOL);
    }

    HeapMemoryMonitor(InternalResourceManager resourceManager, GemFireCacheImpl cache, ResourceManagerStats stats) {
        this.resourceManager = resourceManager;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        this.cache = cache;
        this.stats = stats;
    }

    public static MemoryPoolMXBean getTenuredMemoryPoolMXBean() {
        if (tenuredMemoryPoolMXBean != null) {
            return tenuredMemoryPoolMXBean;
        }
        throw new IllegalStateException(LocalizedStrings.HeapMemoryMonitor_NO_POOL_FOUND_POOLS_0.toLocalizedString(HeapMemoryMonitor.getAllMemoryPoolNames()));
    }

    private static String getAllMemoryPoolNames() {
        StringBuilder builder = new StringBuilder("[");
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getMemoryPoolMXBeans()) {
            builder.append("(Name=").append(memoryPoolBean.getName()).append(";Type=").append((Object)memoryPoolBean.getType()).append(";UsageThresholdSupported=").append(memoryPoolBean.isUsageThresholdSupported()).append("), ");
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitoring() {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (this.started.booleanValue()) {
                return;
            }
            boolean statListenerStarted = this.startCacheStatListener();
            if (!statListenerStarted) {
                this.startMemoryPoolPoller();
            }
            this.startJVMThresholdListener();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitoring() {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (!this.started.booleanValue()) {
                return;
            }
            this.resourceManager.stopExecutor(this.pollerExecutor);
            NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
            try {
                emitter.removeNotificationListener(this, null, null);
                this.cache.getLoggerI18n().fine("Removed Memory MXBean notification listener" + this);
            }
            catch (ListenerNotFoundException e) {
                this.cache.getLoggerI18n().fine("This instance '" + this.toString() + "' was not registered as a Memory MXBean listener");
            }
            GemFireStatSampler sampler = this.cache.getDistributedSystem().getStatSampler();
            if (sampler != null) {
                sampler.removeLocalStatListener(this.statListener);
            }
            this.started = false;
        }
    }

    private boolean startCacheStatListener() {
        GemFireStatSampler sampler = this.cache.getDistributedSystem().getStatSampler();
        if (sampler == null) {
            return false;
        }
        try {
            sampler.waitForInitialization();
            String tenuredPoolName = HeapMemoryMonitor.getTenuredMemoryPoolMXBean().getName();
            List<Statistics> list = this.cache.getDistributedSystem().getStatsList();
            for (Statistics o : list) {
                StatisticsImpl si;
                if (!(o instanceof StatisticsImpl) || !(si = (StatisticsImpl)o).getTextId().contains(tenuredPoolName) || !si.getType().getName().contains("PoolStats")) continue;
                sampler.addLocalStatListener(this.statListener, si, "currentUsedMemory");
                if (this.cache.getLoggerI18n().fineEnabled()) {
                    this.cache.getLoggerI18n().fine("Registered stat listener for " + si.getTextId());
                }
                return true;
            }
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
            this.cache.getCancelCriterion().checkCancelInProgress(iex);
        }
        return false;
    }

    private void startMemoryPoolPoller() {
        if (tenuredMemoryPoolMXBean == null) {
            return;
        }
        final LoggingThreadGroup threadGroup = LoggingThreadGroup.createThreadGroup("HeapPoller", logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r, "GemfireHeapPoller");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.pollerExecutor = Executors.newScheduledThreadPool(1, threadFactory);
        this.pollerExecutor.scheduleAtFixedRate(new HeapPoller(), POLLER_INTERVAL, POLLER_INTERVAL, TimeUnit.MILLISECONDS);
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("Started GemfireHeapPoller to poll the heap every " + POLLER_INTERVAL + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCriticalThreshold(float criticalThreshold) {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (criticalThreshold == this.thresholds.getCriticalThreshold()) {
                return;
            }
            if (criticalThreshold > 100.0f || criticalThreshold < 0.0f) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
            }
            if (HeapMemoryMonitor.getTenuredMemoryPoolMXBean() == null) {
                throw new IllegalStateException(LocalizedStrings.HeapMemoryMonitor_NO_POOL_FOUND_POOLS_0.toLocalizedString(HeapMemoryMonitor.getAllMemoryPoolNames()));
            }
            if (criticalThreshold != 0.0f && this.thresholds.isEvictionThresholdEnabled() && criticalThreshold <= this.thresholds.getEvictionThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_CRITICAL_PERCENTAGE_GTE_EVICTION_PERCENTAGE.toLocalizedString());
            }
            this.cache.setQueryMonitorRequiredForResourceManager(criticalThreshold != 0.0f);
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), criticalThreshold, this.thresholds.getEvictionThreshold());
            this.updateStateAndSendEvent();
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeCriticalThreshold(this.thresholds.getCriticalThresholdBytes());
        }
    }

    float getCriticalThreshold() {
        return this.thresholds.getCriticalThreshold();
    }

    public boolean hasEvictionThreshold() {
        return this.hasEvictionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEvictionThreshold(float evictionThreshold) {
        this.hasEvictionThreshold = true;
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (evictionThreshold == this.thresholds.getEvictionThreshold()) {
                return;
            }
            if (evictionThreshold > 100.0f || evictionThreshold < 0.0f) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryThresholds_EVICTION_PERCENTAGE_GT_ZERO_AND_LTE_100.toLocalizedString());
            }
            if (HeapMemoryMonitor.getTenuredMemoryPoolMXBean() == null) {
                throw new IllegalStateException(LocalizedStrings.HeapMemoryMonitor_NO_POOL_FOUND_POOLS_0.toLocalizedString(HeapMemoryMonitor.getAllMemoryPoolNames()));
            }
            if (evictionThreshold != 0.0f && this.thresholds.isCriticalThresholdEnabled() && evictionThreshold >= this.thresholds.getCriticalThreshold()) {
                throw new IllegalArgumentException(LocalizedStrings.MemoryMonitor_EVICTION_PERCENTAGE_LTE_CRITICAL_PERCENTAGE.toLocalizedString());
            }
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), this.thresholds.getCriticalThreshold(), evictionThreshold);
            this.updateStateAndSendEvent();
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeEvictionThreshold(this.thresholds.getEvictionThresholdBytes());
        }
    }

    public float getEvictionThreshold() {
        return this.thresholds.getEvictionThreshold();
    }

    public void updateStateAndSendEvent() {
        this.updateStateAndSendEvent(testBytesUsedForThresholdSet != -1L ? testBytesUsedForThresholdSet : this.getBytesUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateAndSendEvent(long bytesUsed) {
        this.stats.changeTenuredHeapUsed(bytesUsed);
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            MemoryThresholds.MemoryState oldState = this.mostRecentEvent.getState();
            MemoryThresholds.MemoryState newState = this.thresholds.computeNextState(oldState, bytesUsed);
            if (oldState != newState) {
                this.setUsageThresholdOnMXBean(bytesUsed);
                if (!this.skipEventDueToToleranceLimits(oldState, newState)) {
                    this.currentState = newState;
                    MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, this.thresholds);
                    this.upcomingEvent.set(event);
                    this.processLocalEvent(event);
                    this.updateStatsFromEvent(event);
                }
            } else if (!oldState.isNormal() && bytesUsed != this.mostRecentEvent.getBytesUsed()) {
                MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, this.thresholds);
                this.upcomingEvent.set(event);
                this.processLocalEvent(event);
            }
        }
    }

    private void updateStatsFromEvent(MemoryEvent event) {
        if (event.isLocal()) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
                this.stats.incHeapCriticalEvents();
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
                this.stats.incHeapSafeEvents();
            }
            if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
                this.stats.incEvictionStartEvents();
            } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
                this.stats.incEvictionStopEvents();
            }
        }
    }

    @Override
    public void fillInProfile(ResourceAdvisor.ResourceManagerProfile profile) {
        MemoryEvent tempEvent = this.upcomingEvent.get();
        if (tempEvent != null) {
            this.mostRecentEvent = tempEvent;
            this.upcomingEvent.set(null);
        }
        MemoryEvent eventToPopulate = this.mostRecentEvent;
        profile.setHeapData(eventToPopulate.getBytesUsed(), eventToPopulate.getState(), eventToPopulate.getThresholds());
    }

    public MemoryThresholds.MemoryState getState() {
        return this.currentState;
    }

    public MemoryThresholds getThresholds() {
        MemoryThresholds saveThresholds = this.thresholds;
        return new MemoryThresholds(saveThresholds.getMaxMemoryBytes(), saveThresholds.getCriticalThreshold(), saveThresholds.getEvictionThreshold());
    }

    private void setUsageThresholdOnMXBean(long bytesUsed) {
    }

    void startJVMThresholdListener() {
        MemoryPoolMXBean memoryPoolMXBean = HeapMemoryMonitor.getTenuredMemoryPoolMXBean();
        if (!testDisableMemoryUpdates) {
            memoryPoolMXBean.setCollectionUsageThreshold(1L);
        }
        long usageThreshold = memoryPoolMXBean.getUsageThreshold();
        this.cache.getLoggerI18n().info(LocalizedStrings.HeapMemoryMonitor_OVERRIDDING_MEMORYPOOLMXBEAN_HEAP_0_NAME_1, new Object[]{usageThreshold, memoryPoolMXBean.getName()});
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(this, null, null);
    }

    private boolean skipEventDueToToleranceLimits(MemoryThresholds.MemoryState oldState, MemoryThresholds.MemoryState newState) {
        if (testDisableMemoryUpdates) {
            return false;
        }
        if (newState.isEviction() && !oldState.isEviction()) {
            ++this.evictionToleranceCounter;
            this.criticalToleranceCounter = 0;
            if (this.evictionToleranceCounter <= memoryStateChangeTolerance) {
                if (this.cache.getLoggerI18n().fineEnabled()) {
                    this.cache.getLoggerI18n().fine("State " + (Object)((Object)newState) + " ignored. toleranceCounter:" + this.evictionToleranceCounter + " MEMORY_EVENT_TOLERANCE:" + memoryStateChangeTolerance);
                }
                return true;
            }
        } else if (newState.isCritical()) {
            ++this.criticalToleranceCounter;
            this.evictionToleranceCounter = 0;
            if (this.criticalToleranceCounter <= memoryStateChangeTolerance) {
                if (this.cache.getLoggerI18n().fineEnabled()) {
                    this.cache.getLoggerI18n().fine("State " + (Object)((Object)newState) + " ignored. toleranceCounter:" + this.criticalToleranceCounter + " MEMORY_EVENT_TOLERANCE:" + memoryStateChangeTolerance);
                }
                return true;
            }
        } else {
            this.criticalToleranceCounter = 0;
            this.evictionToleranceCounter = 0;
            if (this.cache.getLoggerI18n().fineEnabled()) {
                this.cache.getLoggerI18n().fine("TOLERANCE counters reset");
            }
        }
        return false;
    }

    public long getBytesUsed() {
        return HeapMemoryMonitor.getTenuredMemoryPoolMXBean().getUsage().getUsed();
    }

    public static long getTenuredPoolMaxMemory() {
        return tenuredPoolMaxMemory;
    }

    synchronized void processLocalEvent(MemoryEvent event) {
        assert (event.isLocal());
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("Handling new local event " + event);
        }
        if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
            this.cache.getLoggerI18n().error(LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_CRITICAL_THRESHOLD, new Object[]{event.getMember(), "heap"});
            if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                QueryMonitor.setLowMemory(true, event.getBytesUsed());
                this.cache.getQueryMonitor().cancelAllQueriesDueToMemory();
            }
        } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
            this.cache.getLoggerI18n().error(LocalizedStrings.MemoryMonitor_MEMBER_BELOW_CRITICAL_THRESHOLD, new Object[]{event.getMember(), "heap"});
            if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                QueryMonitor.setLowMemory(false, event.getBytesUsed());
            }
        }
        if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
            this.cache.getLoggerI18n().info(LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_HIGH_THRESHOLD, new Object[]{event.getMember(), "heap"});
        } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
            this.cache.getLoggerI18n().info(LocalizedStrings.MemoryMonitor_MEMBER_BELOW_HIGH_THRESHOLD, new Object[]{event.getMember(), "heap"});
        }
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("Informing remote members of event " + event);
        }
        this.resourceAdvisor.updateRemoteProfile();
        this.resourceManager.deliverLocalEvent(event);
    }

    @Override
    public void notifyListeners(Set<ResourceListener> listeners, ResourceEvent event) {
        for (ResourceListener listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (CancelException cancelException) {
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError(err = (Error)t)) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                SystemFailure.checkFailure();
                this.cache.getLoggerI18n().error(LocalizedStrings.MemoryMonitor_EXCEPTION_OCCURED_WHEN_NOTIFYING_LISTENERS, t);
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object callback) {
        this.resourceManager.runWithNotifyExecutor(new Runnable(){

            @Override
            public void run() {
                if (!testDisableMemoryUpdates) {
                    HeapMemoryMonitor.this.updateStateAndSendEvent();
                }
            }
        });
    }

    public boolean containsHeapCriticalMembers(Set<InternalDistributedMember> members) {
        if (members.contains(this.cache.getMyId()) && this.mostRecentEvent.getState().isCritical()) {
            return true;
        }
        return SetUtils.intersectsWith(members, this.resourceAdvisor.adviseCritialMembers());
    }

    public final boolean isMemberHeapCritical(InternalDistributedMember member) {
        if (member.equals(this.cache.getMyId())) {
            return this.mostRecentEvent.getState().isCritical();
        }
        return this.resourceAdvisor.isHeapCritical(member);
    }

    public String toString() {
        return "HeapMemoryMonitor [thresholds=" + this.thresholds + ", mostRecentEvent=" + this.mostRecentEvent + ", criticalToleranceCounter=" + this.criticalToleranceCounter + ", evictionToleranceCounter=" + this.evictionToleranceCounter + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestMaxMemoryBytes(long testMaxMemoryBytes) {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            MemoryThresholds newThresholds = testMaxMemoryBytes == 0L ? new MemoryThresholds(HeapMemoryMonitor.getTenuredPoolMaxMemory()) : new MemoryThresholds(testMaxMemoryBytes, this.thresholds.getCriticalThreshold(), this.thresholds.getEvictionThreshold());
            this.thresholds = newThresholds;
            StringBuilder builder = new StringBuilder("In testing, the following values were set");
            builder.append(" maxMemoryBytes:" + newThresholds.getMaxMemoryBytes());
            builder.append(" criticalThresholdBytes:" + newThresholds.getCriticalThresholdBytes());
            builder.append(" evictionThresholdBytes:" + newThresholds.getEvictionThresholdBytes());
            this.cache.getLoggerI18n().fine(builder.toString());
        }
    }

    public static void setTestDisableMemoryUpdates(boolean newTestDisableMemoryUpdates) {
        testDisableMemoryUpdates = newTestDisableMemoryUpdates;
    }

    public static void setTestBytesUsedForThresholdSet(long newTestBytesUsedForThresholdSet) {
        testBytesUsedForThresholdSet = newTestBytesUsedForThresholdSet;
    }

    static {
        String vendor = System.getProperty("java.vendor");
        memoryStateChangeTolerance = vendor.contains("Sun") || vendor.contains("Oracle") ? Integer.getInteger("gemfire.memoryEventTolerance", 1).intValue() : Integer.getInteger("gemfire.memoryEventTolerance", 5).intValue();
        MemoryPoolMXBean matchingMemoryPoolMXBean = null;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPoolMXBean.isUsageThresholdSupported() || !HeapMemoryMonitor.isTenured(memoryPoolMXBean)) continue;
            matchingMemoryPoolMXBean = memoryPoolMXBean;
            break;
        }
        if ((tenuredMemoryPoolMXBean = matchingMemoryPoolMXBean) == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.HeapMemoryMonitor_NO_POOL_FOUND_POOLS_0, HeapMemoryMonitor.getAllMemoryPoolNames()));
        }
        if (tenuredMemoryPoolMXBean != null && tenuredMemoryPoolMXBean.getUsage().getMax() != -1L) {
            tenuredPoolMaxMemory = tenuredMemoryPoolMXBean.getUsage().getMax();
        } else {
            long calculatedMaxMemory = Runtime.getRuntime().maxMemory();
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean p : pools) {
                if (p.getType() != MemoryType.HEAP || p.getUsage().getMax() == -1L) continue;
                calculatedMaxMemory -= p.getUsage().getMax();
            }
            tenuredPoolMaxMemory = calculatedMaxMemory;
        }
        testDisableMemoryUpdates = false;
        testBytesUsedForThresholdSet = -1L;
    }

    class HeapPoller
    implements Runnable {
        HeapPoller() {
        }

        @Override
        public void run() {
            if (testDisableMemoryUpdates) {
                return;
            }
            try {
                HeapMemoryMonitor.this.updateStateAndSendEvent(HeapMemoryMonitor.this.getBytesUsed());
            }
            catch (Exception e) {
                HeapMemoryMonitor.this.cache.getLoggerI18n().fine("Poller Thread caught exception:", e);
            }
        }
    }

    class LocalHeapStatListener
    implements LocalStatListener {
        LocalHeapStatListener() {
        }

        @Override
        public void statValueChanged(double value) {
            final long usedBytes = (long)value;
            try {
                HeapMemoryMonitor.this.resourceManager.runWithNotifyExecutor(new Runnable(){

                    @Override
                    public void run() {
                        if (!testDisableMemoryUpdates) {
                            HeapMemoryMonitor.this.updateStateAndSendEvent(usedBytes);
                        }
                    }
                });
                if (HeapMemoryMonitor.this.cache.getLoggerI18n().fineEnabled()) {
                    HeapMemoryMonitor.this.cache.getLoggerI18n().fine("StatSampler scheduled a handleNotification call with " + usedBytes + " bytes");
                }
            }
            catch (RejectedExecutionException e) {
                if (!HeapMemoryMonitor.this.resourceManager.isClosed()) {
                    HeapMemoryMonitor.this.cache.getLoggerI18n().warning(LocalizedStrings.ResourceManager_REJECTED_EXECUTION_CAUSE_NOHEAP_EVENTS);
                }
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }
}

