/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMThinRegionEntry;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.VMThinRegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedThinRegionEntryHeap;

public abstract class VMThinRegionEntryHeap
extends VMThinRegionEntry {
    private static final VMThinRegionEntryHeapFactory factory = new VMThinRegionEntryHeapFactory();

    public VMThinRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

