/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinDiskLRURegionEntryOffHeapLongKey
extends VMThinDiskLRURegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinDiskLRURegionEntryOffHeapLongKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinDiskLRURegionEntryOffHeapLongKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VMThinDiskLRURegionEntryOffHeapLongKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VMThinDiskLRURegionEntryOffHeapLongKey.class, "ohAddress");
    protected DiskId id;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private final long key;

    public VMThinDiskLRURegionEntryOffHeapLongKey(RegionEntryContext context, long key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.key = key;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext drs, Object value) {
        boolean isBackup;
        if (drs instanceof LocalRegion) {
            isBackup = ((LocalRegion)drs).getDiskRegion().isBackup();
        } else if (drs instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a LocalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(drs, value);
        }
    }

    @Override
    public final synchronized int updateAsyncEntrySize(EnableLRU capacityController) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
        DiskStoreImpl ds = r.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, ds.needsLinkedList());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public final boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public final void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public final void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public final boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public final void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public final void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public final void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public final LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public final void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public final LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public final int getEntrySize() {
        return this.size;
    }

    protected final void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof Long) {
            return (Long)k == this.key;
        }
        return false;
    }
}

