/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntry;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VMThinDiskLRURegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryOffHeap;

public abstract class VMThinDiskLRURegionEntryOffHeap
extends VMThinDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMThinDiskLRURegionEntryOffHeapFactory factory = new VMThinDiskLRURegionEntryOffHeapFactory();

    public VMThinDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

